#
# GNUPLOT Makefile
#

#
# Atari ST native GCC system
# Jens Tingleff June -91
# Added GNU readline. I don't know/care why it was taken out..

CC = gcc
GEN_SYM = sym-ld
GNULIB = d:\gnu\gcc\lib

# directory where to install executables on 'make install'
DEST=/usr/local/bin
# directory for installing man page on 'make man_install'
MANDEST=/usr/man/manl
# where to install help file gnuplot.gih
#HELPDEST=/usr/local/lib/gnuplot.gih
HELPDEST=docs/gnuplot.gih
# Where to send email about bugs and comments (locally)
EMAIL=\"pixar\!bug-gnuplot@sun.com\"

# -DVFORK if you have vfork()
# -DBCOPY if your memcpy() is called bcopy() (a Berkeleyism, right?)
# -DBZERO if you need to use bzero() (another BSD feature) instead of memset() 
# -DNOCOPY if you don't have a memcpy() by any name
# -DGAMMA if you've got gamma(3)
# -fswitch if you are compiling on a Sun3 (or even -f68881)
#    (but -fswitch is buggy on some systems, so watch out)
# -O if you trust your compiler's optimizer
# -DGNU_READLINE if you have the GNU readline lib.
CFLAGS = -g -O -DGNU_READLINE #-gx #-O

# -lplot if you have -DUNIXPLOT
# -lsuntool -lsunwindow -lpixrect  if you have -DSUN
# -lgl_s if IRIS4D
# -lreadline -ltermcap  for GNU readline.
LIBS = -lpml -lgem -lreadline -ltermcap
LIB881S = -lgem -lreadline -ltermcap -l881

# -D<terminal> in TERMFLAGS iff you wish to support <terminal>
# see other terminal defines in term.h
# -DFIG         Fig graphics language (requires object.h from TransFig)
# -DIRIS4D      IRIS4D series computer
# -DSUN         Sun Microsystems Workstation
# -DUNIXPLOT    unixplot
# -DATARIST	For Atari ST screen.
#   all set in term.h

TERMFLAGS =  -Iterm 

OBJ1S = command.o eval.o graphics.o help.o internal.o misc.o parse.o\
    plot.o scanner.o setshow.o standard.o util.o  

OBJS = $(OBJ1S) term.o 

DIRS = term demo bugtest docs docs/latextut translate
CSOURCE1 = command.c setshow.c 
CSOURCE2 = help.c graphics.c internal.c 
CSOURCE3 = misc.c eval.c parse.c plot.c scanner.c standard.c 
CSOURCE4 = term.c util.c version.c
CSOURCE5 = term/aed.trm term/dxy.trm term/eps60.trm term/epson.trm \
	term/font5x7.trm term/hp26.trm term/hp2648.trm term/hpgl.trm \
	term/hpljet.trm term/iris4d.trm term/latex.trm term/sun.trm
CSOURCE6 = term/post.trm term/pc.trm term/qms.trm term/regis.trm \
	term/tek.trm term/unixpc.trm term/unixplot.trm term/v384.trm \
	term/atarist.trm

CSOURCE7 = term/imPcodes.h term/imagen.trm term/object.h term/fig.trm \
	term/latex.trm term/eepic.trm term/x11.trm gnuplot_x11.c
# not C code, but still needed
ETC = Copyright README README.gnutex makefile.unx makefile.vms  \
	README.x11 makefile.x11 \
	makefile.3b1 plot.h help.h setshow.h term.h lasergnu \
 	demo/1.dat demo/2.dat demo/3.dat demo/controls.demo \
	demo/simple.demo demo/polar.demo demo/electron.demo \
	bugtest/README bugtest/printf.c bugtest/scanf.c \
	bugtest/mscbug.c term/README \
	linkopt.vms buildvms.com
# PC-specific files
PC = corgraph.asm corplot.c header.mac hrcgraph.asm lineproc.mac \
	linkopt.msc linkopt.tc makefile.msc makefile.tc pcgraph.asm 
# Documentation and help files
DOCS1 = docs/Makefile docs/README docs/checkdoc.c docs/doc2gih.c \
	docs/doc2hlp.c docs/doc2hlp.com docs/doc2ms.c docs/doc2tex.c \
	docs/gnuplot.1 docs/lasergnu.1 \
	docs/titlepage.ms docs/titlepage.tex
DOCS2 = docs/gnuplot.doc
DOCS3 = docs/latextut/Makefile docs/latextut/eg1.plt \
	docs/latextut/eg2.plt docs/latextut/eg3.dat docs/latextut/eg3.plt \
	docs/latextut/eg4.plt docs/latextut/eg5.plt docs/latextut/eg6.plt \
	docs/latextut/header.tex docs/latextut/tutorial.tex
# gnutex->gnuplot translator
TSOURCE1 = translate/Makefile translate/README translate/command.c \
	translate/eval.c translate/gnut2p.1 translate/internal.c \
	translate/misc.c translate/parse.c translate/plot.c
TSOURCE2 = \
	translate/plot.h translate/scanner.c translate/standard.c \
	translate/test1 translate/test2 translate/util.c

#all:	gnuplot doc
all: gnuplot


# Don't wait for make to compile term.o
unsafe-gnuplot: $(OBJ1S) version.o
	$(CC) $(CFLAGS) -o gnuplot.prg $(OBJS) version.o $(LIBS)
	xstrip gnuplot.prg

c-unsafe-gnuplot: $(OBJ1S) version.o
	$(CC) $(CFLAGS) -o gnuplot.prg $(OBJS) version.o $(LIB881S)
	xstrip gnuplot.prg

g-unsafe-gnuplot: $(OBJ1S) version.o
	$(CC) $(CFLAGS) -o gnuplot.prg $(OBJS) version.o $(LIBS)
	$(GEN_SYM) -o gnuplot.sym $(GNULIB)/crt0.o $(OBJS) version.o \
	$(LIBS) -lgnu

gnuplot: $(OBJS) version.o
	$(CC) $(CFLAGS) -o gnuplot.prg $(OBJS) version.o $(LIBS)
	$(GEN_SYM) -o gnuplot.sym $(GNULIB)/crt0.o $(OBJS) version.o \
	$(LIBS) -lgnu

doc:
	( cd docs; make gnuplot.gih )

translate:
	(cd translate; make)

install: gnuplot doc man_install
	cp gnuplot lasergnu $(DEST)
	strip $(DEST)/gnuplot
	(cd docs; make install-unix HELPDEST=$(HELPDEST))

man_install: docs/gnuplot.1 docs/lasergnu.1
	cp docs/gnuplot.1 docs/lasergnu.1 $(MANDEST)

term.o: term.h $(CSOURCE4) $(CSOURCE5) $(CSOURCE6) $(CSOURCE7)
	$(CC) $(CFLAGS) $(TERMFLAGS) -c term.c

version.o:
	$(CC) $(CFLAGS) -DCONTACT=$(EMAIL) -c version.c

$(OBJS): plot.h

command.o: command.c
	$(CC) $(CFLAGS) -c command.c -DHELPFILE=\"$(HELPDEST)\"

command.o help.o misc.o: help.h

command.o graphics.o misc.o plot.o setshow.o: setshow.h

SOURCES=plot.h help.h setshow.h $(CSOURCE1) $(CSOURCE2) $(CSOURCE3) \
	$(CSOURCE4) $(CSOURCE5) $(CSOURCE6) $(CSOURCE7)

lint:
	lint -hx $(CSOURCE1) $(CSOURCE2) $(CSOURCE3) $(CSOURCE4)

clean:
	rm -f *.o *~ term/*~ *.sym
	(cd docs; make clean)
	(cd docs/latextut; make clean)
	(cd translate; make clean)

spotless:
	rm -f *.o *~ term/*~ TAGS gnuplot
	(cd docs; make clean)
	(cd docs/latextut; make spotless)
	(cd translate; make spotless)

shar: gnuplot.sh00 gnuplot.sh01 gnuplot.sh02 gnuplot.sh03 gnuplot.sh04 \
	gnuplot.sh05 gnuplot.sh06 gnuplot.sh07 gnuplot.sh08 \
	gnuplot.sh09 gnuplot.sh10 gnuplot.sh11 gnuplot.sh12 \
	gnuplot.sh13 gnuplot.sh14

gnuplot.sh00:
	echo '#!/bin/sh' > gnuplot.sh00
	echo '# This is a shell file to make directories' >> gnuplot.sh00
	echo mkdir $(DIRS) >> gnuplot.sh00

gnuplot.sh01: $(ETC)
	shar $(ETC) > gnuplot.sh01

gnuplot.sh02: $(DOCS1)
	shar $(DOCS1) > gnuplot.sh02

gnuplot.sh03: $(DOCS2)
	shar $(DOCS2) > gnuplot.sh03

gnuplot.sh04: $(DOCS3)
	shar $(DOCS3) > gnuplot.sh04

gnuplot.sh05: $(CSOURCE1)
	shar $(CSOURCE1) > gnuplot.sh05

gnuplot.sh06: $(CSOURCE2)
	shar $(CSOURCE2) > gnuplot.sh06

gnuplot.sh07: $(CSOURCE3)
	shar $(CSOURCE3) > gnuplot.sh07

gnuplot.sh08: $(CSOURCE4)
	shar $(CSOURCE4) > gnuplot.sh08

gnuplot.sh09: $(CSOURCE5)
	shar $(CSOURCE5) > gnuplot.sh09

gnuplot.sh10: $(CSOURCE6)
	shar $(CSOURCE6) > gnuplot.sh10

gnuplot.sh11: $(CSOURCE7)
	shar $(CSOURCE7) > gnuplot.sh11

gnuplot.sh12: $(PC)
	shar $(PC) > gnuplot.sh12

gnuplot.sh13: $(TSOURCE1)
	shar $(TSOURCE1) > gnuplot.sh13

gnuplot.sh14: $(TSOURCE2)
	shar $(TSOURCE2) > gnuplot.sh14

