unit sbtest_2;

{
             A unit for SBTEST.PAS, a testprogram for TzShapeBtn

                      The ZieglerCollection one (TM)
                                Version 1,01

           (C) Copyright 1995,96,97 By ZieglerSoft, all rights reserved
}

Interface

Uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, Mystd, StdCtrls, Animate;

Type
  TForm1 = Class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    zShapeBtn1: TzShapeBtn;
    zShapeBtn2: TzShapeBtn;
    zShapeBtn3: TzShapeBtn;
    zShapeBtn4: TzShapeBtn;
    zShapeBtn5: TzShapeBtn;
    zShapeBtn6: TzShapeBtn;
    zShapeBtn7: TzShapeBtn;
    zShapeBtn8: TzShapeBtn;
    zShapeBtn9: TzShapeBtn;
    zShapeBtn10: TzShapeBtn;
    zShapeBtn11: TzShapeBtn;
    zShapeBtn12: TzShapeBtn;
    zShapeBtn13: TzShapeBtn;
    Procedure zShapeBtn1Click(Sender: TObject);
    Procedure zShapeBtn2Click(Sender: TObject);
    Procedure zShapeBtn3Click(Sender: TObject);
    Procedure zShapeBtn4Click(Sender: TObject);
    Procedure zShapeBtn5Click(Sender: TObject);
    Procedure zShapeBtn6Click(Sender: TObject);
    Procedure zShapeBtn7Click(Sender: TObject);
    Procedure zShapeBtn8Click(Sender: TObject);
    Procedure zShapeBtn9Click(Sender: TObject);
    Procedure zShapeBtn10Click(Sender: TObject);
    Procedure zShapeBtn11Click(Sender: TObject);
    Procedure zShapeBtn12Click(Sender: TObject);
    Procedure zShapeBtn13Click(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure zShapeBtn2OwnerDraw(Sender: TObject; Canvas: TCanvas;
      Down: Boolean; Width, Height: Integer; Region: Word; Shadow,
      Highlight: TColor);
    Procedure zShapeBtn2GetRegion(Sender: TObject; var Region: Word; Width,
      Height: Integer);
  End;

Var
  Form1: TForm1;

Implementation
{$R *.DFM}

Procedure TForm1.zShapeBtn2OwnerDraw(Sender: TObject; Canvas: TCanvas;
  Down: Boolean; Width, Height: Integer; Region: Word; Shadow,
  Highlight: TColor);
  {- in this procedure, we draw the Ownerdraw-TzShapeBtn.}
Var
  H1,H2,H3,V1,V2,V3 : Integer;
Begin
  If Sender=zShapeBtn2 Then With Canvas Do begin
    H1:=(Height-1) Div 3; H2:=H1+H1; H3:=H1+H2;
    V1:=(Width-1) Div 3;  V2:=V1+V1; V3:=V1+V2;
    PaintRgn(Handle,Region);
    Pen.Color:=Shadow;
    PolyLine([Point(0,H3),Point(0,0),Point(V3,0)]);
    PolyLine([Point(V2,H1),Point(V3,H2)]);
    PolyLine([Point(V1,H2),Point(V2,H3)]);
    PolyLine([Point(0,H3-2),Point(V1,H2-2)]);
    PolyLine([Point(V2,H1-2),Point(V3-2,0)]);
    PolyLine([Point(V2-1,H3-1),Point(V3-1,H2-1)]);
    If Down Then Pen.Color:=clBlack Else Pen.Color:=HighLight;
    PolyLine([point(1,H3-4),Point(1,1),Point(V3-3,1)]);
    PolyLine([Point(V1,H2-2),Point(V2,H3-2)]);
    PolyLine([Point(V2,H1+1),Point(V3-1,H2)]);
    If Down Then pen.Color:=HighLight Else pen.Color:=clblack;
    PolyLine([Point(0,H3),Point(v1,H2)]);
    PolyLine([point(V2,H3),Point(V3,H2)]);
    PolyLine([Point(V3,0),Point(V2,H1)]);
  End;
End;

Procedure TForm1.zShapeBtn2GetRegion(Sender: TObject; var Region: Word;
  Width, Height: Integer);
  {- In this procedure, we give the OwnerDraw-TzShapeBtn the information it
     needs to know where the button must be down, and where it must be up,
     when a user clicks the button.}
Var
  fWhere : Array[0..6] of tPoint;
  H1,H2,H3,V1,V2,V3 : Integer;
Begin
  If Sender=zShapeBtn2 Then Begin
    H1:=(Height-1) Div 3; H2:=H1+H1; H3:=H2+H1;
    V1:=(Width-1) Div 3;  V2:=V1+V1; V3:=V2+V1;
    fWhere[0]:=Point(0,0);
    fWhere[1]:=Point(V3,0);
    fWhere[2]:=Point(V2,H1);
    fWhere[3]:=Point(V3,H2);
    fWhere[4]:=Point(V2,H3);
    fWhere[5]:=Point(V1,H2);
    fWhere[6]:=Point(0,H3);
    Region:=CreatePolygonRgn(fWhere,7,Alternate);
  End;
End;

Procedure TForm1.zShapeBtn1Click(Sender: TObject);
Begin
  Label1.Caption:='';
End;

Procedure TForm1.zShapeBtn2Click(Sender: TObject);
Begin
  Label1.Caption:='Can you get the point?';
End;

Procedure TForm1.zShapeBtn3Click(Sender: TObject);
Begin
  Label1.Caption:='You got the point';
End;

Procedure TForm1.zShapeBtn4Click(Sender: TObject);
Begin
  Label1.Caption:='Pointing Down and Right';
End;

Procedure TForm1.zShapeBtn5Click(Sender: TObject);
Begin
  Label1.Caption:='Pointing Up and Right';
End;

Procedure TForm1.zShapeBtn6Click(Sender: TObject);
Begin
  Label1.Caption:='Pointing Down and Left';
End;

Procedure TForm1.zShapeBtn7Click(Sender: TObject);
Begin
  Label1.Caption:='Pointing Up and Left';
End;

Procedure TForm1.zShapeBtn8Click(Sender: TObject);
Begin
  Try
    Label2.Caption:=IntToStr(StrToInt(Label2.Caption)+1);
  Except
    Label2.Caption:='0';
  End;
End;

Procedure TForm1.zShapeBtn9Click(Sender: TObject);
Begin
  Try
    Label2.Caption:=IntToStr(StrToInt(Label2.Caption)-1);
  Except
    Label2.Caption:='0';
  End;
End;

Procedure TForm1.FormCreate(Sender: TObject);
Begin
  Label1.Caption:='Try the buttons';
  Label2.Caption:='0';
End;

procedure TForm1.zShapeBtn11Click(Sender: TObject);
begin
  Try
    Edit1.Text:=IntToStr(StrToInt(Edit1.Text)+1);
  Except
    Edit1.Text:='1';
  End;
end;

procedure TForm1.zShapeBtn10Click(Sender: TObject);
begin
  Try
    Edit1.Text:=IntToStr(StrToInt(Edit1.Text)-1);
  Except
    Edit1.Text:='-1';
  End;
end;

procedure TForm1.zShapeBtn12Click(Sender: TObject);
begin
  Edit1.Text:='0';
end;

procedure TForm1.zShapeBtn13Click(Sender: TObject);
begin
  Try
    If StrToInt(Edit1.Text)<0 then
      Edit1.Text:=IntToStr(-1-MaxLongInt)
    Else
      Edit1.Text:=IntToStr(MaxlongInt);
  Except
    Edit1.Text:=IntToStr(-1-MaxLongInt)
  End;
end;

End.
