(* EXAM11.PAS *)

program driver;
{$R+}

uses
    exam0,
    Btree,
    Compare,
    FileBuff,
    FileDecs,
    Files,
    LRecList,
    Numbers,
    Page,
    Logical;

var
    dataFile,
    indexFile1,
    indexFile2 : FnString;                      (* holds file name strings *)

    testRec : TestRecord;                (* variable to hold a data record *)

    lrLst : LrList;         (* variable which user declares and passes in to
                               LRLIST unit.  LRLIST will build a list of
                               logical records which fulfill a query criteria.
                               (Actually the list will be built by a call
                               to the BTREE unit which in turn uses the LRLIST
                               unit.                                         *)

    nextLrNum,
    lrNum : LrNumber;         (* Used to keep track of logical record number *)

    tempByte : Byte;        (* this variable is used to pass in the selection
                               criteria for retrievals.  A variable or typed
                               constants must be used.  Constants do not work
                               since the call is by reference and not by
                               value                                         *)

    exitSave : Pointer;     (* used as pointer to my terminiation procedure  *)


(* This routine creates a random string and is used for creating strings to
demonstrate the handling of strings in indexes                               *)

procedure CreateRandomString(var str : TestString);

var
    chrCnt : 1 .. TESTSTRINGSIZE;
    tss : Byte;

    begin
    str := '';
    for chrCnt := 1 to TESTSTRINGSIZE do
        begin
        str[chrCnt] := Chr(Random(25) + 65);
        end;
    tss := TESTSTRINGSIZE;
    Move(tss,str,1);
    end;


(* This procedure will be called prior to termination of the program whether
   there is an error or not.  This is a demonstration of a good technique to
   use in conjunction with TBTREE.  Calls to write the buffer to disk and
   close the files should be included.  This is also a place top handle runtime
   error since I do not attempt to deal with errors or maintain global error
   variables in TBTREE.                                                      *)

{$F+} procedure MyExit; {$F-}

    begin
    ExitProc := ExitSave;           (* reinstall the saved value of ExitProc *)
    Writeln('Writing Records To Disk ...');        (* just a note so you can
                                                      follow along           *)

    WriteEntireBufferToDisk;         (* very important step!!  Before leaving
                                        the program the buffer must be written
                                        to disk or some changes will be lost.
                                        This will cause major problems and lost
                                        data!!!  This is not really required in
                                        in this program since nothing is
                                        modified.  A logical record list is
                                        created, but it happens to be small
                                        enough that a temporary file is not
                                        needed.  If a file was needed, it would
                                        have been destroyed on the call to
                                        DestroyLrList anyway.                *)

    Writeln('Closing Files ...');                  (* just a note so you can
                                                      follow along           *)

    CloseAllFiles;               (* Close the files to clean up.  It is
                                    important to realize that CloseAllFiles
                                    DOES NOT write the buffer to disk, it only
                                    deals with the files open list.          *)

    end;


(* This routine should be called before anything else happens.  It calls
   the various routines to set up parameters according to values applicable
   to your particular application.                                           *)

procedure SetUp;

    begin
    SetMaxBufferPages(100);  (* a call to the PAGE unit to set up the number
                                of pages in the buffer.  If this is not done a
                                default of one page is used.  This will cause
                                poor performance but will not cause any
                                runtime errors                               *)

    SetMaxOpenFiles(10);     (* a call to the FILEBUFF unit to set the number
                                of files the FILEBUFF unit can have open at
                                once.  See FILEBUFF unit for details.        *)

    SetImmediateDiskWrite(FALSE); (* changed and newly created pages will be
                                     buffered in the page buffer and will only
                                     written to disk when they are swapped out
                                     or explicitly written out by a user
                                     request                                 *)

    end;


(* This procedure initializes the file names as required.  Also, if will
   create the files if they do not exist.  Therefore, you can use one
   initialization routine whether the file exists or must be created.        *)

procedure InitFiles;

    begin

    dataFile := 'myFile1.dat';
    if not FileExists(dataFile) then
        begin
        CreateDataFile(dataFile,SizeOf(TestRecord));
        end;

    indexFile1 := 'testByte.idx';
    if not FileExists(indexFile1) then
        begin
        CreateIndexFile(indexfile1,SizeOf(BYTE),BYTEVALUE);
        end;

    indexFile2 := 'testStrg.idx';
    if not FileExists(indexFile2) then
        begin
        CreateIndexFile(indexfile2,SizeOf(TestString),STRINGVALUE);
        end;
    end;


(*****************************************************************************)
(*                                                                           *)
(*                         M A I N      P R O G R A M                        *)
(*                                                                           *)
(*****************************************************************************)

begin

Writeln('Setting up termination routine ...');     (* just a note so you can
                                                      follow along           *)

exitSave := ExitProc;       (* see page 376 - 377 of Turbo Pascal 4.0 manual *)
ExitProc := @MyExit;

Writeln('Initializing Parameters ...');            (* just a note so you can
                                                      follow along           *)

SetUp;              (* set file open buffer size and page buffer size limits *)
                    (* set immediate disk write parameter as well            *)


InitFiles;


    (* The following shows the retrieval of all the records in the index using
       the internal cursor and associated routines.  No logical record list
       is created.                                                           *)

lrNum := UsingCursorGetFirstLr(indexFile1);

while lrNum <> 0 do
    begin
    GetALogicalRecord(dataFile,        (* variable holding name of data file *)
                      lrNum,              (* logical record number from list *)
                      testRec);                     (* place to put the data *)

    Writeln(lrNum,'        ',testRec.randByte,'       ',testrec.randString);
    lrNum := UsingCursorSkipAndGetNextLr(indexFile1);
    end;

Writeln;
writeln('now we are adding a new record ');
Writeln;

testRec.randByte := 45;
CreateRandomString(testRec.randString);       (* random string of 10 letters *)
lrNum := StoreNewLogicalRecord(dataFile,testRec);   (* insert into data file *)

InsertValueInBTree(indexFile1,lrNum,testRec.randByte);
InsertValueInBTree(indexFile2,lrNum,testRec.randString);

(* The following shows that the cursor works properly when a value is
   inserted into the index                                                   *)

lrNum := UsingCursorGetCurrLr(indexFile1);

if lrNum <> 0 then
    begin
    GetALogicalRecord(dataFile,        (* variable holding name of data file *)
                      lrNum,              (* logical record number from list *)
                      testRec);                     (* place to put the data *)

    Writeln(lrNum,'        ',testRec.randByte,'       ',testRec.randString);
    end;

(* The following shows that the cursor works properly when a value is
   deleted from the index.  It also shows how to do deletes using the cursor *)

Writeln;
Writeln('now we are deleting all records with randByte >= 45');
Writeln;

tempByte := 45;
lrNum := UsingCursorAndValueGetLr(indexFile1,tempByte);

while lrNum <> 0 do
    begin
    GetALogicalRecord(dataFile,        (* variable holding name of data file *)
                      lrNum,              (* logical record number from list *)
                      testRec);                     (* place to put the data *)
    Writeln(lrNum,'        ',testRec.randByte,'       ',testRec.randString);
    nextLrNum := UsingCursorGetNextLr(indexFile1);  (* This step is necessary
                                                       because if you delete
                                                       the entry where the
                                                       cursor is, the cursor
                                                       will become invalid.
                                                       You need to move the
                                                       cursor to the next
                                                       record number in the
                                                       index prior to doing
                                                       the delete.           *)
    DeleteDataRecord(dataFile,lrNum);
    DeleteValueFromBTree(indexFile1,lrNum,testRec.randByte);
    DeleteValueFromBTree(indexFile2,lrNum,testRec.randString);
    Writeln(lrNum,'        ',testRec.randByte,'       ',testRec.randString);
    lrNum := nextLrNum;
    end;

end.

