(* EXAM4.PAS *)

program driver;
{$R+}

uses
    Exam0,
    FileBuff,
    FileDecs;

var
    dataFile  : FnString;                       (* holds file name strings *)
    cnt : 1 .. TOTALRECORDS;
    str : TestString;
    thisFile : Text;


(* This procedure creates the text file but does not write any data to it.   *)

procedure InitFiles;

    begin
    dataFile := 'myFile1.txt';
    RewriteTextFile(dataFile,thisFile);
    end;


(* This routine creates a random string and is used for creating strings to
demonstrate the handling of strings in text file                            *)

procedure CreateRandomString(var str : TestString);

var
    chrCnt : 1 .. TESTSTRINGSIZE;
    tss : Byte;

    begin
    str := '';
    for chrCnt := 1 to TESTSTRINGSIZE do
        begin
        str[chrCnt] := Chr(Random(25) + 65);
        end;
    tss := TESTSTRINGSIZE;
    Move(tss,str,1);
    end;


(*****************************************************************************)
(*                                                                           *)
(*                         M A I N      P R O G R A M                        *)
(*                                                                           *)
(*****************************************************************************)

begin

Writeln('Creating Text File ...');                  (* just a note so you can
                                                      follow along           *)

InitFiles;


Writeln('Creating and storing data ... this may take a minute ...');
                                                   (* just a note so you can
                                                      follow along           *)

    (* the following loop will create 15 records which will be inserted into
       the text file.                                                        *)


for cnt := 1 to TOTALRECORDS do
    begin
    CreateRandomString(str);
    Writeln(str);
    OpenTextFile(dataFile,thisFile);
    Writeln(thisFile,str);
    end;

Writeln;
Writeln;

CloseFile(dataFile);                               (* go ahead and close it *)

for cnt := 1 to TOTALRECORDS do
    begin
    CreateRandomString(str);
    Writeln(str);
    AppendTextFile(dataFile,thisFile);
    Writeln(thisFile,str);
    end;

Writeln;
Writeln;

str := '';

CloseFile(dataFile);

OpenTextFile(dataFile,thisFile);                          (* open for input *)
while not Eof(thisFile) do
    begin
    OpenTextFile(dataFile,thisFile);
    Readln(thisFile,str);
    Writeln(str);
    end;

Writeln('Closing Files ...');                      (* just a note so you can
                                                      follow along           *)

CloseAllFiles;                               (* Close the files to clean up. *)


end.
