(* EXAM51.PAS *)

program driver;
{$R+}

uses
    Exam0,
    Btree,
    Compare,
    FileBuff,
    FileDecs,
    Files,
    VLogical,
    LRecList,
    Numbers,
    Page;

var
    dataFile,
    indexFile1 : FnString;                      (* holds file name strings *)

    testRec : TestRecord;                (* variable to hold a data record *)

    recCnt : 1 .. TOTALRECORDS;

    lrNum : LrNumber;

    exitSave : Pointer;     (* used as pointer to my terminiation procedure  *)


(* This procedure will be called prior to termination of the program whether
   there is an error or not.  This is a demonstration of a good technique to
   use in conjunction with TBTREE.  Calls to write the buffer to disk and
   close the files should be included.  This is also a place top handle runtime
   error since I do not attempt to deal with errors or maintain global error
   variables in TBTREE.                                                      *)

{$F+} procedure MyExit; {$F-}

    begin
    ExitProc := ExitSave;           (* reinstall the saved value of ExitProc *)
    Writeln('Writing Records To Disk ...');        (* just a note so you can
                                                      follow along           *)

    WriteEntireBufferToDisk;         (* very important step!!  Before leaving
                                        the program the buffer must be written
                                        to disk or some changes will be lost.
                                        This will cause major problems and lost
                                        data!!!  This is not really required in
                                        in this program since nothing is
                                        modified.  A logical record list is
                                        created, but it happens to be small
                                        enough that a temporary file is not
                                        needed.  If a file was needed, it would
                                        have been destroyed on the call to
                                        DestroyLrList anyway.                *)

    Writeln('Closing Files ...');                  (* just a note so you can
                                                      follow along           *)

    CloseAllFiles;               (* Close the files to clean up.  It is
                                    important to realize that CloseAllFiles
                                    DOES NOT write the buffer to disk, it only
                                    deals with the files open list.          *)

    end;


(* This routine should be called before anything else happens.  It calls
   the various routines to set up parameters according to values applicable
   to your particular application.                                           *)

procedure SetUp;

    begin
    SetMaxBufferPages(100);  (* a call to the PAGE unit to set up the number
                                of pages in the buffer.  If this is not done a
                                default of one page is used.  This will cause
                                poor performance but will not cause any
                                runtime errors                               *)

    SetMaxOpenFiles(10);     (* a call to the FILEBUFF unit to set the number
                                of files the FILEBUFF unit can have open at
                                once.  See FILEBUFF unit for details.        *)

    SetImmediateDiskWrite(FALSE); (* changed and newly created pages will be
                                     buffered in the page buffer and will only
                                     written to disk when they are swapped out
                                     or explicitly written out by a user
                                     request                                 *)

    end;


(* This procedure creates the one data file and the two corresponding
   index files.  It will overwrite the files if they happen to already
   exist.                                                                    *)

procedure InitFiles;

    begin

    dataFile := 'myFile1.dat';
    VLRCreateDataFile(dataFile);

    indexFile1 := 'testByte.idx';
    CreateIndexFile(indexFile1,SizeOf(Byte),BYTEVALUE);

    end;


(* This routine creates a random string of randon length and is used for
   creating strings to demonstrate the handling of variable length records   *)

procedure CreateRandomString(var str : TestString);

var
    chrCnt : 1 .. TESTSTRINGSIZE;
    tss : Byte;

    begin
    str := '';
    tss := 0;
    for chrCnt := 1 to Random(TESTSTRINGSIZE) + 1 do
        begin
        str[chrCnt] := Chr(Random(25) + 65);
        Inc(tss);
        end;
    Move(tss,str,1);
    end;


(*****************************************************************************)
(*                                                                           *)
(*                         M A I N      P R O G R A M                        *)
(*                                                                           *)
(*****************************************************************************)

begin

Writeln('Setting up termination routine ...');     (* just a note so you can
                                                      follow along           *)

exitSave := ExitProc;       (* see page 376 - 377 of Turbo Pascal 4.0 manual *)
ExitProc := @MyExit;

Writeln('Initializing Parameters ...');            (* just a note so you can
                                                      follow along           *)

SetUp;              (* set file open buffer size and page buffer size limits *)
                    (* set immediate disk write parameter as well            *)

Writeln('Creating Files ...');                     (* just a note so you can
                                                      follow along           *)


InitFiles;                                   (* create the files and indexes *)

Randomize;                       (* needed only for the random string creation
                                    routine and has nothing to do with
                                    TBTree                                   *)

Writeln;

Writeln('Creating and storing data ... this may take a minute ...');
                                                   (* just a note so you can
                                                      follow along           *)

    (* the following loop will create records which will be inserted into
       the data file.  The appropriate values are also inserted into the
       two index files.                                                      *)

for recCnt := 1 to TOTALRECORDS do
    begin
    testRec.randByte := Random(MAXBYTE + 1);    (* random byte from 0 .. 255 *)
    CreateRandomString(testRec.randString);

    lrNum := VLRStoreNewLogicalRecord(dataFile,testRec,
                                      SizeOf(testRec.randByte) +
                                      Length(testRec.randString) + 1);
                               (* insert in variable length record data file
                               (* notice how each record will be different
                                  size                                       *)
    InsertValueInBTree(indexFile1,lrNum,testRec.randByte);

    end;

end.
