(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit FastMove;

(*****************************************************************************)
(*                                                                           *)
(*                    F A S T   M O V E   R O U T I N E                      *)
(*                                                                           *)
(*****************************************************************************)

(* This unit contains one assembly language routine which replaces the Turbo
   Pascal Move routine.  Like the Turbo Pascal routine, FastMover will handle
   cases where the source and destination overlap.  The advantage of using
   this over the Turbo Pascal Move routine is that it is faster since it moves
   the data a word at a time versus a byte at a time.

   This is actually an inline version of a variation on MOVES.ASM written by
   James H LeMay.  I decided to use inline versus an object file since this
   makes it easier for you to deal with.  There is no object file to try to
   keep track of.  Also, MOVES.ASM contains a second routine which I did not
   need.  I wanted to keep this as small as possible.                        *)

(* Version Information

   Version 1.5 - Unit Created

   Version 1.6 - No Changes                                                  *)


(*\*)
(*////////////////////////// I N T E R F A C E //////////////////////////////*)

interface

(* This routine will move a block of data from a source to a destination.  It
   replaces Turbo Pascal's Move routine.                                     *)

procedure FastMover(var source;
                    var dest;
                    numToMove : word);









(*!*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation

(* This routine will move a block of data from a source to a destination.  It
   replaces Turbo Pascal's Move routine.                                     *)

procedure FastMover(var source;
                    var dest;
                    numToMove : word);

    begin
    Inline($8C/$DA/$C5/$B6/>SOURCE/$C4/$BE/>DEST/$8B/$8E/>NUMTOMOVE);
    Inline($39/$FE/$72/$08/$FC/$D1/$E9/$73/$11/$A4/$EB/$0E/$FD/$01/$CE);
    Inline($4E/$01/$CF/$4F/$D1/$E9/$73/$01/$A4/$4E/$4F/$F2/$A5/$8E/$DA);
    end;                                         (* end of FastMover routine *)

end.                                                     (* end of Time unit *)
