(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit FileDecs;

(*****************************************************************************)
(*                                                                           *)
(*                     F I L E   D E C L A R A T I O N S                     *)
(*                                                                           *)
(*****************************************************************************)


(* This unit is required because these declarations are needed by both
   the Files unit and the Page unit.  They logically belong in the File unit
   but putting them there means that the File unit can not depend on the
   Page unit which it does.  In other words, separately declaring this
   info alleviates the recursive unit dependency problem which would occur.  *)

(* Version Information

   Version 1.1 - No Changes

   Version 1.2 - No Changes

   Version 1.3 - No Changes

   Version 1.4 - Added CURRENTVERSION string constant

               - Added PathString type

               - Added VersionString type

               - Deleted BITMAP and LLIST from FileTypes type
                 LLIST files are still created, but a file type designator is
                 not needed.

               - Changed definition for RecordNumber type to reflect actual
                 legal values for record numbers.  -1 is no longer a legal
                 value.  It was intended as use as an error flag, but is
                 not being used as such in TBTREE.

               - Added UserDataArray type

   Version 1.5 - No Changes

   Version 1.6 - Added VLRDATA to the FileTypes enumerated type              *)

(*\*)
(*////////////////////////// I N T E R F A C E //////////////////////////////*)

interface

const
    FNSIZE = 80;                (* Max number of characters in a file name.
                                   80 characters is used since a file name
                                   may consist of a drive specifier and/or
                                   directory info along with the actual
                                   name

                                   for example -
                                              A:\mydir\thisdir\xxxxxxxx.yyy  *)


    RNSIZE = 4;                 (* bytes required to store a record number *)

    CURRENTVERSION = 'VER1.6';

type
    FileTypes = (INDEX,DATA,VLRDATA);  (* file types of interest to the user *)

    FnString = String[FnSize];      (* See FNSIZE definition above for an
                                       example of a file name                *)

    PathString = FnString;          (* This type is added to enhance future
                                       products.  It is used to hold the
                                       path.  The path can include the
                                       drive designator and the directory
                                       path.  It can used to hold path info
                                       in any application.  Since this has
                                       the FnString as the base type,
                                       entire file names can be created by
                                       concatenating the path with the file
                                       name.  This may or may not be useful
                                       in user applications.  It really
                                       just makes code easier to read if
                                       this type is used for path info and
                                       FnString is used for file names
                                       (with or without path)                *)

    VersionString = String[6];      (* Used to store version information in
                                       the parameter records for the different
                                       file types.                           *)

    RecordNumber = 0 .. MAXLONGINT;               (* range of record numbers *)

    PrNumber = RecordNumber;   (* Physical Record Number within a file       *)
    LrNumber = RecordNumber;   (* Logical Record Number within a file        *)
                               (* For both of the above type definitions     *)

    UserDataArray  = Array [0 .. 255] of Byte;  (* used to store user data
                                                   in parameter records      *)

(*!*)
(*\*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation


end.                                                 (* end of FileDecs unit *)
