(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit Hex;

(*****************************************************************************)
(*                                                                           *)
(*                H E X  C O N V E R S I O N  R O U T I N E S                *)
(*                                                                           *)
(*****************************************************************************)


(* These routines support conversion from/to hex from byte values            *)


(* Version Information

   Version 1.1 - No Changes

   Version 1.2 - No Changes

   Version 1.3 - No Changes

   Version 1.4 - No Changes

   Version 1.5 - No Changes

   Version 1.6 - No Changes                                                  *)

(*////////////////////////// I N T E R F A C E //////////////////////////////*)

interface

type
    HexArray = String[2];


(* Finds the hex character for a given 4 bit value
   for example - GetHexChar(11) = 'B'                                       *)

function GetHexChar(var x : Byte) : Char;


(* This function returns the hex value for an associated 8 bit byte.  The value
   is returned as a string of type HexArray (2 bytes)
   for example - ByteToHex(255) = 'FF'                                      *)

function ByteToHex(x : Byte) : HexArray;

(*!*)
(*\*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation


(* Finds the hex character for a given 4 bit value
   for example - GetHexChar(11) = 'B'                                       *)

function GetHexChar(var x : Byte) : Char;

var
    result1 : Byte;
    result2 : Char absolute result1;

    begin
    if (x >= 0) and (x <=9) then
        begin
        result1 := x + 48;
        end
    else
        begin
        result1 := x + 55;
        end;
    GetHexChar := result2;
    end;                                        (* End of GetHexChar Routine *)


(* This function returns the hex value for an associated 8 bit byte.  The value
   is returned as a string of type HexArray (2 bytes)
   for example - ByteToHex(255) = 'FF'                                      *)

Function ByteToHex(x : Byte) : HexArray;

var
    low,
    high : Byte;

    begin
    high := x div 16;
    low  := x mod 16;
    ByteToHex := GetHexChar(high) + GetHexChar(low);
    end;                                         (* End of ByteToHex Routine *)


end.                                                      (* end of Hex unit *)

