(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit Math;

(*****************************************************************************)
(*                                                                           *)
(*                  M A T H M A T I C A L  R O U T I N E S                   *)
(*                                                                           *)
(*****************************************************************************)


(* These routines augment the Turbo Pascal routines provided.


(* Version Information

   Version 1.1 - No Changes

   Version 1.2 - No Changes

   Version 1.3 - Modified 11 July 1988  by Jack Dolby
                                           Gately Communication Company
                                           501 Industry Drive
                                           Hampton, VA  23661

       These are inline assembly language macros to perform the same function
       as the Pascal versions in versions prior to 1.3.

       Note that the entire code for inline macros must be in the INTERFACE
       section.  The code in these macros is actually placed in the code the
       compiler emits at each place they are invoked. This results in larger
       code but eliminates the time overhead for calling a routine and
       returning from it.  Only the pushing of parameters and extracting the
       functional result are done rather than also pushing the return address,
       preserving registers in the code, setting up a stack frame, and
       restoring all registers and the stack on return.  This results in
       faster code at the expense of code size (if called from more than one
       place) and in loosing the ability to hide the code in the
       IMPLEMENTATION SECTION.     j. dolby

       My special thanks goes to j. dolby who took the time to make these
       improvements and graciously allowed me to include them for
       distribution!!      Dean H. Farwell II

   Version 1.4 - Jack Dolby modified (cleaned up) all routines for this
                 version

               - Deleted PowerInt routine since it is not really used for
                 anything

   Version 1.5 - No Changes

   Version 1.6 - No Changes                                                  *)

(*\*)
(*////////////////////////// I N T E R F A C E //////////////////////////////*)

interface

(* the following type supports the byte handling routine(s)                  *)

type
    BytePosition = 0 .. 7;
    BitValue = 0 .. 1;


(* This function will determine if a certain bit within a target byte is
   toggled on (equal to 1).  The bit position is is the position within the
   byte of the bit to be tested.  The least significant bit is 0 then most
   significant bit is 7.  If the bit is 1 TRUE will be returned.  If the bit
   is 0 FALSE will be returned.  Notice that the target byte can be of any
   type.  in this way, the routine will handle any a bit byte.  In other
   words a character could also be passed in.                                *)

(* Boolean functions return zero flag set and AL=0 for false,
                            zero flag reset and AL=1 for true                *)

function BitOn(var targetByte;
               bitNum : BytePosition ):boolean;

(*      pop cx                   ;bitNum
        pop bx                   ;offset of targetByte
        pop es                   ;segment of targetByte
        mov al, byte ptr es:[bx] ;get the byte
        shr al,cl                ;get desired bit
                                 ;in rightmost position
        and al,01                ;check for bit set                          *)

    INLINE($59/$5B/$07/$26/$8A/$07/$D2/$E8/$24/$01);


(*\*)
(* This will set a given bit to a value of zero or one depending on what is
   passed in as the last parameter.  See above for description of the other
   parameters                                                                *)

procedure SetBit(var targetByte;
                 bitNum : BytePosition;
                 bit : BitValue );

(*      pop ax                  ;bit
        pop cx                  ;bitNum
        pop bx                  ;offset of targetByte
        pop es                  ;segment of targetByte
        mov ah,11111110b        ;mask to reset
        rol ah,cl               ;get it in place
        and byte ptr es:[bx],ah ;reset regardless
        shl al,cl               ;mask to set/reset
        or byte ptr es:[bx],al  ;make bit proper value                       *)

    INLINE($58/$59/$5B/$07/$B4/$FE/$D2/$C4/$26/$20/$27/$D2/$E0/$26/$08/$07);














(*!*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation

end.                                                     (* end of Math unit *)
