(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit MyPrint;

(*****************************************************************************)
(*                                                                           *)
(*                    P R I N T E R   R O U T I N E S                        *)
(*                                                                           *)
(*****************************************************************************)


(* These routines perform some very basic printer commands which can be
   called from Turbo Pascal.  The routines work by printing appropriate
   control codes to the lst device (which is the printer).  The control codes
   included are for a Gemini 10 but should work for Epson printers.  The codes
   can be changed as required for various printers.  These were really
   developed for my own use and were not intended to be generic enough to
   handle a variety of printers.  I have included them since I use a couple of
   the routines in my TP4Print program and I use one or two routines in
   Page.Pas for printing out the buffer (used for debugging).                *)


(* Version Information

   Version 1.1 - No Changes

   Version 1.2 - No Changes

   Version 1.3 - No Changes

   Version 1.4 - No Changes

   Version 1.5 - Changed code internally to use Inc and Dec where practical

               - Added SoftwareReset routine

   Version 1.6 - No Changes                                                  *)

(*\*)
(*//////////////////////////  I N T E R F A C E /////////////////////////////*)

interface

uses
    Printer;

const
    BEL    = #7;               (* Bell - 1/4 second *)
    BS     = #8;               (* Backspace *)
    LF     = #10;              (* Linefeed *)
    FF     = #12;              (* Formfeed *)
    CR     = #13;              (* Carriage return *)
    SO     = #14;              (* Double width mode *)
    SI     = #15;              (* Compressed Mode *)
    DC2    = #18;              (* cancel compressed mode *)
    DC4    = #20;              (* cancel double width *)
    ESC_AT = #64;              (* Software reset *)
    DEL    = #127;             (* Delete last character *)
    ESC_1  = #27#45#1;         (* Underline mode *)
    ESC_0  = #27#45#0;         (* Cancel underline mode *)
    ESCE   = #27#69;           (* Emphasized mode *)
    ESCF   = #27#70;           (* Cancel emphasized mode *)
    ESCG   = #27#71;           (* Double strike mode *)
    ESCH   = #27#72;           (* Cancel Double Strike Mode *)
    ESCV1  = #27#86#1;         (* Slashed 0 option *)
    ESCV0  = #27#86#0;         (* Cancel slashed 0 option *)


procedure FormFeed;


procedure SetSlashedZero;


procedure SoftwareReset;


procedure SetCompressedMode;


procedure CancelCompressedMode;


procedure SetEmphasizedMode;


procedure CancelEmphasizedMode;

(*!*)
(*\*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation


procedure FormFeed;

    begin
    Write(lst,FF);
    end;


procedure SoftwareReset;

    begin
    Write(lst,ESC_AT);
    end;


procedure SetSlashedZero;

    begin
    Write(lst,ESCV1);
    end;

procedure SetCompressedMode;

    begin
    Write(lst,SI);
    end;

procedure CancelCompressedMode;

    begin
    Write(lst,DC2);
    end;

procedure SetEmphasizedMode;

    begin
    Write(lst,ESCE);
    end;

procedure CancelEmphasizedMode;

    begin
    Write(lst,ESCF);
    end;


end.                                                  (* end of MyPrint unit *)
