(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit Numbers;

(*****************************************************************************)
(*                                                                           *)
(*                  N U M B E R   D E C L A R A T I O N S                    *)
(*                                                                           *)
(*****************************************************************************)

(* This unit has declarations for often used standard constants and types.
   These are obviously not all inclusive and can be added to as desired.     *)


(* Version Information

   Version 1.1 - Added StringCondition type

   Version 1.2 - No Changes

   Version 1.3 - No Changes

   Version 1.4 - Moved the ValueType type definition from the compare unit
                 to this unit to avoid a circular unit definition problem
                 caused by adding the ByteData unit.

   Version 1.5 - No changes

   Version 1.6 - No changes                                                  *)


(*////////////////////////// I N T E R F A C E //////////////////////////////*)

interface

const
    MAXBYTE     = 255;
    MAXSHORTINT = 127;
    MAXWORD     = 65535;

    (* the following constants are used to reflect the number of bytes
        required to hold the corresponding variable types.                   *)

    BYTESIZE      = 1;
    SHORTINTSIZE  = 1;
    INTEGERSIZE   = 2;
    LONGINTSIZE   = 4;
    WORDSIZE      = 2;
    REALSIZE      = 6;
    SINGLESIZE    = 4;
    DOUBLESIZE    = 8;
    EXTENDEDSIZE  = 10;
    COMPSIZE      = 8;

(*\*)
type
    PosByte       = 1 .. MAXBYTE;
    PosShortInt   = 1 .. MAXSHORTINT;
    PosInteger    = 1 .. MAXINT;
    PosLongInt    = 1 .. MAXLONGINT;
    PosWord       = 1 .. MAXWORD;

    Condition     = (EX,      (* Exists *)
                     LT,      (* Less Than *)
                     LE,      (* Less Than Or Equal To *)
                     EQ,      (* Equal To *)
                     NE,      (* Not Equal To *)
                     GE,      (* Greater Than Or Equal To *)
                     GT);     (* Greater Than *)

    StringCondition = (ST,    (* String Starts With Substring *)
                       CO,    (* String Contains Substring *)
                       EN);   (* String Ends With Substring *)

    ValueType = (INVALIDVALUE,
                 BYTEVALUE,
                 SHORTINTVALUE,
                 INTEGERVALUE,
                 LONGINTVALUE,
                 WORDVALUE,
                 STRINGVALUE,
                 REALVALUE,
                 SINGLEVALUE,
                 DOUBLEVALUE,
                 EXTENDEDVALUE,
                 COMPVALUE,
                 BYTEARRAYVALUE);








(*!*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation

end.                                                  (* end of Numbers unit *)
