(* TBTree16             Copyright (c)  1988,1989       Dean H. Farwell II    *)

unit Strings;

(*****************************************************************************)
(*                                                                           *)
(*            A D D I T I O N A L  S T R I N G  R O U T I N E S              *)
(*                                                                           *)
(*****************************************************************************)


(* Although Turbo has some string handling routines, there are many others
   which would prove useful.  Here are but a few.                            *)

(* Version Information

   Version 1.1 - No Changes

   Version 1.2 - No Changes

   Version 1.3 - No Changes

   Version 1.4 - Added MAXSTRINGLENGTH constant

               - Added StringLengthRange type

   Version 1.5 - The TotalString routine was rewritten in assembler (Inline)
                 to significantly increase performance

               - Added Asciiz2Str routine

   Version 1.6 - No Changes                                                  *)

(*\*)
(*////////////////////////// I N T E R F A C E //////////////////////////////*)

interface

uses
    Numbers;

const
    MAXSTRINGLENGTH = 255;                     (* max characters in a string *)

type
    StringLengthRange = 0 .. MAXSTRINGLENGTH;  (* range of number of
                                                  characters in a string     *)


(* Takes a string and adds up the integer value of each individual byte.
   This total can be used to randomize the string for Hashing, etc.          *)

function TotalString(var str : String) : Word;


(*  This routine returns the last n characters of a  string                  *)

procedure EndOfString(var str : String;
                     n : Byte;
                     var resultStr : String);


(* This routine converts a string from ASCIIZ (null delimined) to Turbo Pascal
   format                                                                    *)

function Asciiz2Str(var aStr) : string;

(*!*)
(*\*)
(*///////////////////// I M P L E M E N T A T I O N /////////////////////////*)

implementation


(* Takes a string and adds up the integer value of each individual byte.
   This total can be used to randomize the string for Hashing, etc.          *)

function TotalString(var str : String ) : Word;

    begin
    Inline($31/$C0/      (*  xor   ax,ax              ; zero out accumulator *)
           $31/$C9/      (*  xor   cx,cx              ; zero out counter     *)
           $C4/$BE/>STR/ (*  les   di, >str[bp]       ; load pointer to str  *)
           $26/$8A/$0D/  (* es: mov   cl,[di]         ;                      *)
                         (* CountLoop:                                       *)
           $47/          (*  inc   di                 ; next char            *)
           $26/$02/$05/  (* es: add   al,[di]         ; add value of char    *)
           $80/$D4/$00/  (*  adc   ah,0               ; add carry
                                                        if required          *)
           $E2/$F7/      (*  loop  CountLoop          ; get next char        *)
           $89/$46/$FE); (*  mov   [bp-02],ax         ; put total on stack   *)

    end;                                      (* end of TotalString routine  *)


(*  This routine returns the last n characters of a  string                    *)

procedure EndOfString(var str : String;
                      n : Byte;
                      var resultStr : String);


    begin
    resultStr := Copy(str,(Length(str) - n + 1),n);
    end;                                       (* end of EndOfString routine *)

(*\*)
(* This routine converts a string from ASCIIZ (null delimined) to Turbo Pascal
   format                                                                    *)

function Asciiz2Str(var aStr) : string;

var str : String;
    ctr : Word;
    az: Array[1 .. MAXSTRINGLENGTH] of Char absolute aStr;

    begin
    ctr := 1;
{$B-}                           (* short circuit boolean evaluation required *)
    while (ctr <= MAXSTRINGLENGTH) and (az[ctr] <> #0) do
        begin
        str[ctr] := az[ctr];
        Inc(ctr);
        end;
    str[0] := Chr(ctr-1);
    Asciiz2Str := str;
    end;                                         (* end of Ascii2Str routine *)

end.                                                  (* end of Strings unit *)
