// Example1View.cpp : implementation of the CExample1View class
//

#include "stdafx.h"
#include "Example1.h"

#include "Example1Doc.h"
#include "Example1View.h"
#include "tszd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExample1View

IMPLEMENT_DYNCREATE(CExample1View, CFormView)

BEGIN_MESSAGE_MAP(CExample1View, CFormView)
	//{{AFX_MSG_MAP(CExample1View)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_Ctrl, OnDblclkLISTCtrl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExample1View construction/destruction

CExample1View::CExample1View()
	: CFormView(CExample1View::IDD)
{
	//{{AFX_DATA_INIT(CExample1View)
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CExample1View::~CExample1View()
{
}

void CExample1View::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExample1View)
	DDX_Control(pDX, IDC_LIST_Ctrl, m_ListCtrl);
	//}}AFX_DATA_MAP
}

BOOL CExample1View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CExample1View::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();
	m_ListCtrl.InsertColumn(0, "File-Name", LVCFMT_LEFT, 120);
	m_ListCtrl.InsertColumn(1, "Size", LVCFMT_LEFT, 90);
	m_ListCtrl.InsertColumn(2, "Unpacked", LVCFMT_LEFT, 90);
	m_ListCtrl.InsertColumn(3, "Path", LVCFMT_LEFT, 300);
	OnFileOpen();
}

/////////////////////////////////////////////////////////////////////////////
// CExample1View diagnostics

#ifdef _DEBUG
void CExample1View::AssertValid() const
{
	CFormView::AssertValid();
}

void CExample1View::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CExample1Doc* CExample1View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CExample1Doc)));
	return (CExample1Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CExample1View message handlers

void CExample1View::UpdateList()
{
	if (m_ZIP_File.IsEmpty())
	{
		MessageBox("Zip file name field can not be empty.", "Zip File Name Empty!", MB_ICONSTOP);
		return;
	}
	char zfn[200];
	strcpy(zfn, m_ZIP_File);
	if (zOpenZipFile((char *)&zfn))
	{
		CString ReturnError = zGetLastErrorAsText();
		MessageBox("Recieved the following error message:\r\n" + ReturnError,"Unzip Error", MB_ICONERROR);
		return;
	}
	m_ListCtrl.DeleteAllItems();
	for (int i=zGetTotalFiles()-1; i>-1; i--)
	{
		m_ListCtrl.InsertItem(0,zGetFileName(i));
		m_ListCtrl.SetItemText(0,1,itoa(zGetFileSize(i), zfn, 10));
		m_ListCtrl.SetItemText(0,2,itoa(zGetCompressedFileSize(i), zfn, 10));
		m_ListCtrl.SetItemText(0,3,zGetFilePath(i));
	}
	zCloseZipFile();
}

void CExample1View::OnFileOpen() 
{
	static char BASED_CODE szFilter[] = 
		"Zip Files (*.zip)|*.zip|All Files (*.*)|*.*||";
	CFileDialog MyCFileDialog(TRUE, "zip", m_ZIP_File, OFN_FILEMUSTEXIST, szFilter, NULL);
	MyCFileDialog.DoModal();
	if (MyCFileDialog.GetPathName().GetLength())
	{
		m_ZIP_File = MyCFileDialog.GetPathName();
	}
	GetDocument()->SetTitle("TSZD Example1  (" + m_ZIP_File + (CString) ")");
	UpdateList();
	UpdateData(FALSE);
}

void CExample1View::OnDblclkLISTCtrl(NMHDR* pNMHDR, LRESULT* pResult) 
{
	char zfn[200];
	strcpy(zfn, m_ZIP_File);
	if (zOpenZipFile((char *)&zfn))
	{
		CString ReturnError = zGetLastErrorAsText();
		MessageBox("Received the following error message:\r\n" + ReturnError,"Unzip Error", MB_ICONERROR);
		return;
	}
	char DownloadPath[256];
	char MyDialogTitle[] = "Select Destination Directory";
	BROWSEINFO MyBROWSEINFO;
	memset(&MyBROWSEINFO, 0, sizeof(MyBROWSEINFO));
	MyBROWSEINFO.pszDisplayName = DownloadPath;
	MyBROWSEINFO.lpszTitle = MyDialogTitle;
	MyBROWSEINFO.ulFlags = BIF_RETURNONLYFSDIRS;
	LPITEMIDLIST MyITEMIDLIST;
	MyITEMIDLIST = SHBrowseForFolder(&MyBROWSEINFO);
	SHGetPathFromIDList(MyITEMIDLIST, DownloadPath); 
	if (strlen(DownloadPath))
	{
		if (strlen(DownloadPath) > 3) strcat(DownloadPath, "\\");
		zExtractOne(m_ListCtrl.GetSelectionMark(), DownloadPath , "", TRUE, FALSE, FALSE, NULL);
	}
	*pResult = 0;
}
