//*************************************************************
//  File name: global.h
//
//  Description: 
//      Global include file for #defines and prototypes
//
//  History:    Date       Author     Comment
//
//  Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//*************************************************************

#include <windows.h>
#include <commdlg.h>

#define _GLOBALINC


/* Menu Defines */
    #define IDM_ABOUT      100
    #define IDM_PRINT      101
    #define IDM_PRINTSETUP 102
    #define IDM_FONTS      103
    #define IDM_EXIT       666

    #define IDM_OTM        200
    #define IDM_TM         201
    #define IDM_PANOSE     202
    #define IDM_LF         203


/* Function Prototypes */
/* ttdump.c */
    int  PASCAL     WinMain (HANDLE, HANDLE, LPSTR, int);
    long FAR PASCAL MainWndProc (HWND, unsigned, WORD, LONG);
    BOOL FAR PASCAL About (HWND, unsigned, WORD, LONG);
    BOOL            ShowPrintSetup (HWND hWnd);
    void            ShowFontBox (HWND hWnd);
    BOOL            ShowPrintBox (HWND hWnd);
    BOOL            PrintIt(HWND hWnd, LPPRINTDLG lpPD);
    HDC             GetPrinterDC (void);
    int  FAR PASCAL PrintAbortDlg (HWND hWnd, unsigned msg, WORD wParam, LONG lParam);
    BOOL FAR PASCAL PrintAbortProc (HDC hDC, short code);
    void            DumpOTMInfo(HWND hWnd, HDC hDC);
    void            DumpTMInfo(HWND hWnd, HDC hDC);
    void            DumpPanoseInfo(HWND hWnd, HDC hDC);
    void            DumpLFInfo(HWND hWnd, HDC hDC);
    BOOL            IsTTAvail(HDC hDC);
    int CALLBACK    EnumFontFamProc1(LOGFONT FAR *lpnlf, TEXTMETRIC FAR *lpntm, int iFontType, LPARAM lParam);
    int CALLBACK    EnumFontFamProc2(LOGFONT FAR *lpnlf, TEXTMETRIC FAR *lpntm, int iFontType, LPARAM lParam);
    BYTE GetStyleMask(LOGFONT FAR *lf);


// Init.c 
    BOOL InitApplication(HANDLE);
    BOOL InitInstance (HANDLE, int);

// global variables

extern HANDLE  ghInst;          
extern HWND    ghWndMain;      
extern char    szMainMenu[];   
extern char    szMainClass[];   

// check struct menu choice
extern int     iCurrStructChoice;

// global structure for printing attributes
typedef struct 
{
   HANDLE  hCurrDevMode, hCurrDevNames;
   HFONT   hPrinterFont;
   LOGFONT lfCurrFont;
   char    szPrinter [64] ;
   LPSTR   szDevice, szDriver, szOutput ;
   BOOL    bAbort;
   HWND    hDlgAbort;

} PRINTINFOSTRUCT;

PRINTINFOSTRUCT pis;

// global structure for screen attributes
typedef struct 
{
   HFONT    hScreenFont;
   LOGFONT  lfCurrFont;
   COLORREF crTextColor;

} SCREENINFOSTRUCT;

SCREENINFOSTRUCT sis;

typedef struct
{
   char       szFontStyles[LF_FACESIZE];
} FONTINFOSTRUCT;

FONTINFOSTRUCT fi;

CHOOSEFONT cf;


/*** EOF: global.h ***/

