//*************************************************************
//  File name: init.c
//
//  Description:
//
//      Routines which initialize the application and instance.
//
//  History:    Date       Author     Comment
//              12/12/91   Don Miller Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
//*************************************************************

#ifndef _GLOBALINC
#include "global.h"
#endif

//*************************************************************
//
//  InitApplication()
//
//  Purpose:
//
//		Initializes the application (window classes)
//
//
//  Parameters:
//
//      HANDLE hInstance - Instance handle from WinMain.
//      
//
//  Return: (BOOL)
//
//      TRUE  - Window class was initialized and registered.
//      FALSE - Window class not initialized and registered.
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style         = NULL;             
    wc.lpfnWndProc   = MainWndProc;
    wc.cbClsExtra    = 0;           
    wc.cbWndExtra    = 0;           
    wc.hInstance     = hInstance;    
    wc.hIcon         = LoadIcon(hInstance, "MAINICON");
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = COLOR_APPWORKSPACE+1;
    wc.lpszMenuName  = szMainMenu;  
    wc.lpszClassName = szMainClass;

    if ( !RegisterClass(&wc) )
        return(FALSE);

    return(TRUE);

} //*** InitApplication

//*************************************************************
//
//  InitInstance()
//
//  Purpose:
//
//		Initializes each instance (window creation)
//
//
//  Parameters:
//
//      HANDLE hInstance - Instance handle of application.
//      int    nCmdShow  - How window is initially displayed.
//      
//
//  Return: (BOOL)
//
//      TRUE  - Window created and displayed.
//      FALSE - Window not created.
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{

    ghInst = hInstance;

    ghWndMain = CreateWindow( szMainClass, 
                              "TrueType Sample Application",  
                              WS_OVERLAPPEDWINDOW,           
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              NULL,
                              NULL,
                              hInstance,
                              NULL );

    if (!ghWndMain)
        return(FALSE);

    ShowWindow(ghWndMain, nCmdShow);
    UpdateWindow(ghWndMain);

    return(TRUE);

} //*** InitInstance

/*** EOF: init.c ***/

