/* winappc.h */

/*****************************************************************************/
/* APPC constant, vcb and function definitions       */
/*****************************************************************************/

/*****************************************************************************/
/* ------------------------- verb opcodes ---------------------------------- */
/*****************************************************************************/

/*****************************************************************************/
/* control verbs             */
/*****************************************************************************/
#define AP_TP_STARTED     		0x0014    	/* X'1400'   */
#define AP_RECEIVE_ALLOCATE   		0x0016    	/* X'1600'   */
#define AP_TP_ENDED      		0x0013    	/* X'1300'   */

/*****************************************************************************/
/* mapped conversation verbs             */
/*****************************************************************************/
#define AP_M_ALLOCATE     		0x0001    	/* X'0100'   */
#define AP_M_CONFIRM      		0x0003    	/* X'0300'   */
#define AP_M_CONFIRMED       		0x0004   	/* X'0400'   */
#define AP_M_DEALLOCATE      		0x0005   	/* X'0500'   */
#define AP_M_FLUSH       		0x0006   	/* X'0600'   */
#define AP_M_GET_ATTRIBUTES      	0x0007   	/* X'0700'   */
#define AP_M_PREPARE_TO_RECEIVE    	0x000a   	/* X'0a00'   */
#define AP_M_RECEIVE_AND_POST     	0x000d   	/* X'0d00'   */
#define AP_M_RECEIVE_AND_WAIT     	0x000b   	/* X'0b00'   */
#define AP_M_RECEIVE_IMMEDIATE   	0x000c   	/* X'0c00'   */
#define AP_M_REQUEST_TO_SEND     	0x000e   	/* X'0e00'   */
#define AP_M_SEND_CONVERSATION       	0x0018   	/* X'1800'   */
#define AP_M_SEND_DATA       		0x000f   	/* X'0f00'   */
#define AP_M_SEND_ERROR      		0x0010   	/* X'1000'   */
#define AP_M_TEST_RTS    		0x0012   	/* X'1200'   */

/*****************************************************************************/
/* basic conversation verbs          */
/*****************************************************************************/
#define AP_B_ALLOCATE    		0x0001   	/* X'0100'   */
#define AP_B_CONFIRM     		0x0003   	/* X'0300'   */
#define AP_B_CONFIRMED       		0x0004   	/* X'0400'   */
#define AP_B_DEALLOCATE      		0x0005   	/* X'0500'   */
#define AP_B_FLUSH       		0x0006   	/* X'0600'   */
#define AP_B_GET_ATTRIBUTES      	0x0007   	/* X'0700'   */
#define AP_B_PREPARE_TO_RECEIVE  	0x000a   	/* X'0a00'   */
#define AP_B_RECEIVE_AND_POST    	0x000d   	/* X'0d00'   */
#define AP_B_RECEIVE_AND_WAIT    	0x000b   	/* X'0b00'   */
#define AP_B_RECEIVE_IMMEDIATE   	0x000c   	/* X'0c00'   */
#define AP_B_REQUEST_TO_SEND     	0x000e   	/* X'0e00'   */
#define AP_B_SEND_CONVERSATION       	0x0018   	/* X'1800'   */
#define AP_B_SEND_DATA       		0x000f   	/* X'0f00'   */
#define AP_B_SEND_ERROR      		0x0010   	/* X'1000'   */
#define AP_B_TEST_RTS    		0x0012   	/* X'1200'   */
 

/*****************************************************************************/
/* type independent verbs             */
/*****************************************************************************/
#define AP_GET_PROPERTIES		0x0017 		/* X'1700'   */
#define AP_GET_TYPE      		0x0008   	/* X'0800'   */

/* ========================================================================= 
*/
/*****************************************************************************/
/* ------------------- primary and secondary return codes ------------------ */
/*****************************************************************************/
#define AP_OK        			0x0000   	/* X'0000'   */

#define AP_PARAMETER_CHECK   		0x0100   	/* X'0001'   */
#define AP_BAD_TP_ID     		0x01000000 	/*   X'00000001' */
#define AP_BAD_CONV_ID       		0x02000000 	/*   X'00000002' */
#define AP_BAD_LU_ALIAS      		0x03000000 	/*   X'00000003' */
#define AP_INVALID_DATA_SEGMENT  	0x06000000 	/*   X'00000006' */
#define AP_BAD_CONV_TYPE     		0x11000000 	/*   X'00000011' */
#define AP_BAD_SYNC_LEVEL    		0x12000000 	/*   X'00000012' */
#define AP_BAD_SECURITY      		0x13000000 	/*   X'00000013' */
#define AP_BAD_RETURN_CONTROL    	0x14000000 	/*   X'00000014' */
#define AP_PIP_LEN_INCORRECT     	0x16000000 	/*   X'00000016' */
#define AP_NO_USE_OF_SNASVCMG    	0x17000000 	/*   X'00000017' */
#define AP_UNKNOWN_PARTNER_MODE		0x18000000 	/*   X'00000018' */
#define AP_CONFIRM_ON_SYNC_LEVEL_NONE  	0x31000000 	/*   X'00000031' */
#define AP_DEALLOC_BAD_TYPE      	0x51000000 	/*   X'00000051' */
#define AP_DEALLOC_LOG_LL_WRONG  	0x57000000 	/*   X'00000057' */
#define AP_P_TO_R_INVALID_TYPE   	0xa1000000 	/*   X'000000a1' */
#define AP_RCV_AND_WAIT_BAD_FILL   	0xb5000000 	/*   X'000000b5' */
#define AP_RCV_IMMD_BAD_FILL     	0xc4000000 	/*   X'000000c4' */
#define AP_RCV_AND_POST_BAD_FILL   	0xd5000000 	/*   X'000000d5' */
#define AP_INVALID_SEMAPHORE_HANDLE  	0xd6000000 	/*   X'000000d6' */
#define AP_BAD_RETURN_STATUS_WITH_DATA 	0xd7000000 	/*   X'000000d7' */
#define AP_BAD_LL        		0xf1000000 	/*   X'000000f1' */
#define AP_SEND_DATA_INVALID_TYPE    	0xf4000000 	/*   X'000000f4' */
#define AP_SEND_DATA_CONFIRM_SYNC_NONE	0xf5000000	/*   X'000000f5' */
#define AP_SEND_ERROR_LOG_LL_WRONG   	0x02010000 	/*   X'00000102' */
#define AP_SEND_ERROR_BAD_TYPE   	0x03010000 	/*   X'00000103' */
#define AP_BAD_ERROR_DIRECTION   	0x05010000 	/*   X'00000105' */
#define AP_TOO_MANY_TPS      		0x43020000 	/*   X'00000243' */
#define AP_BAD_TYPE      		0x50020000 	/*   X'00000250' */
#define AP_UNDEFINED_TP_NAME     	0x06050000 	/*   X'00000506' */

 
#define AP_STATE_CHECK       		0x0200     	/*   X'0002' */
#define AP_CONFIRM_BAD_STATE     	0x32000000 	/*   X'00000032' */
#define AP_CONFIRM_NOT_LL_BDY    	0x33000000 	/*   X'00000033' */
#define AP_CONFIRMED_BAD_STATE   	0x41000000 	/*   X'00000041' */
#define AP_DEALLOC_FLUSH_BAD_STATE   	0x52000000 	/*   X'00000052' */
#define AP_DEALLOC_CONFIRM_BAD_STATE 	0x53000000 	/*   X'00000053' */
#define AP_DEALLOC_NOT_LL_BDY    	0x55000000 	/*   X'00000055' */
#define AP_FLUSH_NOT_SEND_STATE  	0x61000000 	/*   X'00000061' */
#define AP_P_TO_R_NOT_LL_BDY     	0xa2000000 	/*   X'000000a2' */
#define AP_P_TO_R_NOT_SEND_STATE     	0xa3000000 	/*   X'000000a3' */
#define AP_RCV_AND_WAIT_BAD_STATE    	0xb1000000 	/*   X'000000b1' */
#define AP_RCV_AND_WAIT_NOT_LL_BDY   	0xb2000000 	/*   X'000000b2' */
#define AP_RCV_IMMD_BAD_STATE    	0xc1000000 	/*   X'000000c1' */
#define AP_RCV_AND_POST_BAD_STATE    	0xd1000000 	/*   X'000000d1' */
#define AP_RCV_AND_POST_NOT_LL_BDY   	0xd2000000 	/*   X'000000d2' */
#define AP_R_T_S_BAD_STATE   		0xe1000000 	/*   X'000000e1' */
#define AP_SEND_DATA_NOT_SEND_STATE  	0xf2000000 	/*   X'000000f2' */
#define AP_SEND_DATA_NOT_LL_BDY  	0xf6000000 	/*   X'000000f6' */
#define AP_ATTACH_MANAGER_INACTIVE   	0x08050000 	/*   X'00000508' */
#define AP_ALLOCATE_NOT_PENDING  	0x09050000 	/*   X'00000509' */
#define AP_INVALID_PROCESS	   	0x25050000 	/*   X'00000525' */

#define AP_ALLOCATION_ERROR      	0x0300     	/*   X'0003' */
#define AP_ALLOCATION_FAILURE_NO_RETRY 	0x04000000 	/*   X'00000004' */
#define AP_ALLOCATION_FAILURE_RETRY  	0x05000000 	/*   X'00000005' */
#define AP_SECURITY_NOT_VALID    	0x51600f08 	/*   X'080f6051' */
#define AP_TRANS_PGM_NOT_AVAIL_RETRY 	0x31604b08 	/*   X'084b6031  */
#define AP_TRANS_PGM_NOT_AVAIL_NO_RETRY	0x00004c08	/*  X'084c0000' */
#define AP_TP_NAME_NOT_RECOGNIZED    	0x21600810 	/*   X'10086021' */
#define AP_PIP_NOT_ALLOWED		0x31600810 	/*   X'10086031' */
#define AP_PIP_NOT_SPECIFIED_CORRECTLY  0x32600810 	/*   X'10086032' */
#define AP_CONVERSATION_TYPE_MISMATCH   0x34600810 	/*   X'10086034' */
#define AP_SYNC_LEVEL_NOT_SUPPORTED  	0x41600810 	/*   X'10086041' */

 
#define AP_DEALLOC_ABEND     		0x0500   	/* X'0005'   */
#define AP_DEALLOC_ABEND_PROG    	0x0600   	/* X'0006'   */
#define AP_DEALLOC_ABEND_SVC     	0x0700   	/* X'0007'   */
#define AP_DEALLOC_ABEND_TIMER   	0x0800   	/* X'0008'   */
#define AP_DEALLOC_NORMAL    		0x0900   	/* X'0009'   */
#define AP_PROG_ERROR_NO_TRUNC   	0x0c00   	/* X'000c'   */
#define AP_PROG_ERROR_TRUNC      	0x0d00   	/* X'000d'   */
#define AP_PROG_ERROR_PURGING    	0x0e00   	/* X'000e'   */
#define AP_CONV_FAILURE_RETRY    	0x0f00   	/* X'000f'   */
#define AP_CONV_FAILURE_NO_RETRY     	0x1000   	/* X'0010'   */
#define AP_SVC_ERROR_NO_TRUNC    	0x1100   	/* X'0011'   */
#define AP_SVC_ERROR_TRUNC		0x1200   	/* X'0012'   */
#define AP_SVC_ERROR_PURGING     	0x1300   	/* X'0013'   */
#define AP_UNSUCCESSFUL			0x1400   	/* X'0014'   */
#define AP_CONVERSATION_TYPE_MIXED   	0x1900   	/* X'0019'   */
#define AP_CANCELLED     		0x2100   	/* X'0021'   */
#define AP_TP_BUSY       		0x02f0   	/* X'f002'   */
#define AP_COMM_SUBSYSTEM_ABENDED    	0x03f0   	/* X'f003'   */
#define AP_COMM_SUBSYSTEM_NOT_LOADED 	0x04f0   	/* X'f004'   */
#define AP_CONV_BUSY		 	0x05f0   	/* X'f005'   */
#define AP_THREAD_BLOCKING	 	0x06f0   	/* X'f006'   */
#define AP_INVALID_VERB_SEGMENT  	0x08f0   	/* X'f008'   */
#define AP_UNEXPECTED_DOS_ERROR  	0x11f0   	/* X'f011'   */
#define AP_STACK_TOO_SMALL   		0x15f0   	/* X'f015'   */
#define AP_INVALID_VERB      		0xffff   	/* X'ffff'   */

/*****************************************************************************/
/* ---------------------------- parameters --------------------------------- */
/*****************************************************************************/

/*****************************************************************************/
/* opext and conv_type                                                       */
/*****************************************************************************/
#define AP_BASIC_CONVERSATION    	0x00
#define AP_MAPPED_CONVERSATION   	0x01

/*****************************************************************************/
/* rts_rcvd and return_status_with_data                                      */
/*****************************************************************************/
#define AP_NO        			0x00
#define AP_YES       			0x01

/*****************************************************************************/
/* sync_level, security and send_type                                        */
/*****************************************************************************/
#define AP_NONE      			0x00

/*****************************************************************************/
/* sync_level                                                                */
/*****************************************************************************/
#define AP_CONFIRM_SYNC_LEVEL    	0x01

/*****************************************************************************/
/* security                                                                  */
/*****************************************************************************/
#define AP_SAME      			0x01
#define AP_PGM       			0x02

/*****************************************************************************/
/* dealloc_type and ptr_type                                                 */
/*****************************************************************************/
#define AP_SYNC_LEVEL    		0x00

/*****************************************************************************/
/* dealloc_type and ptr_type                                                 */
/*****************************************************************************/
#define AP_FLUSH			0x01

/*****************************************************************************/
/* dealloc_type                                                              */
/*****************************************************************************/
#define AP_ABEND_PROG			0x02
#define AP_ABEND_SVC			0x03
#define AP_ABEND_TIMER			0x04
#define AP_ABEND			0x05

/*****************************************************************************/
/* locks                                                                     */
/*****************************************************************************/
#define AP_SHORT			0x00
#define AP_LONG      			0x01

/*****************************************************************************/
/* what_rcvd             */
/*****************************************************************************/
#define AP_DATA      			0x0100   	/* X'0001'   */
#define AP_DATA_COMPLETE     		0x0200   	/* X'0002'   */
#define AP_DATA_INCOMPLETE   		0x0400   	/* X'0004'   */
#define AP_SEND      			0x0001   	/* X'0100'   */
#define AP_CONFIRM_WHAT_RECEIVED     	0x0002   	/* X'0200'   */
#define AP_CONFIRM_SEND      		0x0003   	/* X'0300'   */
#define AP_CONFIRM_DEALLOCATE    	0x0004   	/* X'0400'   */

#define AP_DATA_COMPLETE_SEND       	0x0201    	/* X'0102'   */
#define AP_DATA_COMPLETE_CONFIRM    	0x0202    	/* X'0202'   */
#define AP_DATA_COMPLETE_CONFIRM_SEND   0x0203    	/* X'0302'   */
#define AP_DATA_COMPLETE_CONFIRM_DEALL 	0x0204    	/* X'0402'   */

#define AP_DATA_SEND        		0x0101    	/* X'0101'   */
#define AP_DATA_CONFIRM     		0x0102    	/* X'0201'   */
#define AP_DATA_CONFIRM_SEND    	0x0103    	/* X'0301'   */
#define AP_DATA_CONFIRM_DEALLOCATE     	0x0104    	/* X'0401'   */

/*****************************************************************************/
/* fill              */
/*****************************************************************************/
#define AP_BUFFER        		0x00
#define AP_LL        			0x01

 
/*****************************************************************************/
/* rtn_ctl               */
/*****************************************************************************/
#define AP_WHEN_SESSION_ALLOCATED    	0x00
#define AP_IMMEDIATE     		0x01
#define AP_WHEN_SESSION_FREE     	0x02
#define AP_WHEN_CONWINNER_ALLOC		0x03
#define AP_WHEN_CONV_GROUP_ALLOC	0x04

/*****************************************************************************/
/* err_type              */
/*****************************************************************************/
#define AP_PROG      			0x00
#define AP_SVC       			0x01

/*****************************************************************************/
/* send_type             */
/*****************************************************************************/
#define AP_SEND_DATA_FLUSH   		0x01
#define AP_SEND_DATA_CONFIRM     	0x02
#define AP_SEND_DATA_P_TO_R_FLUSH    	0x03
#define AP_SEND_DATA_P_TO_R_SYNC_LEVEL	0x04
#define AP_SEND_DATA_DEALLOC_FLUSH   	0x05
#define AP_SEND_DATA_DEALLOC_SYNC_LEVEL	0x06
#define AP_SEND_DATA_DEALLOC_ABEND   	0x07

/*****************************************************************************/
/* err_dir               */
/*****************************************************************************/
#define  AP_RCV_DIR_ERROR		0x00
#define  AP_SEND_DIR_ERROR		0x01

/*****************************************************************************/
/* end_type              */
/*****************************************************************************/
#define AP_SOFT      			0x00
#define AP_HARD      			0x01

/* ========================================================================= 
*/
/*****************************************************************************/
/* ------------------------- vcb structures -------------------------------- */
/*****************************************************************************/

/*****************************************************************************/
/* structure for logical unit-of-work ids	 */
/*****************************************************************************/
typedef struct luw_id_overlay
{
	BYTE	fq_length;
	BYTE	fq_luw_name[17];
	BYTE	instance[6];
	BYTE	sequence[2];
}	LUW_ID_OVERLAY;

/*****************************************************************************/
/* common vcb header             */
/*****************************************************************************/
typedef struct appc_hdr
{
WORD	opcode;
BYTE	opext;
BYTE	reserv2;
WORD	primary_rc;
DWORD	secondary_rc;
} VCB, FAR * LPVCB;

 
/*****************************************************************************/
/* control vcbs              */
/*****************************************************************************/
typedef struct tp_started
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	lu_alias[8];
	BYTE	tp_id[8];
	BYTE	tp_name[64];
} TP_STARTED;

typedef struct receive_allocate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_name[64];
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	sync_level;	/* AP_NONE       */
	/* AP_CONFIRM_SYNC_LEVEL     */
	BYTE	conv_type;	/* AP_BASIC_CONVERSATION     */
				/* AP_MAPPED_CONVERSATION    */
	BYTE	user_id[10];
	BYTE	lu_alias[8];
	BYTE	plu_alias[8];
	BYTE	mode_name[8];
	BYTE	reserv3[28];
} RECEIVE_ALLOCATE;

typedef struct tp_ended
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	BYTE	type;		/* AP_SOFT			 */
				/* AP_HARD       */
} TP_ENDED;

/*****************************************************************************/
/* mapped conversation vcbs          */
/*****************************************************************************/
typedef struct mc_allocate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3;
	BYTE	sync_level;	/* AP_NONE       */
				/* AP_CONFIRM_SYNC_LEVEL     */
	BYTE	reserv4[2];
	BYTE	rtn_ctl;	/* AP_WHEN_SESSION_ALLOCATED     */
				/* AP_IMMEDIATE      */
				/* AP_WHEN_SESSION_FREE      */
				/* AP_WHEN_CONV_GROUP_ALLOC */
				/* AP_WHEN_CONWINNER_ALLOC */
	BYTE	reserv4a;
	DWORD	conv_group_id;
	DWORD	sense_data;
	BYTE	plu_alias[8];
	BYTE	mode_name[8];
	BYTE	tp_name[64];
	BYTE	security;		/* AP_NONE       */
					/* AP_SAME       */
					/* AP_PGM        */
	BYTE	reserv6[11];
	BYTE	pwd[10];
	BYTE	user_id[10];
	WORD	pip_dlen;
	LPBYTE	pip_dptr;
	BYTE	reserv6a;
	BYTE	fqplu_name[17];
	BYTE	reserv7[8];
} MC_ALLOCATE;

typedef struct mc_confirm
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
} MC_CONFIRM;

typedef struct mc_confirmed
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
} MC_CONFIRMED;

 
typedef struct mc_deallocate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3;
	BYTE	dealloc_type;	/* AP_SYNC_LEVEL     */
			 	/* AP_FLUSH      */
			 	/* AP_ABEND      */
	BYTE	reserv4[2];
	BYTE	reserv5[4];
} MC_DEALLOCATE;

typedef struct mc_flush
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
} MC_FLUSH;

typedef struct mc_get_attributes
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3;
	BYTE	sync_level;	/* AP_NONE       */
				/* AP_CONFIRM_SYNC_LEVEL     */
	BYTE	mode_name[8];
	BYTE	net_name[8];
	BYTE	lu_name[8];
	BYTE	lu_alias[8];
	BYTE	plu_alias[8];
	BYTE	plu_un_name[8];
	BYTE	reserv4[2];
	BYTE	fqplu_name[17];
	BYTE	reserv5;
	BYTE	user_id[10];
	DWORD	conv_group_id;
	BYTE 	conv_corr_len;
	BYTE	conv_corr_id[8];
	BYTE	reserv6[13];
} MC_GET_ATTRIBUTES;

 
typedef struct mc_prepare_to_receive
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	ptr_type;	/* AP_SYNC_LEVEL     */
				/* AP_FLUSH      */
	BYTE	locks;		/* AP_SHORT      */
				/* AP_LONG       */
} MC_PREPARE_TO_RECEIVE;

typedef struct mc_receive_and_post
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	WORD    what_rcvd;	/* AP_DATA       */
				/* AP_DATA_COMPLETE      */
				/* AP_DATA_INCOMPLETE    */
				/* AP_SEND       */
				/* AP_CONFIRM_WHAT_RECEIVED  */
				/* AP_CONFIRM_SEND       */
				/* AP_CONFIRM_DEALLOCATE     */
	BYTE	rtn_status;	/* AP_NO         */
				/* AP_YES        */
	BYTE    reserv4;
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv5;
	WORD	max_len;
	WORD	dlen;
	LPBYTE	dptr;
	LPBYTE	sema;
	BYTE	reserv6;
} MC_RECEIVE_AND_POST;

 
typedef struct mc_receive_and_wait
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	WORD    what_rcvd;	/* AP_DATA       */
				/* AP_DATA_COMPLETE      */
				/* AP_DATA_INCOMPLETE    */
				/* AP_SEND       */
				/* AP_CONFIRM_WHAT_RECEIVED  */
				/* AP_CONFIRM_SEND       */
				/* AP_CONFIRM_DEALLOCATE     */
	BYTE	rtn_status;	/* AP_NO         */
				/* AP_YES        */
	BYTE    reserv4;
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv5;
	WORD	max_len;
	WORD	dlen;
	LPBYTE	dptr;
	BYTE	reserv6[5];
} MC_RECEIVE_AND_WAIT;

 
typedef struct mc_receive_immediate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	WORD    what_rcvd;	/* AP_DATA       */
				/* AP_DATA_COMPLETE      */
				/* AP_DATA_INCOMPLETE    */
				/* AP_SEND       */
				/* AP_CONFIRM_WHAT_RECEIVED  */
				/* AP_CONFIRM_SEND       */
				/* AP_CONFIRM_DEALLOCATE     */
	BYTE	rtn_status;	/* AP_NO         */
				/* AP_YES        */
	BYTE    reserv4;
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv5;
	WORD	max_len;
	WORD	dlen;
	LPBYTE	dptr;
	BYTE	reserv6[5];
} MC_RECEIVE_IMMEDIATE;

typedef struct request_to_send
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
} REQUEST_TO_SEND, MC_REQUEST_TO_SEND;

 
typedef struct mc_send_conversation 
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	BYTE	reserv3[8];
	BYTE	rtn_ctl;		/* AP_WHEN_SESSION_ALLOCATED     */
					/* AP_IMMEDIATE      */
					/* AP_WHEN_SESSION_FREE      */
					/* AP_WHEN_CONV_GROUP_ALLOC */
					/* AP_WHEN_CONWINNER_ALLOC */
	BYTE	reserv4;
         DWORD	conv_group_id;
	DWORD	sense_data;
	BYTE	plu_alias[8];
	BYTE	mode_name[8];
	BYTE	tp_name[64];
	BYTE	security;		/* AP_NONE       */
					/* AP_SAME       */
					/* AP_PGM        */
	BYTE	reserv6[11];
	BYTE	pwd[10];
	BYTE	user_id[10];
	WORD	pip_dlen;
	LPBYTE	pip_dptr;
	BYTE	reserv6a;
	BYTE	fqplu_name[17];
	BYTE	reserv7[8];
	WORD	dlen;
	LPBYTE	dptr;
} MC_SEND_CONVERSATION;

typedef struct send_data
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv3;
	WORD	dlen;
	LPBYTE	dptr;
	BYTE	type;		/* AP_SEND_DATA_FLUSH    */
				/* AP_SEND_DATA_CONFIRM      */
				/* AP_SEND_DATA_P_TO_R_FLUSH     */
				/* AP_SEND_DATA_P_TO_R_SYNC_LEVEL    */
				/* AP_SEND_DATA_DEALLOC_FLUSH    */
				/* AP_SEND_DATA_DEALLOC_SYNC_LEVEL   */
				/* AP_SEND_DATA_DEALLOC_ABEND    */
	BYTE	reserv4;
} SEND_DATA, MC_SEND_DATA;

typedef struct mc_send_error
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	rts_rcvd;		/* AP_NO         */
					/* AP_YES        */
	BYTE	reserv3;
	BYTE	err_dir;		/* AP_RCV_DIR_ERROR      */
					/* AP_RCV_DIR_ERROR      */
	BYTE	reserv4;
	BYTE	reserv5[2];
	BYTE	reserv6[4];
} MC_SEND_ERROR;

 
typedef struct test_rts
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3;
} TEST_RTS, MC_TEST_RTS;

/*****************************************************************************/
/* basic conversation vcbs           */
/*****************************************************************************/
typedef struct allocate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	conv_type;	/* AP_BASIC_CONVERSATION     */
       				/* AP_MAPPED_CONVERSATION    */
	BYTE	sync_level;	/* AP_NONE       */
				/* AP_CONFIRM_SYNC_LEVEL     */
	BYTE	reserv3[2];
	BYTE	rtn_ctl;	/* AP_WHEN_SESSION_ALLOCATED     */
				/* AP_IMMEDIATE      */
				/* AP_WHEN_SESSION_FREE      */
				/* AP_WHEN_CONV_GROUP_ALLOC */
				/* AP_WHEN_CONWINNER_ALLOC */
	BYTE	reserv3a;
	DWORD     conv_group_id;
	DWORD	sense_data;
	BYTE	plu_alias[8];
	BYTE	mode_name[8];
	BYTE	tp_name[64];
	BYTE	security;	/* AP_NONE       */
       				/* AP_SAME       */
       				/* AP_PGM        */
	BYTE	reserv5[11];
	BYTE	pwd[10];
	BYTE	user_id[10];
	WORD	pip_dlen;
	LPBYTE	pip_dptr;
	BYTE 	reserv5a;
	BYTE	fqplu_name[17];
	BYTE	reserv6[8];
} ALLOCATE;

 
typedef struct confirm
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
} CONFIRM;

typedef struct confirmed
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
} CONFIRMED;

typedef struct deallocate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3;
	BYTE	dealloc_type;	/* AP_SYNC_LEVEL     */
				/* AP_FLUSH      */
				/* AP_ABEND_PROG     */
				/* AP_ABEND_SVC      */
				/* AP_ABEND_TIMER    */
	WORD	log_dlen;
	LPBYTE	log_dptr;
} DEALLOCATE;

typedef struct flush
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
} FLUSH;

 
typedef struct get_attributes
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3;
	BYTE	sync_level;	/* AP_NONE       */
				/* AP_CONFIRM_SYNC_LEVEL     */
	BYTE	mode_name[8];
	BYTE	net_name[8];
	BYTE	lu_name[8];
	BYTE	lu_alias[8];
	BYTE	plu_alias[8];
	BYTE	plu_un_name[8];
	BYTE	reserv4[2];
	BYTE	fqplu_name[17];
	BYTE	reserv5;
	BYTE	user_id[10];
	DWORD	conv_group_id;
	BYTE 	conv_corr_len;
	BYTE	conv_corr_id[8];
	BYTE	reserv6[13];
} GET_ATTRIBUTES;

typedef struct prepare_to_receive
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	ptr_type;	/* AP_SYNC_LEVEL     */
				/* AP_FLUSH      */
	BYTE	locks;		/* AP_SHORT      */
				/* AP_LONG       */
} PREPARE_TO_RECEIVE;

 
typedef struct receive_and_post
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	WORD    what_rcvd;	/* AP_DATA       */
				/* AP_DATA_COMPLETE      */
				/* AP_DATA_INCOMPLETE    */
				/* AP_SEND       */
				/* AP_CONFIRM_WHAT_RECEIVED  */
				/* AP_CONFIRM_SEND       */
				/* AP_CONFIRM_DEALLOCATE     */
	BYTE	rtn_status;	/* AP_NO         */
				/* AP_YES        */
	BYTE	fill;		/* AP_BUFFER     */
				/* AP_LL         */
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv4;
	WORD	max_len;
	WORD	dlen;
	LPBYTE	dptr;
	LPBYTE	sema;
	BYTE	reserv5;
} RECEIVE_AND_POST;

 
typedef struct receive_and_wait
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	WORD    what_rcvd;	/* AP_DATA       */
				/* AP_DATA_COMPLETE      */
				/* AP_DATA_INCOMPLETE    */
				/* AP_SEND       */
				/* AP_CONFIRM_WHAT_RECEIVED  */
				/* AP_CONFIRM_SEND       */
				/* AP_CONFIRM_DEALLOCATE     */
	BYTE	rtn_status;	/* AP_NO         */
				/* AP_YES        */
	BYTE	fill;		/* AP_BUFFER     */
				/* AP_LL         */
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv4;
	WORD	max_len;
	WORD	dlen;
	LPBYTE	dptr;
	BYTE	reserv5[5];
} RECEIVE_AND_WAIT;

 
typedef struct receive_immediate
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	WORD    what_rcvd;	/* AP_DATA       */
				/* AP_DATA_COMPLETE      */
				/* AP_DATA_INCOMPLETE    */
				/* AP_SEND       */
				/* AP_CONFIRM_WHAT_RECEIVED  */
				/* AP_CONFIRM_SEND       */
				/* AP_CONFIRM_DEALLOCATE     */
	BYTE	rtn_status;	/* AP_NO         */
				/* AP_YES        */
	BYTE	fill;		/* AP_BUFFER     */
				/* AP_LL         */
	BYTE    rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	reserv4;
	WORD	max_len;
	WORD	dlen;
	LPBYTE	dptr;
	BYTE	reserv5[5];
} RECEIVE_IMMEDIATE;

typedef struct request_to_send
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
} REQUEST_TO_SEND;


 
typedef struct send_conversation
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	reserv3[8];
	BYTE	rtn_ctl;	/* AP_WHEN_SESSION_ALLOCATED     */
				/* AP_IMMEDIATE      */
				/* AP_WHEN_SESSION_FREE      */
				/* AP_WHEN_CONV_GROUP_ALLOC */
				/* AP_WHEN_CONWINNER_ALLOC */
	BYTE	reserv4;
	DWORD	conv_group_id;
	DWORD	sense_data;
	BYTE	plu_alias[8];
	BYTE	mode_name[8];
	BYTE	tp_name[64];
	BYTE	security;	/* AP_NONE       */
       				/* AP_SAME       */
       				/* AP_PGM        */
	BYTE	reserv5[11];
	BYTE	pwd[10];
	BYTE	user_id[10];
	WORD    pip_dlen;
	LPBYTE	pip_dptr;
	BYTE 	reserv5a;
	BYTE	fqplu_name[17];
	BYTE	reserv6[8];
	WORD	dlen;
	LPBYTE	dptr;
} SEND_CONVERSATION;

typedef struct send_error
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	rts_rcvd;	/* AP_NO         */
				/* AP_YES        */
	BYTE	err_type;	/* AP_PROG       */
				/* AP_SVC        */
	BYTE	err_dir;	/* AP_RCV_DIR_ERROR      */
				/* AP_RCV_DIR_ERROR      */
	BYTE	reserv3;
	WORD	log_dlen;
	LPBYTE	log_dptr;
} SEND_ERROR;


/*****************************************************************************/
/* type independent vcbs              */
/*****************************************************************************/
typedef struct get_tp_properties
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	BYTE	tp_name[64];
	BYTE	lu_alias[8];
	LUW_ID_OVERLAY luw_id;
	BYTE	fqlu_name[17];
	BYTE	reserv3[10];
	BYTE	user_id[10];
} GET_TP_PROPERTIES;

typedef struct get_type
{
	WORD	opcode;
	BYTE	opext;
	BYTE	reserv2;
	WORD	primary_rc;
	DWORD	secondary_rc;
	BYTE	tp_id[8];
	DWORD	conv_id;
	BYTE	conv_type;	/* AP_BASIC_CONVERSATION     */
				/* AP_MAPPED_CONVERSATION    */
} GET_TYPE;

/*---------------------------------------------------------------------------*/
/* Windows APPC Extention Return Codes.                      		     */
/*---------------------------------------------------------------------------*/

#define WAPPCALREADY         0xF000   /* An async call is already outstanding */
#define WAPPCINVALID         0xF001   /* Async Task Id is invalid             */
#define WAPPCCANCEL          0xF002   /* Blocking call was cancelled          */
#define WAPPCSYSNOTREADY     0xF003   /* Underlying subsystem not started     */
#define WAPPCVERNOTSUPPORTED 0xF004   /* Application version not supported    */


/*----------------------------------------------------------------------------*/
/* Api structre definitions                                                   */
/*----------------------------------------------------------------------------*/
#define	WAPPCDESCRIPTION_LEN	127

typdef struct tagWAPPCDATA {
	WORD	wVersion;
	char	szDescription[WAPPCDESCRIPTION_LEN+1];
} WAPPCDATA, * PWAPPCDATA, FAR * LPWAPPCDATA;

/*****************************************************************************/
/* ---------------------- APPC function prototypes ------------------------- */
/*****************************************************************************/

extern void WINAPI APPC( long );
extern HANDLE WINAPI WinAsyncAPPC( HWND, LPAPPC );
extern int WINAPI WinAPPCCancelAsyncRequest( HANDLE );
extern int WINAPI WinAPPCCancelBlockingCall(void);
extern BOOL WINAPI WinAPPCCleanup(void);
extern BOOL WINAPI WinAPPCIsBlocking(void);
extern int WINAPI WinAPPCStartup(WORD, LPWAPPCDATA );
extern FARPROC WINAPI WinAPPCSetBlockingHook( FARPROC );
extern BOOL WINAPI WinAPPCUnhookBlockingHook(void);

/* winappc.h */
