##
## WINDOWS.MK - nmake file general includes for windows development
##
## Version: 1.2 Copyright (C) 1990-92 Hutchins Software
## Author: Edward Hutchins
##
## Revisions:
## 10/10/90 added Zortech C++ support (sort of) - Ed.
## 02/24/91 added DLLEXT for other than DLL extensions - Ed.
## 02/28/91 added variable drive backups, and executeable backups - Ed.
## 03/13/91 added help compiler support (HELP = 1) - Ed.
## 06/01/91 raised segment limit to 200 for mondo links - Ed.
## 09/28/91 added /DDEBUG to debug compile comand line - Ed.
## 10/02/91 added recursive directory archive commands - Ed.
##

##
## include system specific path macros (only hardcoded path in system)
##

!include "c:\batch\machine.mk"

##
## make macros (no pun intended)
##

# allow sloppy defines for DEBUG, DLL and DLLEXT
!IFNDEF DEBUG
DEBUG = 0
!ENDIF

!IFNDEF DLL
DLL = 0
!ENDIF

!IFNDEF DLLEXT
DLLEXT = DLL
!ENDIF

!IFNDEF HELP
HELP = 0
!ENDIF

#command names
AS = masm
HC = hc
RC = rc -V
MSC = cl
ZTC = ztc
LINKER = link
IMPLIB = implib
MAPSYM = mapsym
CD = cd
CP = copy
XCP = xcopy >nul
RM = del >nul
MD = md >nul
LRF = echo >nul
SHOW = when -e
#AUDIT = when -fc:\batch\log.txt
ARC = pkzip -m -r -p -x*.mk
UNARC = pkunzip -o -d
ARC_EXT = ZIP

##
## compile flags
##

ZTCFLAGS_G = -a -br -c -W -R
ZTCFLAGS_D = -s -g
ZTCFLAGS_R = -o
!IF $(DLL)
ZTCFLAGS_MDL = -mmw
!ELSE
ZTCFLAGS_MDL = -mm
!ENDIF

MSCFLAGS_G = /c /W3 /G2ws /FPi /Zp /BATCH /nologo
MSCFLAGS_D = /Zi /Od /DDEBUG
MSCFLAGS_R = /Opwilt
!IF $(DLL)
MSCFLAGS_MDL = /AMw
!ELSE
MSCFLAGS_MDL = /AM
!ENDIF

#other flags
AFLAGS_G = /i$(ASM_INCL) /Mx /T
AFLAGS_D = /Z

LFLAGS_G = /NOE /NOD /BATCH /ALIGN:16 /SEGMENT:200
LFLAGS_D = /CO /M /NOF /NOP /MAP /LI
LFLAGS_R = /NOF /NOP

# working files
DEF_FILE = $(PROJ).def
LNK_FILE = $(TEMP)\$(PROJ).lnk
ARC_FILE = $(PROJ)
MAPFILE_D = $(TEMP)\$(PROJ).map
MAPFILE_R = NUL

##
## set up for library or exe compile
##

!IF $(DLL)

PROJECT = $(PROJ).$(DLLEXT)
!IF $(HELP)
TARGET = $(DEST)\$(PROJECT) $(PROJ).lib $(DEST)\$(PROJ).hlp
!ELSE
TARGET = $(DEST)\$(PROJECT) $(PROJ).lib
!ENDIF
LLIBS_G = mdllcew mwinlibc libw

!ELSE

PROJECT = $(PROJ).exe
!IF $(HELP)
TARGET = $(DEST)\$(PROJECT) $(DEST)\$(PROJ).hlp
!ELSE
TARGET = $(DEST)\$(PROJECT)
!ENDIF
LLIBS_G = mlibcew libw

!ENDIF

##
## start of dependency list
##

all: logo $(TARGET)
	$(DONE_CMD)

.SUFFIXES: .def .c .cpp .rc .lib .res .obj

$(DEST)\$(PROJECT) : $(DEF_FILE) $(OBJS) $(RESS)
!IF $(DEBUG)
	$(LRF) @<<$(LNK_FILE)
$(OBJS: = +^
)
$(TEMP)\$(PROJECT)
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
	$(LRF) @<<$(LNK_FILE)
$(OBJS: = +^
)
$(TEMP)\$(PROJECT)
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
	$(LINKER) @$(LNK_FILE)
	$(TEMP_DRV):
	$(CD) $(TEMP)
##!IF $(DEBUG)
##    $(MAPSYM) /l $(PROJ)
##    $(CP) $(PROJ).sym $(SYM)
##!ENDIF
	$(CP) $(ROOT)\$(PROJ)\*.res
	$(RC) $(RESS) $(PROJECT)
	$(CP) $(PROJECT) $(DEST)
	-@ $(RM) $(PROJ).*
	$(ROOT_DRV):
	$(CD) $(ROOT)\$(PROJ)

$(DEST)\$(PROJ).hlp : $(PROJ).hpj *.rtf
	$(HC) $(PROJ).hpj
	$(CP) $(PROJ).hlp $(DEST)\$(PROJ).hlp
	-@ $(RM) $(PROJ).hlp

logo :
	$(SHOW) ۲ making $(PROJ) 

clean :
	$(ROOT_DRV):
	$(CD) $(ROOT)\$(PROJ)
	-@ $(RM) *.obj
	-@ $(RM) *.res
	-@ $(RM) *.lib

backup :
	$(ROOT_DRV):
	$(CD) $(ROOT)\$(PROJ)
	-@ $(MD) $(BACK_DRV):\$(PROJ)
	-@ $(XCP) *.* $(BACK_DRV):\$(PROJ) /S /E
!IFDEF HEAD
	-@ $(MD) $(BACK_DRV):\include
	$(CP) $(GLOBALS)\$(HEAD) $(BACK_DRV):\include
!ENDIF
!IFDEF FULL
	-@ $(MD) $(BACK_DRV):\bin
	$(CP) $(DEST)\$(PROJECT) $(BACK_DRV):\bin
!ENDIF
!IF $(DLL)
	-@ $(MD) $(BACK_DRV):\lib
	$(CP) $(LIB)\$(PROJ).lib $(BACK_DRV):\lib
!ENDIF

restore :
	$(ROOT_DRV):
	$(CD) $(ROOT)\$(PROJ)
	-@ $(XCP) $(BACK_DRV):\$(PROJ)\*.* /S /E
!IFDEF HEAD
	$(CP) $(BACK_DRV):\include\$(HEAD) $(GLOBALS)\$(HEAD)
!ENDIF
!IFDEF FULL
	$(CP) $(BACK_DRV):\bin\$(PROJECT) $(DEST)\$(PROJECT)
!ENDIF
!IF $(DLL)
	$(CP) $(BACK_DRV):\lib\$(PROJ).lib $(LIB)\$(PROJ).lib
!ENDIF

arc :
	$(ROOT_DRV):
	$(CD) $(ROOT)\$(PROJ)
	$(ARC) $(ARC_FILE)

unarc :
	$(ROOT_DRV):
	$(CD) $(ROOT)\$(PROJ)
	$(UNARC) $(ARC_FILE)
	-@ $(RM) $(ARC_FILE).$(ARC_EXT)

help :
	@ echo > aux: ͻ
	@ echo > aux:  WINDOWS.MK Version: 1.1 Copyright (C) 1990-92 Hutchins Soft 
	@ echo > aux: Ķ
	@ echo > aux:                Help on windows make arguments:               
	@ echo > aux: ͼ
	@ echo > aux: {no cmd}, all - build $(TARGET)
	@ echo > aux: clean         - remove intermediate files
	@ echo > aux: backup        - copy files to disk $(BACK_DRV):
	@ echo > aux: restore       - restore files from disk $(BACK_DRV):
	@ echo > aux: arc           - move $(PROJ) into $(ARC_FILE).$(ARC_EXT)
	@ echo > aux: unarc         - expand $(ARC_FILE).$(ARC_EXT) into $(PROJ)

##
## default inferencing rules
##

.def.lib :
	$(SHOW) $<
	$(IMPLIB) $@ $<
	$(CP) $@ $(LIB)\$(PROJ).lib
	-@ $(RM) $@

.rc.res :
	$(SHOW) $<
	$(RC) /r $<

.c.obj :
	$(SHOW) $<
!IF $(DEBUG)
	$(MSC) $(MSCFLAGS_G) $(MSCFLAGS_MDL) $(MSCFLAGS_D) /Fo$@ /NT $* $<
!ELSE
	$(MSC) $(MSCFLAGS_G) $(MSCFLAGS_MDL) $(MSCFLAGS_R) /Fo$@ /NT $* $<
!ENDIF

.cpp.obj :
	$(SHOW) $<
!IF $(DEBUG)
	$(ZTC) $(ZTCFLAGS_G) $(ZTCFLAGS_MDL) $(ZTCFLAGS_D) -o$@ $<
!ELSE
	$(ZTC) $(ZTCFLAGS_G) $(ZTCFLAGS_MDL) $(ZTCFLAGS_R) -o$@ $<
!ENDIF

.asm.obj :
	$(SHOW) $<
!IF $(DEBUG)
	$(AS) $(AFLAGS_G) $(AFLAGS_D) $<;
!ELSE
	$(AS) $(AFLAGS_G) $<;
!ENDIF
