//
// YOW - if you need to ask, forget it!
//
// Version: 1.1 09/11/91 Copyright (C) 1991, Lantern Corp.
// Author: Edward Hutchins
// Revisions:
//

#include "yow.h"

//
// globals
//

GLOBAL HANDLE   hAppInst;
GLOBAL HWND     hAppWnd;
GLOBAL CHAR     szAppName[8];
GLOBAL CHAR     szDBase[FILENAME_SIZE];
GLOBAL CHAR     szEndChar[2];

//
// YowWndProc - the main window proc for Yow
//

LONG FAR PASCAL EXPORT YowWndProc( HWND hWnd, WORD mess,
								   WORD wParam, LONG lParam )
{
	switch (mess)
	{
	case WM_CREATE:
		srand( hWnd ^ LOWORD(GetCurrentTime()) );
		break;

	case WM_SYSCOMMAND:
		switch (wParam)
		{
		case IDM_OPTIONS:
			SetYowOptions( hWnd );
			break;
		case IDM_ABOUT:
			AboutYow( hWnd );
			break;
		default:
			return( DefWindowProc( hWnd, mess, wParam, lParam ) );
		}
		break;

	case WM_SYSKEYDOWN:
	case WM_SYSCHAR:
	case WM_SYSKEYUP:
		switch (wParam)
		{
		case VK_MENU:
		case VK_ESCAPE:
		case VK_CONTROL:
		case VK_SHIFT:
		case VK_TAB:
		case VK_LEFT:
		case VK_RIGHT:
		case VK_UP:
		case VK_DOWN:
		case VK_NEXT:
		case VK_PRIOR:
		case VK_HOME:
		case VK_END:
			break;

		default:
			if (mess == WM_SYSKEYDOWN)
			{
				if (LOBYTE(lParam) == 1) // repeat count of one
				{
					if (wParam == VK_F1) YowHelp( hWnd );
					else Yow( wParam );
				}
			}
			return( 0 );
		}
		break;

	case WM_RBUTTONDOWN:
	case WM_NCRBUTTONDOWN:
		Yow( VK_RBUTTON );
		break;

	case WM_QUERYOPEN:
		return( FALSE ); // always an icon

	case WM_CLOSE:
	case WM_DESTROY:
        PostQuitMessage( 0 );
        break;

	default:
		return( DefWindowProc( hWnd, mess, wParam, lParam ) );
    }
	return( 0L );
}

//
// WinMain - everybody has to have one
//

INT FAR PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
						LPSTR lpszCmdLine, INT nCmdShow )
{
	MSG     msg;

	if (hPrevInstance)
	{
		MessageBeep( 0 );
		return( FALSE );
	}

	hAppInst = hInstance;
	if (!CreateYowClass()) return( FALSE );
	SetYowDBase( lpszCmdLine );
	hAppWnd = CreateYowWindow( nCmdShow = SW_MINIMIZE );
	if (hAppWnd == HNULL) return( FALSE );

	while (GetMessage( &msg, NULL, 0, 0 ))
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return( msg.wParam );
}
