//
// YOWDLGS - yow! dialogs!
//
// Version: 1.0 Copyright (C) 1991, Lantern Corp.
// Author: Edward Hutchins
// Revisions:
//

#include "yow.h"

//
// defines
//

#define YOW_HELP \
"This program is a graphical user interface version of fortune type " \
"programs. When you hold down the right mouse button or a key on Zippy, " \
"he will randomly look up an ASCII database by line, or by groups of " \
"lines if the end of line/group character is given."
#define YOW_HELPSTYLE (MB_OK | MB_ICONASTERISK)

//
// imports
//

IMPORT HANDLE   hAppInst FROM( yow.c );
IMPORT HWND     hAppWnd FROM( yow.c );
IMPORT CHAR     szAppName[8] FROM( yow.c );
IMPORT CHAR     szDBase[FILENAME_SIZE] FROM( yow.c );
IMPORT CHAR     szEndChar[2] FROM( yow.c );

//
// YowOptionsDlg - options dialog proc
//

BOOL FAR PASCAL EXPORT YowOptionsDlg( HWND hDlg, WORD mess,
									  WORD wParam, LONG lParam )
{
	switch (mess)
	{
	case WM_INITDIALOG:
		SetDlgItemText( hDlg, IDD_O_DBASE, szDBase );
		SetDlgItemText( hDlg, IDD_O_ENDCHAR, szEndChar );
		break;

	case WM_COMMAND:
		switch (wParam)
		{
		case IDOK:
			GetDlgItemText( hDlg, IDD_O_DBASE, szDBase, sizeof(szDBase) );
			GetDlgItemText( hDlg, IDD_O_ENDCHAR, szEndChar, sizeof(szEndChar) );
			EndDialog( hDlg, TRUE );
			break;

		case IDCANCEL:
			EndDialog( hDlg, FALSE );
			break;

		default:
			return( FALSE );
		}
		break;

	case WM_CLOSE:
		EndDialog( hDlg, FALSE );
		break;

	default:
		return( FALSE );
	}
	return( TRUE );
}

//
// SetYowOptions - set zippy's options
//

VOID FAR PASCAL SetYowOptions( HWND hWnd )
{
	FARPROC lpProc = MakeProcInstance( YowOptionsDlg, hAppInst );
	BOOL bUpdate = DialogBox( hAppInst, MAKEINTRESOURCE( IDD_OPTIONS ),
							  hWnd, lpProc );
	FreeProcInstance( lpProc );
	if (bUpdate)
	{
		CHAR szProp[40];
		LoadString( hAppInst, IDS_PRPDEFDBASE, szProp, sizeof(szProp) );
		WriteProfileString( szAppName, szProp, szDBase );
		LoadString( hAppInst, IDS_PRPDEFENDCHAR, szProp, sizeof(szProp) );
		WriteProfileString( szAppName, szProp, szEndChar );
	}
}

//
// YowHelp - show help
//

VOID FAR PASCAL YowHelp( HWND hWnd )
{
	MessageBox( hWnd, YOW_HELP, "Yow! Help!", YOW_HELPSTYLE );
}

//
// YowAboutDlg - the about box proc
//

BOOL FAR PASCAL EXPORT YowAboutDlg( HWND hDlg, WORD mess,
									WORD wParam, LONG lParam )
{
	switch (mess)
	{
	case WM_INITDIALOG:
		break;

	case WM_COMMAND:
		switch (wParam)
		{
		case IDD_A_HELP:
			YowHelp( hDlg );
			// fall through...
		case IDOK:
			EndDialog( hDlg, 0 );
			break;

		default:
			return( FALSE );
		}
		break;

	case WM_CLOSE:
		EndDialog( hDlg, FALSE );
		break;

	default:
		return( FALSE );
	}
	return( TRUE );
}

//
// AboutYow - show the about box
//

VOID FAR PASCAL AboutYow( HWND hWnd )
{
	FARPROC lpprocAbout = MakeProcInstance( YowAboutDlg, hAppInst );
	DialogBox( hAppInst, MAKEINTRESOURCE( IDD_ABOUT ),
			   hWnd, lpprocAbout );
	FreeProcInstance( lpprocAbout );
}

