//
// YOWSUPP - yow! supporting functions!
//
// Version: 1.0 Copyright (C) 1991, Lantern Corp.
// Author: Edward Hutchins
// Revisions:
// 09/11/91 added this file to reduce YOW segment size - Ed.
//

#include "yow.h"

//
// imports
//

IMPORT HANDLE   hAppInst;
IMPORT HWND     hAppWnd;
IMPORT CHAR     szAppName[8];
IMPORT CHAR     szDBase[FILENAME_SIZE];
IMPORT CHAR     szEndChar[2];

//
// CreateYowClass - create the class of Yow's window
//

BOOL FAR PASCAL CreateYowClass( VOID )
{
	WNDCLASS        Class;

	// load the name from the resource file
	LoadString( hAppInst, IDS_NAME, szAppName, sizeof(szAppName) );

	Class.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT;
	Class.lpfnWndProc = YowWndProc;
	Class.cbClsExtra = 0;
	Class.cbWndExtra = 0;
	Class.hInstance = hAppInst;
	Class.hIcon = LoadIcon( hAppInst, MAKEINTRESOURCE( IDI_YOW ) );
	Class.hCursor = LoadCursor( NULL, IDC_ARROW );
	Class.hbrBackground = COLOR_BTNFACE + 1;
	Class.lpszMenuName = NULL;
	Class.lpszClassName = szAppName;

	return( RegisterClass( &Class ) );
}

//
// SetYowMenu - add yow's menu items to the system menu
//

VOID NEAR PASCAL SetYowMenu( HWND hWnd, INT nFirstID, INT nLastID )
{
	CHAR        szMenuName[40];
	HMENU       hMenu;

	hMenu = GetSystemMenu( hWnd, TRUE );
	if (hMenu == HNULL) hMenu = GetSystemMenu( hWnd, FALSE );
	if (hMenu == HNULL) return;

	// delete unwanted menu items
	DeleteMenu( hMenu, SC_RESTORE, MF_BYCOMMAND );
	DeleteMenu( hMenu, SC_SIZE, MF_BYCOMMAND );
	DeleteMenu( hMenu, SC_MINIMIZE, MF_BYCOMMAND );
	DeleteMenu( hMenu, SC_MAXIMIZE, MF_BYCOMMAND );

	while (nFirstID <= nLastID)
	{
		LoadString( hAppInst, nFirstID, szMenuName, sizeof(szMenuName) );
		ChangeMenu( hMenu, 0, szMenuName, nFirstID, MF_APPEND );
		++nFirstID;
	}
}

//
// CreateYowWindow - open the Yow window
//

HWND FAR PASCAL CreateYowWindow( INT nCmdShow )
{
	HWND        hWnd;

	hWnd = CreateWindow( szAppName, szAppName,
						 WS_OVERLAPPEDWINDOW,
						 CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
						 HNULL, HNULL, hAppInst, NULL );
	if (hWnd == HNULL) return( HNULL );
	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );
	SetYowMenu( hWnd, IDM_OPTIONS, IDM_ABOUT );
	return( hWnd );
}

//
// SetYowDBase - set the lines database
//

VOID FAR PASCAL SetYowDBase( LPSTR lpszFile )
{
	CHAR            szProp[40];

	if (!lpszFile || *lpszFile == '\0')
	{
		LoadString( hAppInst, IDS_PRPDEFDBASE, szProp, sizeof(szProp) );
		LoadString( hAppInst, IDS_DEFDBASE, szDBase, sizeof(szDBase) );
		GetProfileString( szAppName, szProp, szDBase, szDBase, sizeof(szDBase) );
	}
	else lstrcpy( szDBase, lpszFile );

	LoadString( hAppInst, IDS_PRPDEFENDCHAR, szProp, sizeof(szProp) );
	LoadString( hAppInst, IDS_DEFENDCHAR, szEndChar, sizeof(szEndChar) );
	GetProfileString( szAppName, szProp, szEndChar, szEndChar, sizeof(szEndChar) );
}

