/* ReadSet.C
  Pete Davis 02/25/93

  Part of the install program for the Windows Programmer's Journal Vol 1 No 3

  Reads the SETUP.INF file on the SRCDRV disk to get all the installation
  parameters. 
*/

#define MSFIX
#define STRICT
#include <windows.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include "readset.h"

extern HANDLE	 	THandle;
extern LInstInfo 	InstallInfo;
extern FAppList 	CurApp;
extern int 			NumDisks;


/* Get the installation setups as provided in the SETUP.INF on the first
   disk of the application to install.
*/

BOOL GetInstallInfo(HWND hWnd, HANDLE hDlgModeless, char *SrcDrv) {

  char EMsg[40];
  char SetFile[18];
  HFILE SetUpFile;
  char *FStart;
  unsigned int ByteCount;


/* Get it from our source drive */
  strcpy(SetFile, SrcDrv);
  strcat(SetFile, ":\\SETUP.INF\0");


  SetUpFile = _lopen((LPSTR)SetFile, READ);

  /* If Problems with opening SETUP.INF file, then tell user */

  if (SetUpFile == HFILE_ERROR) {

    strcpy(EMsg, SetFile);
    strcat(EMsg, " not found on Install Disk!\0");

    SetDlgItemText(hDlgModeless, 101, EMsg);

    strcpy(EMsg, "Installation Canceled! \0");

    SetDlgItemText(hDlgModeless, 102, EMsg);

    _lclose(SetUpFile);
    return FALSE;
  }

  InstallInfo->Classified=FALSE;

  FStart = (char *) LocalAlloc(LMEM_FIXED, 8192);
  ByteCount = _lread(SetUpFile, FStart, 8192);

  /* We can't handle setup.inf files larger than 8k */

  if (ByteCount == 8192) {
    strcpy(EMsg, "SETUP.INF file is too larger.\0");
    SetDlgItemText(hDlgModeless, 101, EMsg);
    strcpy(EMsg, "Installation Canceled!\0");
    SetDlgItemText(hDlgModeless, 102, EMsg);
    _lclose(SetUpFile);
    LocalFree((HLOCAL) FStart);
    return FALSE;
  }

  _lclose(SetUpFile);


  ScanFile(hWnd, FStart, ByteCount);
  LocalFree((HLOCAL) FStart);
  return TRUE;
}


/* Scan through the file and collect the necessary information */

void ScanFile(HWND hWnd, char *FStart, UINT ByteCount) {

  char *FEnd, *FCur;
  int CLIdx;
  char CurLine[100];
  int Sect;

  FEnd = FStart + ByteCount;

  FCur = FStart;

  Sect = 1;

  /* This basically reads a line of text from the buffer */

  while (FCur < FEnd) {
    CLIdx = 0;
    while (*FCur != 13 & * FCur != 10) {
      CurLine[CLIdx++] = *FCur++;
    }
    CurLine[CLIdx++] = '\0';
    FCur += 2;

	/* Get any necessary info from line */
    Sect = ProcessLine(hWnd, Sect, CurLine);
  }

  return;
}


/* Process a single line */

int ProcessLine(HWND hWnd, int Sect, char *CurLine) {

FAppList TempApp;
static ProgNo=0;

  /* Skip a comment */
  if (*CurLine == ';') return(Sect);

  /* if we're in the first section, check for install specific data,
     we'll check for file info later                                  */
  if (Sect==1) {
    if (!strnicmp(CurLine, "appname", 7)) {
      appName(CurLine+8);
    }
    else if (!strnicmp(CurLine, "defpath", 7)) {
      defPath(CurLine+8);
    }
    else if (!strnicmp(CurLine, "spacereq", 8)) {
      spaceReq(CurLine+9);
    }
    else if (!strnicmp(CurLine, "grpfilename", 11)) {
      grpFileName(CurLine+12);
    }
    else if (!strnicmp(CurLine, "grpdesc", 7)) {
      grpDesc(CurLine+8);
    }
    /* This means we've started with the file data, so we
       start going to section 2 for reading data.             */
    else if (!strnicmp(CurLine, "infname", 7)) {
      Sect = 2;
    }
  } /* if(Sect==1) */

  /* If we're in the second session, start counting up the number of files
     and get all the variables.
  */

  if (Sect == 2) {

    /* On a new file */
    if(!strnicmp(CurLine,"infname",7)) {
      ProgNo++; /* Program number */
	
      /* Add a node for our linked list */
      THandle = GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE, sizeof(AppList));
      TempApp = (FAppList) GlobalLock(THandle);

      /* Set defaults */
      lstrcpy(TempApp->InFName, "\0");
      lstrcpy(TempApp->OutFName, "\0");
      lstrcpy(TempApp->OutPath, "\0");
      lstrcpy(TempApp->FileDesc, "\0");
      TempApp->DiskNum = 1;
      TempApp->FileType = 2;

      /* Add node into our linked list */
      TempApp->Next = InstallInfo->Apps;
      InstallInfo->Apps = TempApp;
      CurApp=TempApp;

      sinFName(CurLine+8);
    }

    /* The rest of this is data for the current file */
    else if(!strnicmp(CurLine,"outfname",8)) {
      soutFName(CurLine+9);
    }
    else if(!strnicmp(CurLine,"outpath",7)) {
      outPath(CurLine+8);
    }
    else if(!strnicmp(CurLine,"filedesc",8)) {
      fileDesc(CurLine+9);
    }
    else if(!strnicmp(CurLine,"disknum",7)) {
      diskNum(CurLine+8);
    }
    else if(!strnicmp(CurLine,"filetype",4)) {
      isExec(CurLine+5);
    }
  } /* If Sect == 2 */
  return(Sect);

}


/* The rest of the routines are simply to copy the data from the
   variables in the setup.inf to the structures in the program.
   It's all pretty straight-forward.
*/

void appName(char *data) {
  lstrcpy(InstallInfo->AppName, data);
}

void classified(char *data) {
  if (!strnicmp(data,"y",1)) InstallInfo->Classified = TRUE;
}

void defPath(char *data) {
  lstrcpy(InstallInfo->DefPath, data);
}

void spaceReq(char *data) {
 InstallInfo->TotSpaceReq = atol(data);
}

void grpFileName(char *data) {
  lstrcpy(InstallInfo->GrpFileName, data);
}

void grpDesc(char *data) {
  lstrcpy(InstallInfo->GrpDesc, data);
}

void sinFName(char *data) {
  lstrcpy(CurApp->InFName, data);
}

void soutFName(char *data) {
  lstrcpy(CurApp->OutFName, data);
}

void outPath(char *data) {
  lstrcpy(CurApp->OutPath, data);
}

void fileDesc(char *data) {
  lstrcpy(CurApp->FileDesc, data);
}

void diskNum(char *data) {
  CurApp->DiskNum = atoi(data);
  if(CurApp->DiskNum > NumDisks) NumDisks = CurApp->DiskNum;
}

void fileType(char *data) {
  CurApp->FileType = atoi(data);
}



