/*----------------------------------------------------------------------------*\
|   rleapp.h - The RLE app                                                     |
|                                                                              |
\*----------------------------------------------------------------------------*/

#define EXPORT  FAR  PASCAL _export     // exported function
typedef LONG (FAR PASCAL *LPWNDPROC)(); // pointer to a window procedure

/*----------------------------------------------------------------------------*\
 * Menu Items
\*----------------------------------------------------------------------------*/

#define MENU_ABOUT       500
#define MENU_EXIT        501

#define MENU_COPY        502
#define MENU_CUT         503
#define MENU_OPEN        504
#define MENU_NEW         505
#define MENU_PLAY        506
#define MENU_WINDOW      507
#define MENU_PREV        511
#define MENU_NEXT        512
#define MENU_REDRAW      513
#define MENU_OPENRLE     514
#define MENU_REVERT      515

#define MENU_LOAD_APPEND    520
#define MENU_LOAD_INSERT    521

#define MENU_PASTE_APPEND   522
#define MENU_PASTE_INSERT   523
#define MENU_PASTE_REPLACE  524
#define MENU_PASTE_PALETTE  525

#define MENU_DELETE_FRAME   526
#define MENU_DELETE_FRAMES  527
#define MENU_GOTO_FRAME     528
#define MENU_FRAMES_SEC     529
#define MENU_STATUS         531

#define MENU_FULLPAINT      534
#define MENU_PURGE          535
#define MENU_RLEFRAMES      536
#define MENU_REALIZE        537
#define MENU_IDENTITY       538
#define MENU_320x240        539
#define MENU_320x200        540
#define MENU_SKIPFRAMES     561

#define MENU_SAVE_RLE       543
#define MENU_SAVE_FRAMES    544
#define MENU_SAVE_RL0       545
#define MENU_SAVE_WAVE      546

/*----------------------------------------------------------------------------*\
 * Dialog IDs
\*----------------------------------------------------------------------------*/

#define ABOUTBOX            100
#define DLG_RANGE           101
#define RLEDLGBOX           102
#define FRAMEDLG            103

#define ID_EDIT             200
#define ID_SCROLL           210
#define ID_TEXT             220
#define ID_FRAMESSEC        230


/*----------------------------------------------------------------------------*\
 * public globals and structures in RLEAPP.C
\*----------------------------------------------------------------------------*/

#define MAXFRAMES   3500		// DON'T CHANGE!!
					// If MAXFRAMES * sizeof(FRAME) gets
					// > 64K then arFrames will have to be
					// a huge *

typedef struct {
    HANDLE      hdib;
    HANDLE      hrle;
    HPALETTE    hpal;
    WORD        f;
}   FRAME;

#define F_PALSHARED  0x0001     // frame HPAL is same as previous frame
#define F_KEYFRAME   0x0002     // key frame
#define F_RLE        0x0020     // frame is RLE compressed

#define FramePalette(n) (arFrames[n].hpal)
#define FrameDib(n)     (arFrames[n].hdib ? arFrames[n].hdib : arFrames[n].hrle)
#define FrameRle(n)     (arFrames[n].hrle ? arFrames[n].hrle : arFrames[n].hdib)
#define FrameFlags(n)   (arFrames[n].f)
#define IsFrameRLE(n)   (arFrames[n].hrle && (arFrames[n].f & F_RLE))
#define IsFrameDIB(n)   (arFrames[n].hdib && !arFrames[n].hrle)

extern FRAME far *  arFrames;
extern int          numFrames;
extern int          totFrames;
extern int          curFrame;
extern BOOL         fLoading;

#define             FramesSecScale      1000l
extern long         FramesSec;

extern LPWAVEFORMAT pWaveFormat;
extern LPWAVEHDR    pwhMovie;
extern HWAVEOUT     hWaveOut;
extern int          gChannels;          // Info about the Wave data
extern DWORD        gSamplesPerSec;
extern DWORD        gdwBufferLength;    // start and len of movie's 1st wave
extern BYTE huge  * glpData;

/*----------------------------------------------------------------------------*\
 * RLEAPP.C
\*----------------------------------------------------------------------------*/

extern void     StartWait(void);
extern void     EndWait(void);
extern BOOL     WinYield(void);
extern void     ShowFrame(int iFrame);
extern HANDLE   RenderFrame(int iFrame);
extern BOOL     InsertFrame(HANDLE hdib, int iFrame, BOOL fRender);
extern BOOL     DeleteFrame(int iFrame);
extern void     PurgeFrames(void);

/*----------------------------------------------------------------------------*\
 * MEM.ASM
\*----------------------------------------------------------------------------*/
extern LPVOID FAR PASCAL MemCopy(LPVOID dest, LPVOID source, LONG count);
extern LPVOID FAR PASCAL MemFill(LPVOID dest, LONG count, BYTE b);
extern long   FAR PASCAL muldiv32(long,long,long);

/*----------------------------------------------------------------------------*\
 *  RLEFILE.C
\*----------------------------------------------------------------------------*/

extern BOOL OpenMovieFile(LPSTR szFrame, int iFrame);
extern BOOL OpenWavFile(LPSTR szFrame);

extern void SaveRl0File(LPSTR szFile,int startFrame,int nFrames);
extern void SaveRleFile(LPSTR szFile,int startFrame,int nFrames);
extern BOOL SaveWavFile(LPSTR szFile,int startFrame,int nFrames);

/*----------------------------------------------------------------------------*\
 *  RLEDLG.C
\*----------------------------------------------------------------------------*/

typedef struct {
    LPSTR       lpCaption;
    int         current,min,max;
} RANGEDIALOGPARAM, far *LPRANGEDIALOGPARAM;

BOOL fDialog(int id,HWND hwnd,FARPROC fpfn);
BOOL fDialogParam(int id,HWND hwnd,FARPROC fpfn,DWORD dwParam);
int  ErrMsg (LPSTR sz,...);

BOOL EXPORT fnRangeDlg     (HWND, short, WORD, LONG);
BOOL EXPORT fnResizeDlg    (HWND, short, WORD, LONG);
BOOL EXPORT AppAbout       (HWND, short, WORD, LONG);
BOOL EXPORT FrameDlgProc   (HWND, short, WORD, LONG);
