/****************************************************************************
*
*  FILE:          SSHOOK.C
*
*  DESCRIPTION:   Dynamic Link Library for Screen Saver.
*                 These functions form a DLL for a Windows Keyboard Hook
*                 function.
*
*                 This software is hereby placed in the public domain.
*                 Use and abuse it at your own risk!
*
*
*  AUTHOR:        Tom Wheeler
*                 31294 Morlock
*                 Livonia, Mich.  48152
*                 [72037,1742]
*
*****************************************************************************
*
*     DATE                                DESCRIPTION
*  ----------     -----------------------------------------------------------
*   10/11/90      Initial Development
*   11/02/90      Minor improvements to structure
*
****************************************************************************/

#include <windows.h>
#include "ss.h"

/******************************** VARIABLES ********************************/

HANDLE hInst = NULL;
HANDLE hUserHandle = NULL;
FARPROC lpfnKeyHook = NULL;
FARPROC lpfnOldKeyHook = NULL;

/******************************** FUNCTIONS ********************************/

/****************************************************************************
*
*  int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD cbHeapSize,
*                         LPSTR lpszCmdLine)
*
*  DESCRIPTION:   DLL Initialization function.  Called from LIBENTRY.ASM
*                 which is the startup code for the DLL.
*
*  INPUT:         hInstance      - This modules instance Handle
*                 wDataSeg       - This modules Data Segment
*                 cbHeapSize     - Size of heap (if any)
*                 lpszCmdLine    - Command line parameters
*
*  OUTPUT:        Returns 1 (TRUE) to indicate success
*
****************************************************************************/
int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD cbHeapSize,
                       LPSTR lpszCmdLine)
{
   hInst = hInstance;               /* store instance Handle               */
   if(cbHeapSize != 0)              /* if DLL data seg is MOVEABLE         */
      UnlockData(0);
   return(1);                       /* initialization successful           */
}

/****************************************************************************
*
*  int FAR PASCAL WEP(int nParameter)
*
*  DESCRIPTION:   DLL Shutdown function.  Called when DLL is terminating.
*
*  INPUT:         nParameter     -  Termination Code
*
*  OUTPUT:        Returns 1 (TRUE) to indicate success
*
****************************************************************************/
int FAR PASCAL WEP(int nParameter)
{
   UnhookWindowsHook(WH_KEYBOARD,lpfnKeyHook);
   FreeProcInstance(lpfnKeyHook);
   return(1);
}

/****************************************************************************
*
*  DWORD FAR PASCAL KeyboardHook(int iCode,WORD wParam,LONG lParam)
*
*  DESCRIPTION:   Keyboard Hook function
*
*  INPUT:         iCode       - Windows Hook Code
*                 wParam      - Virtual Key Code
*                 lParam      - Status Bits
*
*  OUTPUT:        Calls DefHookProc after processing key
*
****************************************************************************/
DWORD FAR PASCAL KeyboardHook(int iCode,WORD wParam,LONG lParam)
{
   if((HIWORD(lParam) & 0x8000) && (iCode == HC_ACTION))
                                                   /* check if key is being
                                                    * released and not a non-
                                                    * process key          */
      PostMessage(hUserHandle,WM_HOOKKEY,wParam,lParam);
   return DefHookProc(iCode,wParam,lParam,(FARPROC FAR *)&lpfnOldKeyHook);
}

/****************************************************************************
*
*  BOOL FAR PASCAL InitHook(HANDLE hWnd)
*
*  DESCRIPTION:   Externally callable function intended for initialization.
*                 Allows this module to get a Handle to the user window and
*                 installs the Keyboard filter hook.
*
*  INPUT:         hWnd        - Users window handle
*
*  OUTPUT:        Returns TRUE if successful, FALSE otherwise
*
****************************************************************************/
BOOL FAR PASCAL InitHook(HANDLE hWnd)
{
   if(!hUserHandle) {
      hUserHandle = hWnd;
      lpfnKeyHook = MakeProcInstance((FARPROC)KeyboardHook,hInst);
      lpfnOldKeyHook = SetWindowsHook(WH_KEYBOARD,lpfnKeyHook);
      return TRUE;
   }
   else {
      MessageBox(hWnd,"SSHOOK.DLL already active!","SSHOOK",MB_ICONASTERISK |
                 MB_OK);
      return FALSE;
   }
}
