PROJ = SSHOOK
PROJFILE = SSHOOK.MAK
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
BIND  = bind
RC  = rc
IMPLIB  = implib
LFLAGS_G  =   /BATCH /ALIGN:16
LFLAGS_D  =  /CO /INC /NOF /NOP
LFLAGS_R  =  /F /PACKC /PACKD  /BATCH
MAPFILE_D  = NUL
MAPFILE_R  = NUL
CC  = cl
CFLAGS_G  = /Asnw /W3 /Gw /D_WINDOWS /Zp /BATCH
CFLAGS_D  = /Od /Zi
CFLAGS_R  = /Os /Og /Oe /Gs
LLIBS_R  =  /NOD:SLIBCE SDLLCEW
LLIBS_D  = /NOD:SLIBCE SDLLCEW
LLIBS_G  = LIBW.LIB
ASM  = masm
AFLAGS_G  = /Mx /T
AFLAGS_D  = /Zi

DEF_FILE  = SSHOOK.DEF
OBJS  = SSHOOK.obj LIBENTRY.obj
RESS  = SSHOOK.res
SBRS  = SSHOOK.sbr

all: $(PROJ).dll

.SUFFIXES: .c .sbr .rc .res .obj .asm

SSHOOK.obj : SSHOOK.C c:\windev\include\windows.h ss.h

SSHOOK.sbr : SSHOOK.C c:\windev\include\windows.h ss.h

LIBENTRY.obj : LIBENTRY.ASM c:\windev\include\cmacros.inc

SSHOOK.res : SSHOOK.RC


$(PROJ).bsc : $(SBRS)
        $(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).dll : $(DEF_FILE) $(OBJS) $(RESS)
!IF $(DEBUG)
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
        $(ILINK) -a -e "$(LINKER) @$(PROJ).lrf" $@
!ELSE
        $(LINKER) @$(PROJ).lrf
!ENDIF
        $(RC) $(RESS) $@
        $(IMPLIB) $*.lib $@


.c.sbr :
!IF $(DEBUG)
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF

.rc.res :
        $(RC) /r $<

.c.obj :
!IF $(DEBUG)
        $(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
        $(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.asm.obj :
!IF $(DEBUG)
        $(ASM) $(AFLAGS_G) $(AFLAGS_D) $<, $@;
!ELSE
        $(ASM) $(AFLAGS_G) $(AFLAGS_R) $<, $@;
!ENDIF


run: $(PROJ).dll
        

debug: $(PROJ).dll
        
