// vogondoc.h : interface of the CVogonDoc class
//
/////////////////////////////////////////////////////////////////////////////

class CVogonDoc : public COleDocument
{
protected: // create from serialization only
   CVogonDoc();
   DECLARE_DYNCREATE(CVogonDoc)

// Attributes
public:
// Operations
public:
   long GetSlideInterval()      {return (long) m_uintInterval;};

   CString GetFirstSlideName()  
       {m_indexOfSlide = 0; return m_stringSlides.GetSize() ? m_stringSlides[0] : _T("");};
   CString GetNextSlideName()
   {
      if (++m_indexOfSlide <= m_stringSlides.GetUpperBound()) 
      {  // Have an entry
         return m_stringSlides[m_indexOfSlide];
      }
      else
      {  // Reset
         m_indexOfSlide = 0;
         return (m_doLoop && m_stringSlides.GetSize()) ? m_stringSlides[0] : _T("");
      }
   };

// Implementation
public:
   virtual ~CVogonDoc();
   virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif
   /////////////////////////////////////////////////////////////////////////////
   //
   // Webster Events end up here
   //
   void eventDoClickURL(BSTR* SelectedURL, SHORT* Cancel);
   void eventKeyDown(short* KeyCode, short Shift);
   //
   /////////////////////////////////////////////////////////////////////////////

protected:
   virtual BOOL OnNewDocument();
	virtual BOOL SaveModified();

protected:
   // Slide show data
   int          m_indexOfSlide;

	WORD         m_uintInterval;
	WORD         m_doLoop;
   CStringArray m_stringSlides;

   // URL filter active flag
   BOOL         m_filterURL;

// Generated message map functions
protected:
   //{{AFX_MSG(CVogonDoc)
	afx_msg void OnSlideShowSetup();
	afx_msg void OnUrlFilter();
	afx_msg void OnUpdateUrlFilter(CCmdUI* pCmdUI);
	//}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
