// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
#include "ccount.h"

//////////////////////////////////////////////////////////////////////
//
// Implementation of the CCount Class
//

void CCount::inc()
{
	m_count++ ;
}

void CCount::special()
{
	m_count += 10 ;
}


//////////////////////////////////////////////////////////////////////
//
// Implementation of the CCountWithStatic Class
//

// Static data member
int CCountWithStatic::numInstances ;

//
// Constructor
//
CCountWithStatic::CCountWithStatic() : CCount() 
{
	numInstances++;
}

//
// Destructor
//
CCountWithStatic::~CCountWithStatic()
{
	numInstances--;
}

//
// Static Member functions 
//		--- Do not inline functions which access static data member!
//
int CCountWithStatic::getNumInstances()
{
	return numInstances;
}
