#ifndef __CCOUNT__
#define __CCOUNT__
#include "common.h"

//////////////////////////////////////////////////////////////////////
//
// Definition of the CCount Class
//

class EXPORT CCount {
	public:
		CCount() : m_count(0) {} ;	//Inline Constructor
		
		void inc() ;						// Increment counter			
		int get() {return m_count;};	// Retrieve current value of counter
		virtual void special();			// A Virtual function
			
	protected:
		int m_count ;					// Holds counter value		
};



//////////////////////////////////////////////////////////////////////////
//
// Definition of the CCountWithStatic Class:
//	This class keeps a count of the number of instances of the class.
// It does this through the use of a static member variable.
//

class EXPORT CCountWithStatic : public CCount{
	public:
		CCountWithStatic();			
		~CCountWithStatic();
		
		//Static function
		static int getNumInstances();		// Retrieve the number of instances
		
	private:
		static int numInstances ;	// Holds number of CCounter object instances
};

#endif //__CCOUNT__



