// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
#include <afxwin.h>
#include "ccounted.h"

/////////////////////////////////////////////////////////////
//
// Implementation of the CCounted Class 
//

//
// Constructor
//
CCounted::CCounted() : CCount()
{
	TRACE("----> Constructing CCounted Object(%Fp).\n",this) ;
}

//
// Destructor
//
CCounted::~CCounted()
{
	TRACE("----< Destroying CCounted Object(%Fp) with count of %d.\n",
		this,m_count) ;
}

//
// Member Function
//
void CCounted::inc()
{
	CCount::inc() ;
	TRACE("\tIncrementing CCounted Object(%Fp) with new count of %d.\n",
		this, m_count) ;
}

//
// special() is a virtual member function.  It shows that virtual functions
// work across DLL boundaries.
void CCounted::special()
{
	m_count += 1000 ;
	TRACE("\tIncrementing CCounted Object(%Fp) by 1000. New value %d.\n",
				this, m_count) ;
}

/////////////////////////////////////////////////////////////////////////////
// Library init

class CCountedDLL : public CWinApp
{
public:
    virtual BOOL InitInstance();
    virtual int ExitInstance();

    // nothing special for the constructor
    CCountedDLL(const char* pszAppName)
        : CWinApp(pszAppName)
        { }
};

BOOL CCountedDLL::InitInstance()
{
    // any DLL initialization goes here
    TRACE("CCounted.DLL initializing\n");
    return TRUE;
}


BOOL CCountedDLL::ExitInstance()
{
    TRACE("CCounted.DLL exiting\n");
    return 0; // Return exit code
}

CCountedDLL  countedDLL("CCounted.dll");

//////////////////////////////////////////////
// Prototypes for _WEP
//
extern "C" int CALLBACK _WEP(int nExitType);


//////////////////////////////////////////////
// _WEP function
//
//
#pragma alloc_text(WEP_TEXT, _WEP) 

extern "C" int CALLBACK _WEP(int nExitType)
{
	TRACE("Calling _WEP\r\n") ;
	AfxWinTerm() ;
	return nExitType ;
}



