// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//
#include <afxwin.h>
#include "ccount.h"
#include "ccounted.h"

class CDecCounted : public CCounted {
	public:
		// Constructor
		CDecCounted() :CCounted() 
			{TRACE("--->> Constructing CDecCounted Object(%Fp).\n",this) ;};
		
		// Destructor
		~CDecCounted()
			{TRACE("---<< Destroying CDecCounted Object(%Fp) with count of %d.\n",
				this,m_count) ; };
			
		// Decrementing member function	
		void dec() ;
};

void CDecCounted::dec()
{
	m_count--; 
	TRACE("\tDecrementing CCounted Object(%Fp) with new count of %d.\n",
	this, m_count) ;
}

//////////////////////////////////////////////////////
//
// Define a window class derived from CFrameWnd
//
class CMainWindow : public CFrameWnd
{ 
public:
	CMainWindow() 
		{ Create(NULL, "ClsExp: Look at the debug output!", 
					WS_OVERLAPPEDWINDOW, rectDefault);
				
		  TRACE("------------------------------------------------\n");
		  //
		  // The CCount Object is defined in a DLL
		  //	 
		  CCount count;
		  count.inc();
		  count.inc();
		  TRACE("\tcount(2) = %d\n",count.get());
		  
		  //
		  // CCountWithStatic descends from CCount and is defined in a DLL
		  // It has static member functions and static data.
		  //
		  TRACE("\tNumber of CCountWithStatic Objects(0) = %d\n",
					 CCountWithStatic::getNumInstances());
				 
		 CCountWithStatic withstatic1;
		 withstatic1.inc();
		 {
			 CCountWithStatic withstatic2;
			 withstatic2.inc();
 			 withstatic2.inc();
			 TRACE("\tNumber of CCountWithStatic Objects(2) = %d\n",
					 CCountWithStatic::getNumInstances());			 
			 TRACE("\twithstatic1 (1) = %d\n",withstatic1.get());
			 TRACE("\twithstatic2 (2) = %d\n",withstatic2.get());
			 
		 }
		 TRACE("\tNumber of CCountWithStatic Objects(1) = %d\n",
					 CCountWithStatic::getNumInstances());			 		 

      //
		// CCounted is defined in a DLL and descends from CCount which
		// is defined in another DLL.  CCounted uses MFC macros for 
		// tracing.
		//
		CCounted counted;
		counted.inc() ;
		counted.inc() ;
		TRACE("\tCount of counted (2) = %d\n",counted.get());
		
		//
		// CDecCount descends from the CCount which is in a DLL
		//
		CDecCounted decCount;		
		decCount.inc(); decCount.inc() ;
		decCount.dec(); decCount.dec() ;

		//
		// Demonstration of the virtual functions working across DLL boundary
		//
		CCount * ptrToCount ;
		ptrToCount = &count;
		ptrToCount->special() ;
		TRACE("\tcount after virtual call to special() is %d\n",ptrToCount->get());
		
		ptrToCount = &counted;
		ptrToCount->special() ;
		TRACE("------------------------------------------------\n");
		}

};

// Define an application class derived from CWinApp
class CClsExpApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

// Construct the CClsExpApp's m_pMainWnd data member
BOOL CClsExpApp::InitInstance()
{
	m_pMainWnd = new CMainWindow();
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}

CClsExpApp ClsExpApp;  // ClsExpApp's constructor initializes and runs the app
