/*
 * COMMDLG.C
 *
 * Routines to interface to the COMMDLG library for File Open and
 * File Save/Save As functions.
 *
 */
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.



#include <windows.h>
#include <commdlg.h>
#include "schmoo.h"



/*
 * FSaveOpenDialog
 *
 * Purpose:
 *  Invokes the COMMDLG.DLL GetOpenFileName dialog and retrieves
 *  a filename for saving or opening.
 *
 * Parameters:
 *  hWnd            HWND of the owning application.
 *  hInst           HANDLE of the application instance.
 *  pszExt          LPSTR of the default extension
 *  pszFilter       LPSTR of the filter desciption.
 *  pszFile         LPSTR buffer to receive the entered filename.
 *                  Must be at least CCHPATHMAX long.
 *  fOpen           BOOL indicating if we want file open or save.
 *
 * Return Value:
 *  BOOL            TRUE if the function retrieved a filename,
 *                  FALSE if the user pressed CANCEL.
 */

BOOL FAR PASCAL FSaveOpenDialog(HWND hWnd, HANDLE hInst,
                                LPSTR pszExt, LPSTR pszFilter,
                                LPSTR pszFile, LPSTR pszCaption,
                                BOOL fOpen)
    {
    OPENFILENAME    ofn;
    char            szTitle[CCHFILENAMEMAX];
    char            szFilter[80];
    WORD            cch1;
    WORD            cch2;


    ofn.lStructSize      =sizeof(OPENFILENAME);
    ofn.hwndOwner        =hWnd;
    ofn.hInstance        =hInst;

    ofn.lpstrFilter      =szFilter;
    ofn.lpstrCustomFilter=NULL;
    ofn.nMaxCustFilter   =0L;
    ofn.nFilterIndex     =1L;                //We only have 1 extension.

    ofn.lpstrFile        =pszFile;
    ofn.nMaxFile         =CCHPATHMAX;
    ofn.lpstrFileTitle   =(LPSTR)szTitle;
    ofn.nMaxFileTitle    =CCHFILENAMEMAX;

    ofn.lpstrInitialDir  =NULL;
    ofn.lpstrTitle       =pszCaption;

    ofn.Flags            =OFN_HIDEREADONLY;
    ofn.nFileOffset      =0;
    ofn.nFileExtension   =0;
    ofn.lpstrDefExt      =pszExt;
    ofn.lCustData        =NULL;
    ofn.lpfnHook         =NULL;
    ofn.lpTemplateName   =NULL;


    //Modify the flags as appropriate.
    if (fOpen)
        ofn.Flags        |= OFN_FILEMUSTEXIST;
    else
        ofn.Flags        |= OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT;


    //Build a filter like "pszFilter\0*.pszExt\0\0"
    lstrcpy(szFilter, pszFilter);
    cch1=1+lstrlen(szFilter);

    cch2=wsprintf(pszFile, "*.%s", pszExt);  //Initial edit control contents.
    lstrcpy(szFilter+cch1, pszFile);         //Append to filter.

    //Add the second null-terminator.
    *(szFilter+cch1+cch2+1)=0;

    return GetOpenFileName(&ofn);
    }
