/*
 * EXIT.C
 *
 * Functions for final cleanup of the SCHMOO application.  Calls any
 * OLE specific functions.
 *
 */
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.


#include <windows.h>
#include <ole.h>
#include "schmoo.h"
#include "oleglobl.h"


/*
 * FApplicationExit
 *
 * Purpose:
 *  Provides final cleanup of any objects and other actions that
 *  must occur at closing time.
 *
 * Parameters:
 *  pGlob           LPGLOBALS to global variable block.
 *
 * Return Value:
 *  BOOL            TRUE if everything succeeds, FALSE otherwise.
 */

BOOL FAR PASCAL FApplicationExit(LPGLOBALS pGlob)
    {
    BOOL        fRet=TRUE;

    //Free the stringtable.
    if (NULL!=pGlob->hStringMem)
        LocalFree(pGlob->hStringMem);

#ifdef MAKEOLESERVER

    fRet=FOLEExit(pOLE);

#endif //MAKEOLESERVER

    return fRet;
    }
