/*
 * FILEIO.C
 *
 * Functions for low-level reading and writing of .MOO files.
 *
 * Functions:
 *  FMooFileRead, FMooFileWrite
 *
 */
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.

#include <windows.h>
#include "schmoo.h"


/*
 * FMooFileRead
 *
 * Purpose:
 *  Reads a Moo file into the POLYLINE structure pointed to by lppl.
 *  Clears pGlob->fDirty on success.
 *
 * Parameters:
 *  pGlob           LPGLOBALS to the global variable block.
 *  pszFile         LPSTR of the filename to read.
 *  lppl            LPPOLYLINE to the structure to fill.
 *
 * Return Value:
 *  BOOL            TRUE if the file was successfully read,
 *                  FALSE otherwise.
 */

BOOL FAR PASCAL FMooFileRead(LPGLOBALS pGlob, LPSTR pszFile, LPPOLYLINE lppl)
    {
    HANDLE      hFile;
    OFSTRUCT    of;
    WORD        cb;

    hFile=OpenFile(pszFile, &of, OF_READ);

    if (-1==hFile)
        return FALSE;

    cb=_lread(hFile, (LPSTR)lppl, CBPOLYLINE);
    _lclose(hFile);

    if (CBPOLYLINE==cb)
        {
        pGlob->fDirty=FALSE;
        return TRUE;
        }

    return FALSE;
    }




/*
 * FMooFileWrite
 *
 * Purpose:
 *  Writes a Moo file into the POLYLINE structure pointed to by lppl.
 *  Clears pGlob->fDirty.
 *
 * Parameters:
 *  pGlob           LPGLOBALS to the global variable block.
 *  pszFile         LPSTR of the filename to read.
 *  lppl            LPPOLYLINE to the structure to write from.
 *
 * Return Value:
 *  BOOL            TRUE if the file was successfully written,
 *                  FALSE otherwise.
 */

BOOL FAR PASCAL FMooFileWrite(LPGLOBALS pGlob, LPSTR pszFile, LPPOLYLINE lppl)
    {
    HANDLE      hFile;
    OFSTRUCT    of;
    WORD        cb;

    hFile=OpenFile(pszFile, &of, OF_CREATE | OF_WRITE);

    if (-1==hFile)
        return FALSE;

    cb=_lwrite(hFile, (LPSTR)lppl, CBPOLYLINE);
    _lclose(hFile);

    if (CBPOLYLINE==cb)
        {
        pGlob->fDirty=FALSE;
        return TRUE;
        }

    return FALSE;
    }
