/*
 * OLEEXIT.C
 *
 * Functions for final OLE cleanup.
 *
 */
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.


#ifdef MAKEOLESERVER

#include <windows.h>
#include <ole.h>
#include "schmoo.h"
#include "oleglobl.h"


/*
 * FOLEExit
 *
 * Purpose:
 *  Handles OLE-server specific shutdown
 *    1.  Free the OLESERVER structure.
 *    2.  Free the procedure instances the server's VTBLs.
 *
 * Parameters:
 *  pOLE            LPXOLEGLOBALS to OLE-specific global variable block.
 *
 * Return Value:
 *  BOOL            FALSE if an error occurred, otherwise TRUE.
 */

BOOL FAR PASCAL FOLEExit(LPXOLEGLOBALS pOLE)
    {
    /*
     * Dump the server.  We depend on ServerRelease and DocRelease to
     * clean up documents and objects.  Choosing File/Exit has already
     * revoked the server.  This is simply final cleanup.
     */
    LocalFree(pOLE->pSvr->hMem);

    OLEVtblFreeServer  (&pOLE->vtblSvr);
    OLEVtblFreeDocument(&pOLE->vtblDoc);
    OLEVtblFreeObject  (&pOLE->vtblObj);

    return TRUE;
    }


#endif //MAKEOLESERVER
