/*
 * OLEVTBL.C
 *
 * Creates or frees the procedure instances for the server, document,
 * and object VTBLs.  There are two functions for each table:  one
 * to initialize the table, the other to free the instances in the table.
 *
 */
// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.




#ifdef MAKEOLESERVER


#include <windows.h>
#include <ole.h>
#include "schmoo.h"
#include "oleglobl.h"

#ifdef MSC700
#pragma warning(disable:4113)
#endif


/*
 * FOLEVtblInitServer
 *
 * Purpose:
 *  Creates procedure instances for all the OLE methods required
 *  by the server library for standard server methods.
 *
 * Parameters:
 *  hInst           HANDLE of the application instance.
 *  pvt             LPOLESERVERVTBL to the VTBL to initialize.
 *
 * Return Value:
 *  None
 *
 * Customization:
 *  None required.
 */

BOOL FAR PASCAL FOLEVtblInitServer(HANDLE hInst, LPOLESERVERVTBL pvt)
    {
    BOOL        fRet;

    pvt->Create 	   =(LPVOID)MakeProcInstance(ServerCreate,	       hInst);
    pvt->CreateFromTemplate=(LPVOID)MakeProcInstance(ServerCreateFromTemplate, hInst);
    pvt->Edit		   =(LPVOID)MakeProcInstance(ServerEdit,	       hInst);
    pvt->Execute	   =(LPVOID)MakeProcInstance(ServerExecute,	       hInst);
    pvt->Exit		   =(LPVOID)MakeProcInstance(ServerExit,	       hInst);
    pvt->Open		   =(LPVOID)MakeProcInstance(ServerOpen,	       hInst);
    pvt->Release	   =(LPVOID)MakeProcInstance(ServerRelease,	       hInst);

    fRet =(NULL!=pvt->Create);
    fRet&=(NULL!=pvt->CreateFromTemplate);
    fRet&=(NULL!=pvt->Edit);
    fRet&=(NULL!=pvt->Execute);
    fRet&=(NULL!=pvt->Exit);
    fRet&=(NULL!=pvt->Open);
    fRet&=(NULL!=pvt->Release);

    return fRet;
    }


/*
 * OLEVtblFreeServer
 *
 * Purpose:
 *  Frees all procedure instances in the server VTBL.
 *
 * Parameters:
 *  pvt             LPOLESERVERVTBL to the VTBL to free.
 *
 * Return Value:
 *  none
 *
 * Customization:
 *  None required.
 */

void FAR PASCAL OLEVtblFreeServer(LPOLESERVERVTBL pvt)
    {
    FreeProcInstance(pvt->Create);
    FreeProcInstance(pvt->CreateFromTemplate);
    FreeProcInstance(pvt->Edit);
    FreeProcInstance(pvt->Exit);
    FreeProcInstance(pvt->Open);
    FreeProcInstance(pvt->Release);

    return;
    }





/*
 * FOLEVtblInitDocument
 *
 * Purpose:
 *  Creates procedure instances for all the OLE methods required
 *  for document methods.
 *
 * Parameters:
 *  hInst           HANDLE of the application instance.
 *  pvt             LPOLESERVERDOCVTBL to the VTBL to initialize.
 * 
 * Return Value:
 *  None
 *
 * Customization:
 *  None required.
 */

BOOL FAR PASCAL FOLEVtblInitDocument(HANDLE hInst, LPOLESERVERDOCVTBL pvt)
    {
    BOOL        fRet;

    pvt->Close		 =(LPVOID)MakeProcInstance(DocClose,		hInst);
    pvt->GetObject	 =(LPVOID)MakeProcInstance(DocGetObject,	hInst);
    pvt->Execute	 =(LPVOID)MakeProcInstance(DocExecute,		hInst);
    pvt->Release	 =(LPVOID)MakeProcInstance(DocRelease,		hInst);
    pvt->Save		 =(LPVOID)MakeProcInstance(DocSave,		hInst);
    pvt->SetColorScheme  =(LPVOID)MakeProcInstance(DocSetColorScheme,	hInst);
    pvt->SetDocDimensions=(LPVOID)MakeProcInstance(DocSetDocDimensions, hInst);
    pvt->SetHostNames	 =(LPVOID)MakeProcInstance(DocSetHostNames,	hInst);

    fRet =(NULL!=pvt->Close);
    fRet&=(NULL!=pvt->GetObject);
    fRet&=(NULL!=pvt->Execute);
    fRet&=(NULL!=pvt->Release);
    fRet&=(NULL!=pvt->Save);
    fRet&=(NULL!=pvt->SetColorScheme);
    fRet&=(NULL!=pvt->SetDocDimensions);
    fRet&=(NULL!=pvt->SetHostNames);

    return fRet;
    }




/*
 * OLEVtblFreeDocument
 *
 * Purpose:
 *  Frees all procedure instances in the document VTBL.
 *
 * Parameters:
 *  pvt             LPOLESERVERDOCVTBL to the VTBL to free.
 *
 * Return Value:
 *  none
 *
 * Customization:
 *  None required.
 */

void FAR PASCAL OLEVtblFreeDocument(LPOLESERVERDOCVTBL pvt)
    {
    FreeProcInstance(pvt->Close);
    FreeProcInstance(pvt->GetObject);
    FreeProcInstance(pvt->Release);
    FreeProcInstance(pvt->Save);
    FreeProcInstance(pvt->SetColorScheme);
    FreeProcInstance(pvt->SetDocDimensions);
    FreeProcInstance(pvt->SetHostNames);

    return;
    }





/*
 * FOLEVtblInitObject
 *
 * Purpose:
 *  Creates procedure instances for all the OLE methods required
 *  for object methods.
 *
 * Parameters:
 *  hInst           HANDLE of the application instance.
 *  pvt             LPOLEOBJECTVTBL to free.
 * 
 * Return Value:
 *  None
 *
 * Customization:
 *  Your application might not use global variables for srvrvtbl,
 *  docvtbl, and objvtbl.
 */

BOOL FAR PASCAL FOLEVtblInitObject(HANDLE hInst, LPOLEOBJECTVTBL pvt)
    {
    BOOL        fRet;
    FARPROC     lpfn;
    LPVOIDPROC  lpvp;

    /*
     * Local variables are used here just to make this one assignment
     * more readable since it requires some typecasting to compile clean
     * at warning level 3.
     */
    lpfn=(FARPROC)ObjQueryProtocol;
    lpvp=(LPVOIDPROC)MakeProcInstance(lpfn, hInst);

    pvt->QueryProtocol  = lpvp;
    pvt->DoVerb 	=(LPVOID)MakeProcInstance(ObjDoVerb, hInst);
    pvt->EnumFormats	=(LPVOID)MakeProcInstance(ObjEnumFormats,   hInst);
    pvt->GetData	=(LPVOID)MakeProcInstance(ObjGetData,	    hInst);
    pvt->Release	=(LPVOID)MakeProcInstance(ObjRelease,	    hInst);
    pvt->SetBounds	=(LPVOID)MakeProcInstance(ObjSetBounds,      hInst);
    pvt->SetColorScheme =(LPVOID)MakeProcInstance(ObjSetColorScheme,   hInst);
    pvt->SetData	=(LPVOID)MakeProcInstance(ObjSetData,	      hInst);
    pvt->SetTargetDevice=(LPVOID)MakeProcInstance(ObjSetTargetDevice,  hInst);
    pvt->Show		=(LPVOID)MakeProcInstance(ObjShow,	 hInst);



    fRet =(NULL!=pvt->QueryProtocol);
    fRet&=(NULL!=pvt->DoVerb);
    fRet&=(NULL!=pvt->EnumFormats);
    fRet&=(NULL!=pvt->GetData);
    fRet&=(NULL!=pvt->Release);
    fRet&=(NULL!=pvt->SetBounds);
    fRet =(NULL!=pvt->SetColorScheme);
    fRet&=(NULL!=pvt->SetData);
    fRet&=(NULL!=pvt->SetTargetDevice);
    fRet&=(NULL!=pvt->Show);

    return fRet;
    }





/*
 * OLEVtblFreeObject
 *
 * Purpose:
 *  Frees all procedure instances in the object VTBL.
 *
 * Parameters:
 *  pvt             LPOLEOBJECTVTBL to the VTBL to free.
 *
 * Return Value:
 *  none
 *
 * Customization:
 *  None required.
 */

void FAR PASCAL OLEVtblFreeObject(LPOLEOBJECTVTBL pvt)
    {
    FreeProcInstance(pvt->DoVerb);
    FreeProcInstance(pvt->EnumFormats);
    FreeProcInstance(pvt->GetData);
    FreeProcInstance((FARPROC)pvt->QueryProtocol);
    FreeProcInstance(pvt->Release);
    FreeProcInstance(pvt->SetBounds);
    FreeProcInstance(pvt->SetColorScheme);
    FreeProcInstance(pvt->SetData);
    FreeProcInstance(pvt->SetTargetDevice);
    FreeProcInstance(pvt->Show);

    return;
    }



#endif //MAKEOLESERVER
