PROGRAM FSP;
USES Crt, Dos;                       {Crt for colors, Dos for DiskSize/Free.}
CONST
   ProgData = 'FSP- Free DOS Multiple Hard Disk Space Utilization Utility.';
   ProgDat2 = ' V1.00: July 14, 1993.  (c) 1993 by David Daniel Anderson. ';
   ProgDat3 = 'DRIVE       ALLOCATED    FREE SPACE    TOTAL SPACE   FREE %';
VAR
   DriveCounter      : Byte;

   TS,TF,TU : LongInt;  {integer of Total space Size/Free/Used}
                        {maximum disk size of LongInt: 2 147 483 647 }


FUNCTION Comma(i : LongInt) : String; {Used in WriteDriveInfo & WriteTotalInfo}
VAR w : String[14];                  {Insert commas to break up number string.}
    c : ShortInt;
BEGIN
    Str(i,w);

    c := (Length(w) - 3);
    WHILE c > 0 DO
    BEGIN
      Insert(',',w,c+1);
      c := c - 3
    END;

    Comma := w;
END;

FUNCTION LeadingZero(w : Word) : String;  {Called by WriteDTInf to write time.}
VAR  s : String;
BEGIN
     Str(w:0,s);
     IF Length(s) = 1 THEN
       s := '0' + s;
     LeadingZero := s;
END;

PROCEDURE WriteDTInf;            {Called by WriteHeader to write Date & Time.}
CONST
  Mon : Array [1..12] of String[9] =
        ('January','February','March','April','May','June','July',
         'August','September','October','November','December');
VAR
     Year,Month,Day, dow,
     Hour,Min,Sec, hund    : Word;
     i                     : ShortInt;
     DStr,
     YStr,
     DateStr               : String[20];
BEGIN
     GetDate(Year,Month,Day,dow);
     GetTime(Hour,Min,Sec,hund);
     Str(Day,DStr);
     Str(Year,YStr);
     DateStr := Mon[Month] + ' ' + DStr + ', ' + YStr;
     Write(DateStr);
     FOR i := Length(DateStr) to 50 DO         {Fill the line with spaces.}
         Write(' ');
     WriteLn(LeadingZero(Hour),':',
             LeadingZero(Min),':',
             LeadingZero(Sec));
END;

PROCEDURE WriteHeader;                 {Called by main.}
VAR  i : ShortInt;
BEGIN
     TextBackGround(Blue);  TextColor(White);
     WriteLn(ProgData);                                   {...a constant...}
     WriteLn(ProgDat2);                                   {...a constant...}
     TextBackGround(Black); TextColor(LightBlue);
     WriteDTInf;
     TextColor(LightCyan);
     WriteLn(ProgDat3);                                   {...a constant...}
     FOR i := 1 to 59 DO                         {Draw a line of hyphens.}
         Write('-');
     WriteLn;
END;

PROCEDURE WritePercent(TFree,TSpace : LongInt);   {Called by WriteDriveInfo  }
                                                  {        & WriteTotalInfo. }
VAR  SPF : String[8];          {String of Percentage Free}
     PF  : Integer;       {integer of Percentage Free, initially 10 x %}
BEGIN
     PF := Round(1000 * (TFree / TSpace));    {Using 1000 to give tenths of %}
     Str(PF,SPF);
     Insert('.',SPF,(Length(SPF)));   {Insert period for tenths of a percent.}
     TextColor(White);         WriteLn(SPF:8,'%');
END;

PROCEDURE WriteInColor(u,f,s : LongInt);
BEGIN
     TextColor(LightRed);      Write(Comma(U):14);
     TextColor(LightGreen);    Write(Comma(F):14);
     TextColor(Magenta);       Write(Comma(S):15);
END;

PROCEDURE WriteDriveInfo;                   {Called by main.}
VAR  DS,DF,DU : LongInt;        {integer of Disk space Size/Free/Used}
BEGIN
     DS := DiskSize(DriveCounter);
     DF := DiskFree(DriveCounter);
     DU := DS - DF;
     TS := TS + DS;    TF := TF + DF;    TU := TU + DU;

     TextColor(Yellow);        Write(Chr(DriveCounter+64),' -->  ');
     WriteInColor(DU,DF,DS);
     WritePercent(DF,DS);                          {...a procedure...}

     DriveCounter := Succ(DriveCounter);
END;

PROCEDURE WriteTotalInfo;                          {Called by main.}
VAR  i : ShortInt;
BEGIN
     TextColor(LightGray);
     FOR i := 1 to 59 DO                         {Draw a line of equals.}
         Write('=');
         WriteLn;

     TextColor(Yellow);        Write('TOTALS=');
     WriteInColor(TU,TF,TS);
     WritePercent(TF,TS);                          {...a procedure...}
END;


BEGIN
     TS := 0;  TF := 0;  TU := 0;
     DriveCounter := 3;
     IF ParamStr(1) = '' THEN ClrScr;{Clear screen unless ANY parameter given.}

     WriteHeader;                           {...a procedure...}

     WHILE (( DiskFree(DriveCounter) ) <> -1) DO
          WriteDriveInfo;                   {...a procedure...}

     WriteTotalInfo;                        {...a procedure...}
     NormVideo;
END.
