DEFINT A-Z

'Declare Routines

'Checks DataFile
DECLARE SUB HolidayCheck ()

'Needed to check for New DataFile
DECLARE FUNCTION NewCheck (File$)

'Routine to perform the daily batch file (if it is a different day)
DECLARE SUB DayCheck ()

'Routine to perform the weekly batch file if days since the last run
'is > 6, or if DayOfWeek = 0 (Sunday)
DECLARE SUB WeekCheck ()

'Routine to perform the monthly batch file.
DECLARE SUB MonthCheck ()

'Routine to perform the yearly batch file.
DECLARE SUB YearCheck ()

'Routine to perform the user batch file.
DECLARE SUB UserCheck ()

'Support for the User Batch Routine.
DECLARE SUB UserDaysRead ()
DECLARE SUB ConfigUserRec ()
DECLARE SUB WriteUser (User%, Accum%)

'Routine to define the Monthdays%(12) array, which contains all the
'days of the month, in the order of the months. (Makes it easier on
'calculations)
DECLARE SUB DefMonthDays ()

'Routine to Write dat$ (a date in the form "MM-DD-YYYY") in the first 2 bytes
'of the record file
DECLARE SUB WriteDate (Dat$, File$, Locat)

'Routine that handles the init process
DECLARE SUB InitDateCheck ()

'If running under NDOS, this routine interfaces with NDOS to describe the
'DateCheck files
DECLARE SUB Describe (Fle$, des$)

'Determines whether or not a file exists.  0 for No, -1 for Yes
DECLARE FUNCTION Exist% (File$)

'Determines the name of the file currently in place as the Command Processer
DECLARE FUNCTION Intrptr$ ()

'Returns the Raw String of a number (a string w/o any spaces
'leading or trailing.)
DECLARE FUNCTION Rstr$ (Num AS ANY)

'Returns the Day of the week 0-6 (Sunday-Saturday respectively)
'NOTE:if stripped from this program, it requires the Days% function to be
'with it.
DECLARE FUNCTION DayOfWeek% (Mo%, Da%, Yr%)

'Returns the number of days from M1%/D1%/Y1% to M2%/D2%/Y2%
'NOTE: if there is a problem with either date, this routine creates Error
'#77
DECLARE FUNCTION Days% (M1%, D1%, Y1%, M2%, D2%, Y2%)

'Changes a Binary string bin$ to an integer
DECLARE FUNCTION Bin2Num% (Bin$)

'Changes a number nm to a Binary string
'NOTE:Requires the Logx! function
DECLARE FUNCTION Num2Bin$ (Nm%)

'Fixes a Binary string to fx% places
DECLARE FUNCTION FixBin$ (Bin$, Fx%)

'Returns the Log of a num with base bas
DECLARE FUNCTION Logx! (Bas AS ANY, Num AS ANY)

'Translates a 2-byte Date string back to "MM-DD-YYYY" format
DECLARE FUNCTION TranslateDate$ (DateString$)

'Declare Constants
'Program Conditions
CONST False = 0, True = NOT False, ErrorCondition = 0

'Program Qualities  NOTE: These usually CHANGE from version to version.
CONST Version = 4

'Filename and Description constants
CONST PrShellForDescrip = "NDOS.COM"
CONST OldDataFile = "DATECHK.REC"
CONST DataFile = "DATECHK.DAT", ProgramName = "DATECHK.EXE"
CONST DRFDes = "Data file"
CONST PFDes = "Daily, Weekly and Monthly Maint. Manager"
CONST DailyBatch = "DAILY.BAT", DailyDes = "Daily Maintenance"
CONST WeeklyBatch = "WEEKLY.BAT", WeeklyDes = "Weekly Maintenance"
CONST MonthlyBatch = "MONTHLY.BAT", MonthlyDes = "Monthly Maintenance"
CONST UserBatch = "USER.BAT", UserDes = "User Maintenance"
CONST YearlyBatch = "YEARLY.BAT", YearlyDes = "Yearly Maintenance"

'Command Line Options
CONST CheckOption = "/CHECK"
CONST AutoOption = "/AUTO"
CONST ConfigOption = "/CONFIG"

'Type Definitions
TYPE HolRec
   Date AS STRING * 2
   Text AS STRING * 60
END TYPE

'Declare Arrays and Shared Variables
DIM SHARED Byte(3) AS STRING * 1, RWByte AS STRING * 1, Record AS HolRec
DIM SHARED Monthdays%(12), Flag%(4), Dates$(2), UserDays, UserAccum
DIM SHARED StoreDate AS STRING * 2

'Define Monthdays% array
DefMonthDays

'Determine whether or not Describe may be used
IF Intrptr$ = PrShellForDescrip THEN Flag%(1) = True

'Determine whether or not the user wants to be prompted
IF COMMAND$ = AutoOption THEN Flag%(4) = True

Flag%(3) = False
Dates$(1) = DATE$
InitDateCheck
UserDaysRead

IF COMMAND$ = ConfigOption THEN
   ConfigUserRec
   END
END IF

'Check for whether or not the batch files are due to be run
IF Dates$(1) <> Dates$(2) OR MID$(COMMAND$, 1, 6) = CheckOption THEN
   CALL WriteDate(Dates$(1), DataFile, 1)
   DayCheck
   WeekCheck
   MonthCheck
   YearCheck
   UserCheck
   HolidayCheck
END IF
CLOSE
END


'Error Routines
testex:
   Flag%(2) = True
RESUME NEXT

DaysError:
   PRINT "An Error with the Days Routine has been evoked...  Please make a copy"
   PRINT "of "; DataFile; " and mail it to Brian Fields, as described in the"
   PRINT "Documentation.  Also, please try to describe the conditions in which"
   PRINT "the error occured.  Thank You!"
   END
RESUME NEXT

FUNCTION Bin2Num% (Bin$)
   BinNum = 0
   FOR X = LEN(Bin$) TO 1 STEP -1
      BinNum = BinNum + (VAL(MID$(Bin$, X, 1)) * (2 ^ (LEN(Bin$) - X)))
   NEXT
   Bin2Num% = BinNum
END FUNCTION

SUB ConfigUserRec
INPUT "Enter the number of days to check for the USER.BAT intervention [0]:", User
IF User = 0 THEN
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   RWByte = CHR$(0)
   FOR X = 3 TO 5
      PUT #1, X, RWByte
   NEXT
   EXIT SUB
   CLOSE Fil%
ELSE
   CALL WriteUser(User, 0)
END IF
END SUB

SUB DayCheck
   IF Flag%(4) = False THEN
      PRINT "Daily Maintenance is due... Execute " + DailyBatch + "? (Y/n)"
      Choi$ = INPUT$(1)
   END IF
   IF UCASE$(Choi$) <> "N" THEN
      PRINT "Performing Daily Maintenance..."
      IF NOT Exist%(DailyBatch) THEN
         PRINT "No " + DailyBatch + "... Skipping..."
      ELSE
         IF Flag%(1) = True THEN
            Describe DailyBatch, DailyDes
         END IF
         SHELL DailyBatch
      END IF
   ELSE
      PRINT "Skipping " + DailyBatch + "..."
   END IF
END SUB

FUNCTION DayOfWeek% (Mo%, Da%, Yr%) STATIC
   IF Yr% < 1980 OR Yr% > 2099 THEN
      DayOfWeek% = ErrorCondition
      EXIT FUNCTION
   END IF
   DayOfWeek% = ((Days%(1, 1, 1980, Mo%, Da%, Yr%) + 2) MOD 7)
END FUNCTION

FUNCTION Days% (M1%, D1%, Y1%, M2%, D2%, Y2%)
   ON ERROR GOTO DaysError:
   IF Y2% < Y1% OR ((Y2% = Y1%) AND (M2% < M1%)) OR ((Y2% = Y1%) AND (M2% = M1%) AND (D2% < D1%)) OR ((D1% > Monthdays%(M1%)) OR (D2% > Monthdays(M2%))) THEN
      ERROR 77
   ELSEIF (D1% > Monthdays(M1%) AND M1% <> 2 AND D1% <> 29 AND Y1% / 4 <> INT(Y1% / 4)) OR Y1% < 1980 OR Y1% > 2099 OR M1% > 12 OR M1% < 1 OR D1% < 1 THEN
      ERROR 77
   ELSEIF (D2% > Monthdays(M2%) AND M2% <> 2 AND D2% <> 29 AND Y2% / 4 <> INT(Y2% / 4)) OR Y2% < 1980 OR Y2% > 2099 OR M2% > 12 OR M2% < 1 OR D1% < 1 THEN
      ERROR 77
   END IF
   ON ERROR GOTO 0
   DaysTemp% = 0
   DO
      IF (Y1% < Y2%) AND (M1% <= M2%) AND (D1% <= D2%) THEN
         IF M1% = 2 AND D1% = 29 THEN
            Y1% = Y1% + 1
            M1% = 3
            D1% = 1
         ELSE
            IF (((M1% < 2) OR (M1% = 2 AND D1% < 29)) AND ((Y1% / 4) = INT(Y1% / 4))) OR (((M1% >= 3) AND ((Y1% + 1) / 4) = INT((Y1% + 1) / 4))) THEN
               DaysTemp% = DaysTemp% + 366
            ELSE
               DaysTemp% = DaysTemp% + 365
            END IF
            Y1% = Y1% + 1
         END IF
      ELSE
         IF D1% = D2% AND M1% = M2% AND Y1% = Y2% THEN
            EXIT DO
         END IF
         IF D1% < Monthdays%(M1%) THEN
            D1% = D1% + 1
            DaysTemp% = DaysTemp% + 1
         ELSEIF D1% >= Monthdays%(M1%) AND M1% < 12 THEN
            D1% = 1
            M1% = M1% + 1
            DaysTemp% = DaysTemp% + 1
         ELSEIF M1% < 12 THEN
            D1% = 1
            M1% = M1% + 1
            DaysTemp% = DaysTemp% + 1
         ELSEIF M1% >= 12 AND D1% >= Monthdays%(M1%) THEN
            D1% = 1
            M1% = 1
            Y1% = Y1% + 1
            DaysTemp% = DaysTemp% + 1
         END IF
         IF M1% = 3 AND D1% = 1 AND Y1% / 4 = INT(Y1% / 4) THEN
            IF D2% = 29 AND M2% = 2 AND Y2% = Y1% THEN
               EXIT DO
            ELSEIF (D1% <> 29 AND M1% <> 2 AND (Y1% / 4 <> INT(Y1% / 4))) THEN
               DaysTemp% = DaysTemp% + 1
            END IF
         END IF
      END IF
   LOOP
   Days% = DaysTemp%
END FUNCTION

SUB DefMonthDays
   FOR X = 1 TO 12
      SELECT CASE X
         CASE 1, 3, 5, 7, 8, 10, 12
            Monthdays%(X) = 31
         CASE 4, 6, 9, 11
            Monthdays%(X) = 30
         CASE 2
            Monthdays%(X) = 28
      END SELECT
   NEXT
END SUB

SUB Describe (Fle$, DeSTR$)
   SHELL "describe " + Fle$ + " " + CHR$(34) + DeSTR$ + CHR$(34)
END SUB

FUNCTION Exist% (File$)
   ON ERROR GOTO testex:
   Handle% = FREEFILE
   OPEN File$ FOR INPUT AS Handle%
   ON ERROR GOTO 0
   IF Flag%(2) = False THEN
      Exist% = True
   ELSE
      Exist% = False
   END IF
   Flag%(2) = False
   CLOSE Handle%
END FUNCTION

FUNCTION FixBin$ (Bin$, Fx)
   IF LEN(Bin$) >= Fx THEN
      FixBin$ = RIGHT$(Bin$, Fx)
      EXIT FUNCTION
   END IF
   FOR X = 1 TO Fx - LEN(Bin$)
      Bin$ = "0" + Bin$
   NEXT
   FixBin$ = Bin$
END FUNCTION

SUB HolidayCheck STATIC
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   DO
      Numb% = Locat% * 62 + 6
      GET Fil%, Numb%, Record
      TestDate$ = TranslateDate$(Record.Date)
      IF MID$(Dates$(1), 1, 5) = MID$(TestDate$, 1, 5) THEN
         PRINT
         PRINT Record.Text
         BEEP
         PRINT "Press any key to continue"
         Dummy$ = INPUT$(1)
      END IF
      Locat% = Locat% + 1
   LOOP WHILE Numb% < LOF(Fil%)
   CLOSE Fil%
END SUB

SUB InitDateCheck
   IF Exist(OldDataFile) OR NewCheck(DataFile) THEN
      IF Exist(OldDataFile) THEN
         KILL OldDataFile
      END IF
      CALL WriteDate(Dates$(1), DataFile, 1)
      PRINT "This is either an upgrade, or a new installation of Date Check!"
      PRINT "You will be prompted to enter a Value for the number of days to"
      PRINT "wait between USER.BAT checks.  If you do not wish to use the"
      PRINT "User Check option, just enter 0.  NOTE: You can change your mind"
      PRINT "later by entering /CONFIG on the command line"
      ConfigUserRec
      Flag%(3) = True
   ELSE
      CLOSE Fil%
   END IF
   IF Flag%(1) = True THEN
      Describe DataFile, DRFDes
      Describe ProgramName, PFDes
      IF Flag%(3) = True THEN
         END
      END IF
   END IF
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   GET Fil%, 1, StoreDate
   Dates$(2) = TranslateDate$(StoreDate)
   CLOSE Fil%
END SUB

FUNCTION Intrptr$
   Interpreter$ = ENVIRON$("COMSPEC")
   FOR X = LEN(Interpreter$) TO 1 STEP -1
      Check$ = MID$(Interpreter$, X, 1)
      IF Check$ = "\" THEN EXIT FOR
      Temp$ = Check$ + Temp$
   NEXT
   Intrptr$ = UCASE$(Temp$)
END FUNCTION

FUNCTION Logx! (Bas, Num)
   Logx! = LOG(Num) / LOG(Bas)
END FUNCTION

SUB MonthCheck
   IF MID$(Dates$(1), 1, 2) <> MID$(Dates$(2), 1, 2) OR COMMAND$ = CheckOption THEN
      IF Flag%(4) = False THEN
         PRINT "Monthly Maintenance is due... Execute " + MonthlyBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing Monthly Maintenance..."
         IF NOT Exist%(MonthlyBatch) THEN
            PRINT "No " + MonthlyBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe MonthlyBatch, MonthlyDes
            END IF
            SHELL MonthlyBatch
         END IF
      ELSE
         PRINT "Skipping " + MonthlyBatch + "..."
      END IF
   END IF
END SUB

FUNCTION NewCheck (File$)
   Fi% = FREEFILE
   OPEN File$ FOR RANDOM AS Fi% LEN = 62
   GET Fi%, 1, Record
   IF Record.Date = SPACE$(2) THEN
      NewCheck = True
   ELSE
      NewCheck = False
   END IF
   CLOSE Fi%
END FUNCTION

FUNCTION Num2Bin$ (Nm)
   Bn$ = ""
   IF Nm = 0 THEN
      Num2Bin$ = "0"
      EXIT FUNCTION
   END IF
   Dgs! = Logx!(2, Nm)
   Nm = ABS(INT(Nm))
   Dgs = INT(Dgs! + 1)
   FOR X = Dgs TO 1 STEP -1
      IF Nm >= 2 ^ (X - 1) THEN
         Bn$ = Bn$ + "1"
         Nm = Nm - (2 ^ (X - 1))
      ELSE
         Bn$ = Bn$ + "0"
      END IF
   NEXT
   Num2Bin$ = Bn$
END FUNCTION

FUNCTION Rstr$ (Num)
   Num$ = STR$(Num)
   FOR Y = 1 TO LEN(Num$)
      Chec$ = MID$(Num$, Y, 1)
      IF Chec$ <> " " THEN
         NewNum$ = NewNum$ + Chec$
      END IF
   NEXT
   Rstr$ = NewNum$
END FUNCTION

FUNCTION TranslateDate$ (DateString$)
   TotASC$ = ""
   FOR X = 1 TO LEN(DateString$)
      RWByte = MID$(DateString$, X, 1)
      Nm = ASC(RWByte)
      N$ = FixBin$(Num2Bin$(Nm), 8)
      TotASC$ = TotASC$ + N$
   NEXT
   MnSTR$ = Rstr$(Bin2Num%(MID$(TotASC$, 1, 4)))
   DnSTR$ = Rstr$(Bin2Num%(MID$(TotASC$, 5, 5)))
   YrSTR$ = Rstr$(Bin2Num%(MID$(TotASC$, 10, 7)) + 1980)
   IF LEN(MnSTR$) < 2 THEN
      MnSTR$ = "0" + MnSTR$
   END IF
   IF LEN(DnSTR$) < 2 THEN
      DnSTR$ = "0" + DnSTR$
   END IF
   TranslateDate$ = MnSTR$ + "-" + DnSTR$ + "-" + YrSTR$
END FUNCTION

SUB UserCheck
   DayCount = Days%(VAL(MID$(Dates$(2), 1, 2)), VAL(MID$(Dates$(2), 4, 2)), VAL(MID$(Dates$(2), 7, 4)), VAL(MID$(Dates$(1), 1, 2)), VAL(MID$(Dates$(1), 4, 2)), VAL(MID$(Dates$(1), 7, 4)))
   IF (DayCount + UserAccum >= UserDays OR COMMAND$ = CheckOption) AND UserDays > 0 THEN
      IF Flag%(4) = False THEN
         PRINT "User Interval ("; Rstr$(UserDays); " Days) has been exceeded... Execute " + UserBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing User Maintenance..."
         IF NOT Exist%(UserBatch) THEN
            PRINT "No " + UserBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe UserBatch, UserDes
            END IF
            SHELL UserBatch
         END IF
      ELSE
         PRINT "Skipping " + UserBatch + "..."
      END IF
      CALL WriteUser(UserDays, 0)
   ELSE
      IF UserDays > 0 THEN
         CALL WriteUser(UserDays, UserAccum + DayCount)
      END IF
   END IF
END SUB

SUB UserDaysRead
   TotASC$ = ""
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   FOR X = 3 TO 5
      GET #1, X, RWByte
      Nm = ASC(RWByte)
      N$ = FixBin$(Num2Bin$(Nm), 8)
      TotASC$ = TotASC$ + N$
   NEXT
   UserDays = Bin2Num(MID$(TotASC$, 1, 9))
   UserAccum = Bin2Num(MID$(TotASC$, 10, 9))
   'Notice: Bits 19-24 are UNUSED!
   CLOSE Fil%
END SUB

SUB WeekCheck
   StartDay = VAL(MID$(Dates$(2), 4, 2))
   StartMonth = VAL(MID$(Dates$(2), 1, 2))
   StartYear = VAL(MID$(Dates$(2), 7, 4))
   EndDay = VAL(MID$(Dates$(1), 4, 2))
   EndMonth = VAL(MID$(Dates$(1), 1, 2))
   EndYear = VAL(MID$(Dates$(1), 7, 4))
   DayCount = Days%(StartMonth, StartDay, StartYear, EndMonth, EndDay, EndYear)
   StartWeekDay = DayOfWeek%(EndMonth, EndDay, EndYear)
   EndWeekDay = DayOfWeek%(StartMonth, StartDay, StartYear)
   IF EndWeekDay > StartWeekDay OR DayCount > 6 OR COMMAND$ = CheckOption THEN
      IF Flag%(4) = False THEN
         PRINT "Weekly Maintenance is due... Execute " + WeeklyBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing Weekly Maintenance..."
         IF NOT Exist%(WeeklyBatch) THEN
            PRINT "No " + WeeklyBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe WeeklyBatch, WeeklyDes
            END IF
            SHELL WeeklyBatch
         END IF
      ELSE
         PRINT "Skipping " + WeeklyBatch + "..."
      END IF
   END IF
END SUB

SUB WriteDate (Dat$, File$, Locat)
   Fil% = FREEFILE
   OPEN File$ FOR BINARY AS Fil%
      FOR X = 1 TO 2
         Byte(X) = CHR$(Bin2Num(MID$((FixBin$(Num2Bin$(VAL(MID$(Dat$, 1, 2))), 4) + FixBin$(Num2Bin$(VAL(MID$(Dat$, 4, 2))), 5) + FixBin$(Num2Bin$((VAL(MID$(Dat$, 7, 4))) - 1980), 7)), ((X - 1) * 8) + 1, 8)))
         PUT #1, X - 1 + Locat, Byte(X)
      NEXT
   CLOSE Fil%
END SUB

SUB WriteUser (User, Accum)
   Fil% = FREEFILE
   OPEN DataFile FOR BINARY AS Fil%
   TotASC$ = FixBin$(Num2Bin$(User), 9) + FixBin$(Num2Bin$(Accum), 9) + "000000"
   Byte(1) = CHR$(Bin2Num(MID$(TotASC$, 1, 8)))
   Byte(2) = CHR$(Bin2Num(MID$(TotASC$, 9, 8)))
   Byte(3) = CHR$(Bin2Num(MID$(TotASC$, 17, 8)))
   FOR X = 1 TO 3
      PUT #1, X + 2, Byte(X)
   NEXT
   CLOSE Fil%
END SUB

SUB YearCheck
   IF MID$(Dates$(1), 7, 4) <> MID$(Dates$(2), 7, 4) OR COMMAND$ = CheckOption THEN
      IF Flag%(4) = False THEN
         PRINT "Yearly Maintenance is due... Execute " + YearlyBatch + "? (Y/n)"
         Choi$ = INPUT$(1)
      END IF
      IF UCASE$(Choi$) <> "N" THEN
         PRINT "Performing Yearly Maintenance..."
         IF NOT Exist%(YearlyBatch) THEN
            PRINT "No " + YearlyBatch + "... Skipping..."
         ELSE
            IF Flag%(1) = True THEN
               Describe YearlyBatch, YearlyDes
            END IF
            SHELL YearlyBatch
         END IF
      ELSE
         PRINT "Skipping " + YearlyBatch + "..."
      END IF
   END IF
END SUB

