/*Ŀ
 ݳ                                                                      
 ݳ Program Name: LIST.PRG                                               
 ݳ     Language: Clipper 5.0                                            
 ݳ       Author: Ted Long [73700,1751]                                  
 ݳ      Tweaker: Kevin S. Gallagher [70034,2313]                        
 ݳ                                                                      
 Ĵ
 ݳ Comments:                                                            
 ݳ KSG 12/31/94                                                         
 ݳ This viewer which Ted Long created works nicely with plain old       
 ݳ Clipper code. One feature that would really be nice would be to have 
 ݳ the viewer show two colors, meaning regular and bold. Hence i added  
 ݳ code from yet another programmer Todd C. MacDonald. Todd's code can  
 ݳ be found in twocolor.prg and is really cool if you have the need to  
 ݳ show two colors on a single line.                                    
 ݳ                                                                      
 ݳ I did awhole lot of other tweaks and altered most of the variable    
 ݳ names (got short on time to finsh all of them).                      
 ݳ                                                                      
 ݳ The method for declaring variables came from an article i read done  
 ݳ by Steve Straley, which i modified to allow several declarations     
 ݳ and also added the ability to do assignments (empties).              
 ݳ                                                                      
 ݳ ERROR RECOVERY for Duplicate alias                                   
 ݳ Recovery is a Begin/End Seqeunce in ReadText() that can be removed   
 ݳ or tweaked. It requires CA-Clipper 5.2 and will not work with V5.1   
 ݳ                                                                      
 
            */

#include "commands.h"

static nOffSet, nBotRow   as int
static nLeft, nBoxTop     as int
static nLowColor,nHiColor as int
static cGetStr            as char
static lAdapType          as logical

#ifdef KG_TEST
/*
*   Routine: Main()
*          :
*   Purpose: Simple demo for viewer
*          :
* Arguments: void
*          :
*  Comments: void
*/
procedure main
    local getlist := {}
    local cColor1
    local cColor2
    local aPrgs_
    local aText_
    local aHeads_
    local aFiles_ := {"Quit Demo"}
    local nChoice
    local nLen

    cls
    @0,0 say " Working " color "w+*/r"

    aPrgs_  := directory("*.prg")
    aText_  := directory("*.doc")
    aHeads_ := directory("*.h")

    if !empty(aPrgs_)
        aeval(aPrgs_,{|a_| aadd(aFiles_,lower(a_[1]))})
    endif
    if !empty(aText_)
        aeval(aText_,{|a_| aadd(aFiles_,lower(a_[1]))})
    endif
    if !empty(aHeads_)
        aeval(aHeads_,{|a_| aadd(aFiles_,lower(a_[1]))})
    endif

    if !empty(nLen := len(aFiles_))
        while .t.
            dispbox(0,0,19,21,"ͻȺ ","w+/n")
            nChoice := aChoice(1,1,18,20,aFiles_)
            if nChoice == 1
                exit
            elseif nChoice <> 0
                tone(400,1)
                tone(400,1)
                cColor1 := "w/b  "
                cColor2 := "w+/b  "
                @20,0 say "Please enter colors to use"
                @23,0 say "Make sure to enter only valid color strings!"
                @21,0 say "Regular color " get cColor1 
                @22,0 say "   Bold color " get cColor2
                read
                cColor1 := alltrim(cColor1)
                cColor2 := alltrim(cColor2)
                ReadText(aFiles_[nChoice],cColor1,cColor2)
            endif
        enddo
    else
        alert("Nothing to show")
    endif
    cls
return
#endif

/*
*   Routine: ReadText(<cInFile>[,<cStdColor>][,<cBoldColor>])
*          :
*   Purpose: Used to view an ascii text file
*          :
* Arguments: <cInFile>      is the file to view
*          : <cStdColor>    low color to display text w/o chr(1)'s
*          : <cBoldColor>   bold color to show text marked with chr(1)'s
*          :
*  Comments: void
*          :
*/
function ReadText(cInFile, cStdColor, cBoldColor)
    local getlist   as array
    local aDbfArr_  as array
    local cTmpScrn  as char
    local newcolor  as char
    local cPhrase   as char
    local nKey      as int
    local nTotRecs  as int
    local nNewRec   as int
    local nOldTop   as int
    local lFlag     as logical
    local cOldColor := setcolor()
    local nOldArea  := SELECT()
    local nTopRec   := 1
    local cFile
    local bOldErrhand
    local oError

    if cInFile == NIL
        #ifdef IN_LINE_CODE
           alert("Must supply a filename")
           return nil
        #else
           alert("Must supply a filename...")
           QUIT
        #endif
    endif

    if !file(cInFile)
        #ifdef IN_LINE_CODE
           alert("Missing the file;" + cInFile)
           return nil
        #else
           ?"Missing " + cInFile + "..."
           QUIT
        #endif
    endif

    set scoreboard off

    // must do file wide statics for each call
    cFile     := parseslash(cInFile)
    cGetStr   := ""
    lAdapType := if(iscolor(),.t.,.f.)
    nBotRow   := 23
    nOffSet   := 1
    nLeft     := 1                               // Screen row.
    nBoxTop   := 1                               // Top Row of box.

    cStdColor := ifempty(cStdColor ,"w/b")
    cBoldColor:= ifempty(cBoldColor,"w+/b")
    nLowColor := Clr2Attr(if(lAdapType,cStdColor,7))
    nHiColor  := Clr2Attr(if(lAdapType,cBoldColor,31))
    newcolor  := if(lAdapType,cStdColor,"w/n")
    cls

    @0,0 say padr('Prepared file for display...',80) color newcolor

    aadd(aDbfArr_,{"LINE","C",220,0})

    bOldErrhand := errorblock({|e| break(e)})
    begin sequence
        dbcreate("TEXT.$DB",aDbfArr_)
        USE TEXT.$db NEW EXCLUSIVE
        APPEND FROM &cInFile. SDF
    recover using oError
        // simple error recovery
        if valtype(oError) == "O"
            if oError:gencode == EG_DUPALIAS
                alert("Duplicate alias;Can not view file")
            else
                alert("Cannot view file;Error code " + NtoS(oError:gencode))
            endif
        else
            // NEW: Clipper 5.2 function
            errorinhandler()
        endif
        // release control of error-handling
        errorblock(bOldErrhand)
        setcolor(cOldColor)
        select (nOldArea)
        return nil
    end sequence
    errorblock(bOldErrhand)

    text->(dbgotop())

    nTotRecs := lastrec()

    setcolor(newcolor)
    cls

    // Paint first screen.
    ShowLINS()

    @0,0 say padr("File: " + alltrim(cFile),80)     color "n/w"
    BottLine()

    lFlag := .F.

    while .t.
        @0,29 say "Line: "                          color "n/w"
        DevOutPict(nTopRec,"@B","n/w")
        @24,09 SAY ""                               color "n/w"
        setcolor(newcolor)

        nKey := inkey(0)

        do case
            case lastkey() == K_ESC
                setcolor(cOldColor)
                cls
                use
                select (nOldArea)
                if (ferase("TEXT.$db")) == F_ERROR
                    alert("COULD NOT REMOVE TEST.$DB")
                endif
                #ifdef IN_LINE_CODE
                   return nil
                #else
                   QUIT
                #endif
            case nKey == K_RIGHT
                if nOffSet < 240
                    nOffSet := nOffSet +20
                endif

                text->(nTopRec)
                showlins()

            case nKey == K_LEFT
                if nOffSet >= 21
                    nOffSet := nOffSet -20
                endif

                text->(dbgoto(nTopRec))
                showlins()

            case nKey == K_HOME
                text->(dbgoto(1))
                nTopRec := 1
                showlins()

            case nKey == K_END
                if nTotRecs >= nBotRow-nBoxTop
                    GO nTotRecs - (nBotRow-nBoxTop)
                else
                    text->(dbgoto(1))
                endif

                nTopRec := RECNO()
                showlins()

            case nKey == K_PGDN
                if nTopRec + nBotRow-nBoxTop <= nTotRecs
                    nTopRec := nTopRec+nBotRow-nBoxTop
                else
                    nTopRec := nTotRecs
                endif

                text->(dbgoto(nTopRec))
                showlins()

            case nKey == K_PGUP
                nNewRec := nTopRec - (nBotRow-nBoxTop)
                if nNewRec > 0
                    nTopRec := nNewRec
                else
                    nTopRec := 1
                endif

                text->(dbgoto(nTopRec))
                showlins()

            case nKey == K_UP
                if nTopRec > 1
                    SCROLL(nBoxTop,0,nBotRow,79,-1)
                    // Got to the new record.
                    nTopRec := nTopRec -1
                    text->(dbgoto(nTopRec))
                    ft_ClrSay(nBoxTop,nLowColor,nHiColor)
                else
                    // If we are at the 1st record already, do nothing.
                endif

            case nKey == K_DOWN
                if nTopRec - nBoxTop + nBotRow < nTotRecs
                    SCROLL(nBoxTop,0,nBotRow,79,1)
                    nTopRec := nTopRec+1
                    text->(dbgoto(nTopRec + nBotRow - nBoxTop))
                    ft_ClrSay(nBotRow,nLowColor,nHiColor)
                endif

                // help requested
            case nKey == 28 .or. nKey == 72 .or. nKey == 104 .or. nKey == 63
                cTmpScrn := SAVESCREEN(6,8,20,74)

                if !lAdapType
                    cls
                endif
                RS_BOX(6,8,18,72,,cBoldColor)
                setcolor(cBoldColor)
                CENTR(6, " Help Screen ")
                @07,9 say " Cursor Left    - Pans the screen left"
                @08,9 say " Cursor Right   - Pans the screen right"
                @09,9 say " Cursor up/down - Move to the next or previous line"
                @10,9 say " Page-Up        - Move up one screen page"
                @11,9 say " Page-Down      - Move down one screen page"
                @12,9 say " Home           - Go to the top of the document"
                @13,9 say " End            - Go to the bottom of the document"
                @14,9 say " F  Find Text   - Non case sensitive find"
                @15,9 say " C  Find Text   - Case sensitive find"
                @16,9 say " N  Next        - Next find"
                @17,9 say " P  Print       - Print viewed document"
                inkey(0)
                restscreen(6,8,20,74,cTmpScrn)

            case nKey == 112 .or. nKey == 80
                if isprinter()
                    SET CONSOLE OFF
                    TYPE &cInFile. TO PRINT
                    SET CONSOLE ON
                else
                    O_ERROR("PRINTER IS NOT READY......")
                endif

                // User wants to locate a string.
            case nKey == 70 .OR. nKey == 102
                nOldTop  := nTopRec
                text->(dbgoto(nTopRec))
                setcolor("I")
                @24,0 say space(80)

                cGetStr := replicate(" ",25)
                @24,00 say "Search for ? " GET cGetStr
                READ

                if !empty(cGetStr)
                    cGetStr := lower(trim(cGetStr))
                    cPhrase := chr(34) + trim(cGetStr) + chr(34)
                    LOCATE NEXT 1000000 FOR cGetStr $ LOWER(FIELD->line)
                    if eof()
                        @24,0 say space(80)
                        @24,0 say cPhrase+' not found. Press any key....'
                        nKey    := inkey(0)
                        nTopRec := nOldTop
                        text->(dbgoto(nTopRec))
                    else
                        nTopRec := text->(recno())
                    endif
                    lFlag := .T.
                endif

                setcolor(newcolor)
                showlins()
                BottLine()
                setcolor(newcolor)

            case nKey == 67 .or. nKey == 99
                cGetStr := replicate(" ",25)
                nOldTop := nTopRec
                text->(dbgoto(nTopRec))
                setcolor("I")
                @24,0 say space(80)
                @24,0 say "Search for ? " GET cGetStr
                READ

                cPhrase := chr(34) + trim(cGetStr) + chr(34)
                if !empty(cGetStr)
                    cGetStr := TRIM(cGetStr)
                    LOCATE NEXT 1000000 FOR cGetStr $ FIELD->line
                    if eof()
                        @24,0 say space(80)
                        @24,0 say cPhrase + ' not found. Press any key....'
                        nKey    := inkey(0)
                        nTopRec := nOldTop
                        text->(dbgoto(nTopRec))
                    else
                        nTopRec := recno()
                    endif
                    lFlag := .T.
                endif

                setcolor(newcolor)
                showlins()
                BottLine()

                // User wants to find the next occurrence.
            case nKey == 78 .or. nKey == 110
                if lFlag
                    CONTINUE
                    if eof()
                        setcolor("I")
                        @24,0 say space(80)
                        @24,0 say cPhrase + ;
                             '- Next occurrence not found. Press any key....'

                        nKey    := inkey(0)
                        nTopRec := nOldTop
                        text->(dbgoto(nTopRec))
                    else
                        nTopRec := recno()
                    endif
                    setcolor(newcolor)
                    showlins()
                    BottLine()
                endif
        endcase
    enddo
return nil

/*
*   Routine: ShowLins()
*          :
*   Purpose: Used to display contents of file to the screen in full pages.
*          :
* Arguments: void
*          :
*  Comments: void
*          :
*/
static function showlins()
    local lastrow as int

    @ nBoxTop, 0 CLEAR TO nBotRow,79

    nLeft := nBoxTop

    while .not. eof() .and. nLeft <= nBotRow
        ft_ClrSay(nLeft,nLowColor,nHiColor)
        // @ nLeft,0 SAY substr(FIELD->line,nOffSet,79)
        SKIP
        nLeft += 1
    enddo
    lastrow := nLeft-1
return .t.

/*
*   Routine: ParseSlash(<cFname>)
*          :
*   Purpose: Removes backslashs from filename
*          :
* Arguments: <cFname> which is the file we will view in ReadText()
*          :
*  Comments: void
*          :
*/
STATIC FUNCTION ParseSlash(cFname)
    local posa, posb as int

    cFname := alltrim(cFname)

    // If the filename is included within a path,
    // the parse out the filename
    posa := rat("\",cFname)
    if posa > 0
        cFname := substr(cFname, posa +1,len(cFname))
    endif
return cFname

/*
*   Routine: Ml_Box(<nRow>, <cStr>) --> NIL
*          :
*   Purpose: centers a message on the screen with a box.
*          : Starting at the specific line number
*          :
* Arguments: <nRow> row to center <cStr>
*          : <cStr> character string to center on row pass by <nRow>
*          :
*  Comments: void
*          :
*/
static function ML_box(nRow, cStr)
    local nLen           as int
    local nBegIt, nEndIt as int

    if len(alltrim(cStr)) >= 76
        nLen := 76
        cStr := substr(cStr,1,76)
    else
        nLen := round(len(alltrim(cStr)),0)
    endif

    nBegIt := round((80-nLen)/2,0) -2
    nEndIt := round(((80-nLen)/2) +nLen,0) +1
    
    RS_BOX(nRow-1,nBegIt,nRow +1,nEndIt)
    @nRow-1, 34       say "  Message  "
    @nRow,(nBegIt +2) say alltrim(cStr)
return nil

/*
*   Routine: RS_BOX(nBegRow,nBegCol,end_row,end_col,nBoxTypes,cBoxColor)
*          :
*   Purpose: Produces a shadow box
*          :
* Arguments: <nBegRow>   BEGINING ROW
*          : <nBegCol>   BEGINING COL
*          : <end_row>   ENDING ROW
*          : <end_col>   ENDING COLUMN
*          : <nBoxTypes> BOX TYPE  (optional)
*          : <cBoxColor> BOX COLOR
*          :
*  Comments: TL I'm sure that this is the fastet non-destructive
*          : shadowbox available that is written in 100% Clipper.
*          : Speed gets damn close to ASM
*          :
*  Box Opts: 1 := Ŀ     2 := ͻȺ
*          : 3 := ͸Գ     4 := ķӺ
*          : 5 := " "
*          :
*          : DEFAULT :=  Ŀ
*          :
*/
static function RS_BOX(nBegRow,nBegCol,end_row,end_col,nBoxTypes,cBoxColor)
    local mboxer      as char
    local vert, horiz as char
    local h, v        as char
    local origcolor   as char

    /*
    * check to see if the parameters passed are greater than possible
    * shadow box coordinates on a 80 X 25 Screen
    */
    do case
        case nBegRow < 0 .or. nBegRow > 23
            return nil
        case nBegCol < 0 .or. nBegCol > 77
            return nil
        case end_row < 2 .or. end_row > 23
            return nil
        case end_col < 0 .or. end_col > 77
            return nil
    endcase

    origcolor := setcolor(if(lAdapType,"w+/b","w+/w"))

    // determine type of frame for the box
    if valtype(nBoxTypes) == "N"
        if nBoxTypes >0 .and. nBoxTypes <=6
            mBoxer := BOXTYPE[ nBoxTypes ]
        endif
    else
        mBoxer := BOXTYPE[1]
    endif

    // Save and transform the Right Vertical axis
    vert := savescreen(nBegRow +1, end_col +1, end_row +1, end_col +2)
    v    := transform(vert, replicate("X" + chr(07),len(vert)))

    // Save and transform the Bottom horizontal axis
    horiz := savescreen(end_row +1, nBegCol +2, end_row +1, end_col +2)
    h     := transform(horiz, replicate("X" + chr(07), len(horiz)))

    // restore the screen with the vertical and horizontal axis (memvar)
    restscreen(nBegRow+1, end_col+1, end_row+1, end_col+2, v)
    restscreen(end_row+1, nBegCol+2, end_row+1, end_col+2, h)

    if cBoxColor != NIL
        setcolor(cBoxColor)
    endif

    dispbox(nBegRow,nBegCol,end_row,end_col,mboxer)
    setcolor(origcolor)
return nil

/*
*   Routine: O_Error()
*          :
*   Purpose:
*          :
* Arguments:
*          :
*  Comments:
*/
static function o_error( aMsg_, cColor1, nLines, defaultval, boxtype )
    local nWidth    as int
    local retval    as int
    local i         as int
    local nOne      as int
    local nMaxLen   as int
    local cScrn     as char
    local cColor2   as char
    local cOldColor := setcolor()

    cColor2 := if(lAdapType,"+W/R,+W/N", "w/n")

    if(!empty(cColor1), cColor2 := cColor1,)
    if(nLines     == nil, nLines  := 10,)
    if(defaultval == nil, defaultval := .T.,)
    if(boxtype    == nil, boxtype := 1,)

    if valtype(aMsg_) == "C"
        aMsg_ := {alltrim(aMsg_)}
    endi

    // Determine the maximum length element of the array
    nOne    := 1
    nMaxLen := 1

    for i := 1 to len( aMsg_ )
        nOne    := max(len(aMsg_[ i ]),nMaxLen)
        nMaxLen := nOne
    next

    nWidth := int(max(74 - nMaxLen, 0)) / 2
    cScrn := savescreen(nLines,nWidth,nLines +nMaxLen +4, 82 - nWidth)

    setcolor(cColor2)

    TONE(200,2)

    RS_BOX(nLines,nWidth,nLines +len(aMsg_) +3, 80 - nWidth, boxtype )

    for i := 1 to len(aMsg_)
        centr(nLines + i, aMsg_[i])
    next

    centr(nLines + len(aMsg_) +2,"** Press any key **")
    inkey(0)

    restscreen(nLines, nWidth, nLines + nMaxLen + 4 , 82 - nWidth, cScrn)
    setcolor(cOldColor)
return( retval )

/*
*   Routine: Centr(<nDispRow>, <cSayString>, <cColor>)
*          :
*   Purpose: centers a character string on the screen
*          :
* Arguments:
*          :
*  Comments: void
*/
static function CENTR(nDispRow, cSayString, cColor)
    local nLen, nBeg as int
    local dacolor    as char

    if(cColor == NIL, dacolor := setcolor(), dacolor := cColor)

    nLen := round(len(alltrim(cSayString)),0)
    nBeg := round((80-nLen)/2,0)-2

    @ nDispRow,(nBeg +2) SAY ALLTRIM(cSayString) COLOR dacolor

return nil

/*
*   Routine: BottLine()
*          :
*   Purpose: shows key options
*          :
* Arguments: void
*          :
*  Comments: used to cleanup main code.
*/
procedure BottLine()
@24,0 say padr("Command  "+space(20) +"Keys: " + KeyList1 ,80) color "n/w"
return

#stdout ------------------------------------------------------------------------------
#ifdef IN_LINE_CODE
#stdout Using code for application
#else
#stdout Using code for utilty
#endif
#stdout ------------------------------------------------------------------------------

#ifdef KG_TEST
#stdout ALERT COMPILING IN DEMO MODE
#stdout ------------------------------------------------------------------------------
#endif
