// ==========================================================================
// 							Class Implementation : CDirList
// ==========================================================================

// Source file : dirlist.cpp

// Source : Periphere NV (R.Mortelmans)
// Creation Date : 	   2nd November 1995
// Last Modification : 2nd November 1995
                          
// //////////////////////////////////////////////////////////////////////////

#include "stdafx.h"		// standard MFC include
#include "dirlist.h"	// class specification
#include "dos.h"		// for _dos_findfirst, ...

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CDirList, CObject)

#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// Definition of static members


// Data members -------------------------------------------------------------
// protected:
	// CPath m_path;
	// --- The path specification where to look for Dirs
	
	// CObList m_dirList;			// Contains objects of class CDirSpec
	// --- The list of dir specifications found in the above specified path

// private:
	
// Member functions ---------------------------------------------------------
// public:

CDirList::CDirList()
	:
	m_path()
	{
	}
	
CPathSpec CDirList::GetPath() const
	{
	return m_path;
	}
	
BOOL CDirList::SetPath(CPathSpec path)
	{
	if (path.GetFileName().IsEmpty())
		path.SetFileName(TEXT("*.*"));
	if (path.MakeAbsolute())
		{
		m_path = path;
		return TRUE;
		}
	else
		{
		TRACE(TEXT("CDirList::SetPath : Path spec is invalid : %s\n"), path.GetPath());
		return FALSE;
		}
	}   
	
BOOL CDirList::Search()
	{
#ifdef WIN32
	CDirSpec* pDir;
	WIN32_FIND_DATA fileData;
	HANDLE hFindFile;
	BOOL bFileFound(TRUE);
		
	hFindFile = FindFirstFile(m_path.GetPath(), &fileData);
	if(hFindFile != INVALID_HANDLE_VALUE)
		{
		while (bFileFound)
			{
			if ((fileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) &&
				(fileData.cFileName[0] != __TEXT('.')) && 
				(fileData.cFileName[0] != __TEXT('..')))
				{
				pDir = new CDirSpec(m_path.GetDirectory());
				pDir->AppendDirectory(CDirSpec(fileData.cFileName));
				m_dirArray.Add(pDir);
				}

			bFileFound = FindNextFile(hFindFile, &fileData);
			}
		FindClose(hFindFile);
		}
	return TRUE;

#else
	CDirSpec* pDir;
	_find_t fileInfo;
	BOOL bFileFound;
	
	bFileFound = (_dos_findfirst(m_path.GetPath(), _A_NORMAL | _A_ARCH | _A_SUBDIR, &fileInfo) == 0);
	while (bFileFound)
		{
		if ((fileInfo.attrib & _A_SUBDIR) && (strcmp(fileInfo.name, TEXT(".")) != 0) &&
			(strcmp(fileInfo.name, TEXT("..")) != 0))
			{
			pDir = new CDirSpec(m_path.GetDirectory());
			pDir->AppendDirectory(CDirSpec(fileInfo.name));
			m_dirArray.Add(pDir);
			}

		bFileFound = (_dos_findnext(&fileInfo) == 0);
		}		
	return TRUE;
#endif
	}
	
const CObArray* CDirList::GetList() const
	{
	return &m_dirArray;
	}

const CDirSpec* CDirList::GetAt(int nIndex) const
{
	return (CDirSpec*) m_dirArray.GetAt(nIndex);
}
	
void CDirList::Sort()
	{
	// This algorithm will sort a list using selection sort
	// The array contains objects from position 0 to END
	// nIndexNotSorted points to the first not yet sorted object,
	//  so the set [0..nIndexNotSorted - 1] is already sorted
	// This algorithm searches the not yet sorted objects in the set
	//  [nIndexNotSorted..END] for the smallest object and adds this 
	//  to the sorted objects
	// nIndexCompare point to the last object in this set that has 
	//  already been examined
	// The algorithm ends when all objects are sorted
	int nIndexNotSorted = 0;
	int nIndexCompare = 0;
	CDirSpec* pSmallestDir = NULL;	// point to array[nIndexSorted]
	CDirSpec* pCompareDir = NULL;		// point to array[nIndexCompare]
	CDirSpec* pSwapDir;
	
	while (nIndexNotSorted <= m_dirArray.GetUpperBound())
		{
		ASSERT(m_dirArray[nIndexNotSorted]->IsKindOf(RUNTIME_CLASS(CDirSpec)));
		pSmallestDir = (CDirSpec*)m_dirArray[nIndexNotSorted];
		nIndexCompare = nIndexNotSorted;
		nIndexCompare++;
		
		while (nIndexCompare <= m_dirArray.GetUpperBound()) 
			{
			ASSERT(m_dirArray[nIndexCompare]->IsKindOf(RUNTIME_CLASS(CDirSpec)));
			pCompareDir = (CDirSpec*)m_dirArray[nIndexCompare];
			if (*pCompareDir < *pSmallestDir)
				{
				pSwapDir = pSmallestDir;
				m_dirArray[nIndexNotSorted] = m_dirArray[nIndexCompare];
				m_dirArray[nIndexCompare] = pSwapDir;
				pSmallestDir = (CDirSpec*)m_dirArray[nIndexNotSorted];
				}
			nIndexCompare++;
			}
		nIndexNotSorted++;
		}
	}
	
void CDirList::ClearList()
	{
	CDirSpec* pDir;
	int nIndex = 0;
	int nMaxIndex = m_dirArray.GetUpperBound();
	while (nIndex <= nMaxIndex) 
		{
		ASSERT(m_dirArray[nIndex]->IsKindOf(RUNTIME_CLASS(CDirSpec)));
		pDir = (CDirSpec*)m_dirArray[nIndex];
		delete pDir;
		nIndex++;
		}
	m_dirArray.RemoveAll();
	}
	
#ifdef _DEBUG
void CDirList::Dump(CDumpContext& dc) const
	{
	CObject::Dump(dc);
	dc << TEXT("\nm_path : ");
	m_path.Dump(dc);
	dc << TEXT("\nm_dirArray : ") << m_dirArray;	
	}

void CDirList::AssertValid() const
	{
	CObject::AssertValid();
	}
#endif

CDirList::~CDirList()
	{
	ClearList();
	}
	
// protected:

// private:

// Message handlers ---------------------------------------------------------

// ==========================================================================
