// ==========================================================================
// 							Class Implementation : CFileSpec
// ==========================================================================

// Source file : file.cpp

// Source : Periphere NV (R.Mortelmans)
// Creation Date : 	   2nd November. 1995
// Last Modification : 2nd November. 1995
                          
// //////////////////////////////////////////////////////////////////////////

#include "stdafx.h"		// standard MFC include
#include "file.h"		// class specification

#include <direct.h>		// For directory functions (getdcwd(), ...)
#include <stdlib.h>		// For constant definitions  (_MAX_DIR, ...)
#include <string.h>		// For string search  (strspn, ...)

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#include "filelmt.h"	// for invalid chars

IMPLEMENT_DYNAMIC(CFileSpec, CObject)

#define new DEBUG_NEW

/////////////////////////////////////////////////////////////////////////////
// Definition of static members


// Data members -------------------------------------------------------------
// protected:

// private:
	// CString m_sFileName;
	// --- The file name of the file 
	//     (everything behind the last full stop is the extender-part)

	// CTime m_time;
	// --- Date and time of last modification
	// LONG m_lnLength;
	// --- File size in bytes
	// Attribute m_eAttributes;
	// --- DOS attributes (see enum Attribute of MFC)

// Member functions ---------------------------------------------------------
// public:

CFileSpec::CFileSpec()
	:
	m_sFileName(TEXT("")),
	m_time(),
	m_lnLength(0),
	m_eAttributes(CFile::normal)
	{
	}
	
CFileSpec::CFileSpec(const char* pszFileName)
	{
	// ... Must be valid pointer
	ASSERT(pszFileName != NULL);
	if (!SetFileName(pszFileName))
		{
		TRACE(TEXT("CFileSpec::CFileSpec : An invalid file name (%s) was specified, clearing object\n"),
			pszFileName);
		SetFileName(TEXT(""));
		}
	}
	
CFileSpec::CFileSpec(const CFileSpec& fileSrc)
	:
	m_sFileName(fileSrc.m_sFileName)
	{
	}
	
const CFileSpec& CFileSpec::operator=(const CFileSpec& fileSrc)
	{
	m_sFileName = fileSrc.m_sFileName;
	return *this;
	}
	
CString CFileSpec::GetBaseName() const
	{
	int nFullStopPosition;
	if ((nFullStopPosition = m_sFileName.ReverseFind('.')) != -1)
		return m_sFileName.Left(nFullStopPosition);
	else
		return m_sFileName;
	}
	
BOOL CFileSpec::SetBaseName(const char* pszBaseName)
	{
	// ... Must be valid pointer
	ASSERT(pszBaseName != NULL);
	CString sFileName(pszBaseName);
	CString sExtender(GetExtender());
	sFileName.MakeLower();
	if ((int)strcspn(sFileName, INVALID_W_FILE_CHARS) != sFileName.GetLength())
		{
		TRACE(TEXT("CFileSpec::SetBaseName : Basename (%s) contains illegal characters\n"), pszBaseName);
		return FALSE;
		}
	m_sFileName = sFileName;
	if (!sExtender.IsEmpty())
		m_sFileName += '.' + sExtender;
	return TRUE;
	}
	
void CFileSpec::ForceSetBaseName(const char* pszBaseName)
	{
	// ... Must be valid pointer
	ASSERT(pszBaseName != NULL);
	CString sFileName(pszBaseName);
	CString sExtender(GetExtender());
	if (!sExtender.IsEmpty())
		sFileName = sFileName + '.' + sExtender;
	ForceSetFileName(sFileName);
	}
	
CString CFileSpec::GetExtender() const
	{
	int nFullStopPosition;
	if ((nFullStopPosition = m_sFileName.ReverseFind('.')) != -1)
		return m_sFileName.Mid(nFullStopPosition + 1);
	else
		return TEXT("");
	}
	
BOOL CFileSpec::SetExtender(const char* pszExtender)
	{
	// ... Must be valid pointer
	ASSERT(pszExtender != NULL);
	CString sFileName(GetBaseName());
	CString sExtender(pszExtender);
	sExtender.MakeLower();
	if ((int)strcspn(sExtender, INVALID_W_FILE_CHARS) != sExtender.GetLength())
		{
		TRACE(TEXT("CFileSpec::SetExtender : Extender (%s) contains illegal characters\n"), pszExtender);
		return FALSE;
		}
	if (!sExtender.IsEmpty())
		sFileName += '.' + sExtender;
	if (sFileName.GetLength() > MAX_FILE_NAME_LENGTH)
		{
		TRACE(TEXT("CFileSpec::SetExtender : Setting extender would make file name too long (%)\n"), sFileName.GetLength());
		return FALSE;
		}
	m_sFileName = sFileName;
	return TRUE;
	}

void CFileSpec::ForceSetExtender(const char* pszExtender)
	{
	// ... Must be valid pointer
	ASSERT(pszExtender != NULL);
	CString sFileName(GetBaseName());
	if (*pszExtender != '\0')
		sFileName = sFileName + '.' + pszExtender;
	ForceSetFileName(sFileName);
	}
	
CString CFileSpec::GetFileName() const
	{
	return m_sFileName;
	}
	
BOOL CFileSpec::SetFileName(const char* pszFileName)
	{
	// ... Must be valid pointer
	ASSERT(pszFileName != NULL);
	if ((int)strcspn(pszFileName, INVALID_W_FILE_CHARS) != strlen(pszFileName))
		{
		TRACE(TEXT("CFileSpec::SetFileName : File name (%s) contains illegal characters\n"), pszFileName);
		return FALSE;
		}
	if (strlen(pszFileName) > MAX_FILE_NAME_LENGTH)
		{
		TRACE(TEXT("CFileSpec::SetFileName : File name too long (%u)\n"), strlen(pszFileName));
		return FALSE;
		}
	m_sFileName = pszFileName;
	m_sFileName.MakeLower();
	return TRUE;
	}
	
void CFileSpec::ForceSetFileName(const char* pszFileName)
	{
	// ... Must be valid pointer
	ASSERT(pszFileName != NULL);
	CString sFileName(pszFileName);
	int nIndexWrongChar;
	while ((nIndexWrongChar = (int)strcspn(sFileName, INVALID_W_FILE_CHARS)) != sFileName.GetLength())
		{
		sFileName = sFileName.Left(nIndexWrongChar) + sFileName.Mid(nIndexWrongChar + 1);
		}
	if (sFileName.GetLength() > MAX_FILE_NAME_LENGTH)
		sFileName = sFileName.Left(MAX_FILE_NAME_LENGTH);
	sFileName.MakeLower();
	VERIFY(SetFileName(sFileName));
	}
	
CTime CFileSpec::GetTime() const
	{
	return m_time;
	}
	
BOOL CFileSpec::SetTime(CTime time)
	{
	m_time = time;
	return TRUE;
	}
	
LONG CFileSpec::GetLength() const
	{
	return m_lnLength;
	}
	
BOOL CFileSpec::SetLength(LONG lnLength)
	{
	if (0 <= lnLength)
		{
		m_lnLength = lnLength;
		return TRUE;
		}
	else
		{
		TRACE(TEXT("CFileSpec::SetLength : Invalid length : %ln\n"), lnLength);
		return FALSE;
		}
	}
	
BYTE CFileSpec::GetAttributes() const
	{
	return m_eAttributes;
	}
	
BOOL CFileSpec::SetAttributes(CFile::Attribute attributes)
	{
	m_eAttributes = attributes;
	return TRUE;
	}

BOOL CFileSpec::IsEmpty() const
	{
	return GetFileName().IsEmpty();
	}
	
void CFileSpec::Empty() 
	{
	m_sFileName.Empty();
	}
	
BOOL CFileSpec::operator==(CFileSpec fileSpec) const
	{
	return (m_sFileName == fileSpec.m_sFileName);
	}
	
BOOL CFileSpec::operator!=(CFileSpec fileSpec) const
	{
	return (m_sFileName != fileSpec.m_sFileName);
	}
	
BOOL CFileSpec::operator<=(CFileSpec fileSpec) const
	{
	return (m_sFileName <= fileSpec.m_sFileName);
	}
	
BOOL CFileSpec::operator<(CFileSpec fileSpec) const
	{
	return (m_sFileName < fileSpec.m_sFileName);
	}
	
BOOL CFileSpec::operator>=(CFileSpec fileSpec) const
	{
	return (m_sFileName >= fileSpec.m_sFileName);
	}
	
BOOL CFileSpec::operator>(CFileSpec fileSpec) const
	{
	return (m_sFileName > fileSpec.m_sFileName);
	}
	

#ifdef _DEBUG
void CFileSpec::Dump(CDumpContext& dc) const
	{
	CObject::Dump(dc);
	dc << TEXT("\nm_sFileName : ") << m_sFileName;
	dc << TEXT("\nm_time : ") << m_time;
	dc << TEXT("\nm_lnLength : ") << m_lnLength;
	dc << TEXT("\nm_eAttributes : ") << m_eAttributes;
	}

void CFileSpec::AssertValid() const
	{
	CObject::AssertValid();
	}
#endif

CFileSpec::~CFileSpec()
	{
	}
	
// protected:

// private:

// ==========================================================================
