/* Net Checkers -- Williams */
#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "checker.h"


/* Fresh board */
STATE newboard[8][8]=
  {
   {CELL_EMPTY,CELL_BLACK,CELL_EMPTY,CELL_BLACK,
     CELL_EMPTY,CELL_BLACK,CELL_EMPTY,CELL_BLACK},
   {CELL_BLACK,CELL_EMPTY,CELL_BLACK,CELL_EMPTY,
     CELL_BLACK,CELL_EMPTY,CELL_BLACK,CELL_EMPTY},
   {CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,
     CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY},
   {CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,
     CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY},
   {CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,
     CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY},
   {CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,
     CELL_EMPTY,CELL_EMPTY,CELL_EMPTY,CELL_EMPTY},
   {CELL_EMPTY,CELL_RED,CELL_EMPTY,CELL_RED,
     CELL_EMPTY,CELL_RED,CELL_EMPTY,CELL_RED},
   {CELL_RED,CELL_EMPTY,CELL_RED,CELL_EMPTY,
     CELL_RED,CELL_EMPTY,CELL_RED,CELL_EMPTY}
   };

/* Current board */
STATE board[8][8];


POINT selectp;             /* Selected cell */
BOOL selected;             /* TRUE when selection active */

HWND       hWnd;           /* Handle to main window */
HINSTANCE  hInst;          /* Handle to instance data*/

/* File open filter */
char filefilter[]="Checker file\0*.chk\0All files\0*.*\0";

/* Make new board */
void new_board(HWND hWnd)
  {
  memcpy(board,newboard,sizeof(board));
  selected=FALSE;
  InvalidateRect(hWnd,NULL,FALSE);
  }


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
  {
  MSG msg;

  if (!hPrevInstance)
    if (!InitApplication(hInstance))
       return (FALSE);

  if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);

  while (GetMessage(&msg, NULL, 0, 0))
    {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
  return (msg.wParam);
  }



BOOL InitApplication(HINSTANCE hInstance)
   {
   WNDCLASS wc;
   wc.style = 0;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(APPICON));
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   wc.lpszMenuName ="Checker";
   wc.lpszClassName = "CheckerClass";
   return (RegisterClass(&wc));
   }


BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
   {
   RECT r;
/* Setup board */
   memcpy(board,newboard,sizeof(board));
   hInst = hInstance;
   r.top=r.left=0;
   r.right=600;
   r.bottom=400; /* force to 600x400 client area */
   AdjustWindowRect(&r,WS_OVERLAPPEDWINDOW,TRUE);
   hWnd = CreateWindow(
       "CheckerClass",
       "Checkers! ",
       WS_OVERLAPPEDWINDOW,
       CW_USEDEFAULT,
       CW_USEDEFAULT,
       r.right-r.left,
       r.bottom-r.top,
       NULL,
       NULL,
       hInstance,
       NULL
       );

   if (!hWnd)
       return (FALSE);

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   return (TRUE);
   }


LRESULT CALLBACK MainWndProc(HWND hWnd,
  UINT message, WPARAM wParam, LPARAM lParam)
   {
   switch (message)
     {
     case WM_PAINT:
       return Paint(hWnd);

     case WM_LBUTTONDOWN:
       selecting(hWnd,LOWORD(lParam),HIWORD(lParam));
       break;

     case WM_RBUTTONDOWN:
       action(hWnd,LOWORD(lParam),HIWORD(lParam));
       break;

     case WM_COMMAND:
           switch (wParam)
             {
             case IDM_NEW:
               if (MessageBox(hWnd,
                 "Starting a new game will destroy"
                 " the current game and network connection. "
                 "Do you really want a new game?",
                 "Notice",MB_YESNO|MB_ICONSTOP)==IDNO) break;
               netclose(hWnd);
               new_board(hWnd);
               break;

             case IDM_OPEN:
               {
               char fn[_MAX_PATH];
               FILE *f;
               *fn='\0';
               if (MessageBox(hWnd,
                 "Opening a new game will destroy"
                 " the current game and network connection. "
                 "Do you really want a new game?",
                 "Notice",MB_YESNO|MB_ICONSTOP)==IDNO) break;
               if (get_file(hWnd,fn,_MAX_PATH,
                 "Open File",filefilter,FALSE)||
                 !(f=fopen(fn,"rb")))
                   {
                   MessageBox(hWnd,
                     "Can't open file",NULL,MB_OK|MB_ICONSTOP);
                   break;
                   }
               netclose(hWnd);
               fread(&board,sizeof(board),1,f);
               fclose(f);
               InvalidateRect(hWnd,NULL,FALSE);
               break;
               }

             case IDM_SAVE:
               {
               char fn[_MAX_PATH];
               FILE *f;
               *fn='\0';
               if (get_file(hWnd,fn,_MAX_PATH,
                 "Save As",filefilter,TRUE)||
                 !(f=fopen(fn,"w")))
                 {
                 MessageBox(hWnd,"Can't open file",
                   NULL,MB_OK|MB_ICONSTOP);
                 break;
                 }
               fwrite(&board,sizeof(board),1,f);
               fclose(f);
               break;
               }


             case IDM_SERVER:
               server(hWnd);
               break;

             case IDM_CLIENT:
               client(hWnd);
               break;

             case IDM_QUIT:
               if (MessageBox(hWnd,
                 "Do you really want to close the connection?",
                 "Confirm",MB_YESNO)==IDYES)
                  netclose(hWnd);
               break;

             case IDM_EXIT:
                 DestroyWindow(hWnd);
                 break;


             case IDM_ABOUT:
                  MessageBox(hWnd,"Checkers! by Al Williams",
                      "About",MB_OK|MB_ICONEXCLAMATION);
                  break;
           }

         break;  /* End WM_COMMANDs */

/* User defined message -- handle action from network partner */
           case WM_TRANSACT:
               UpdateWindow(hWnd);
               transact(hWnd,lParam);
               break;

       case WM_DESTROY:
               netclose(hWnd);
               PostQuitMessage(0);
               break;

       default:
           return (DefWindowProc(hWnd, message,
             wParam, lParam));
       }
     return 0;
  }


/* Drawing code */
long Paint(HWND w)
  {
  PAINTSTRUCT ps;
  HDC dc;
  RECT r;
  HBRUSH wht,gry,br,red,blk,selbrush;
  HPEN whtpen,oldpen;
  LONG x,y;
  dc=BeginPaint(w,&ps);
  GetClientRect(w,&r);
  wht=CreateSolidBrush(RGB(0xFF,0xFF,0xFF));
  gry=CreateSolidBrush(RGB(0x80,0x80,0x80));
  red=CreateSolidBrush(RGB(0xFF,0,0));
  blk=CreateSolidBrush(RGB(0,0,0));
  selbrush=CreateSolidBrush(RGB(0,0xFF,0xFF));
  whtpen=CreatePen(1,PS_SOLID,RGB(0xFF,0xFF,0xFF));
  br=SelectObject(dc,wht);
/* For each cell... */
  for (y=0;y<8;y++)
    for (x=0;x<8;x++)
      {
/* compute bounds */
      int x0=x*75,y0=y*50,x1=(x+1)*75,y1=(y+1)*50;
      BOOL notempty=TRUE;
/* Pick white or grey brush */
      SelectObject(dc,x%2==y%2?wht:gry);
/* Unless selected, then pick selected brush */
      if (selected&&selectp.x==x&&selectp.y==y)
        SelectObject(dc,selbrush);
/* Draw cell */
      Rectangle(dc,x0,y0,x1,y1);
/* Draw piece */
      switch (board[y][x])
        {
        case CELL_RED:
        case CELL_REDKING:
          SelectObject(dc,red);
          break;

        case CELL_BLACK:
        case CELL_BLACKKING:
          SelectObject(dc,blk);
          break;

        default:
          notempty=FALSE;
        }
      if (notempty)
        {
        Ellipse(dc,x0+5,y0+5,x1-5,y1-5);
/* Draw kings */
        if (board[y][x]==CELL_REDKING||board[y][x]==CELL_BLACKKING)
          {
          oldpen=SelectObject(dc,whtpen);
          Ellipse(dc,x0+10,y0+10,x1-10,y1-10);
          SelectObject(dc,oldpen);
          }
        }
      }
  SelectObject(dc,br);
  DeleteObject(blk);
  DeleteObject(wht);
  DeleteObject(red);
  DeleteObject(gry);
  DeleteObject(selbrush);
  DeleteObject(whtpen);
  EndPaint(w,&ps);
  return 0;
  }

/* Handle movement between two cells */
void move(HWND w,LONG x0,LONG y0,LONG x1,LONG y1,BOOL send)
  {
  board[y1][x1]=board[y0][x0];
  board[y0][x0]=CELL_EMPTY;
  InvalidateCell(w,x0,y0);
  InvalidateCell(w,x1,y1);
/* If this isn't a network transaction, send it to
   network partner */
  if (send)
    {
    Send(MOVE,x1,y1,x0,y0,0);
    }
  }

/* Set a cell to a new state */
void setcell(HWND w,LONG x,LONG y,STATE s,BOOL send)
  {
  board[y][x]=s;
  InvalidateCell(w,x,y);
/* If necessary, pass info to net partner */
  if (send)
    {
    Send(SET,x,y,0,0,s);
    }
  }

/* Select a cell */
void selecting(HWND w,LONG x,LONG y)
  {
  PixToCell(&x,&y);  /* Convert to cell */
  if (selected)  /* Move existing selection? */
    {
    selected=FALSE;
    if (selectp.x==x&&selectp.y==y)
      {
      InvalidateCell(w,x,y); /* no move */
      return;
      }
    move(w,selectp.x,selectp.y,x,y,TRUE);
    }
  else
    {   /* new selection or new red piece */
    if (board[y][x]==CELL_EMPTY)
      {
      setcell(w,x,y,CELL_RED,TRUE);
      return;
      }
    selected=TRUE;
    selectp.x=x;
    selectp.y=y;
    InvalidateCell(w,x,y);
    }
  }

/* Mark cell as dirty for painting */
void InvalidateCell(HWND w,LONG x,LONG y)
  {
  RECT r;
  CellToPix(&x,&y);
  r.left=x;
  r.top=y;
  r.right=x+75;
  r.bottom=y+50;
  InvalidateRect(w,&r,FALSE);
  }

/* Convert cell coordinates to pixel coordinates */
void CellToPix(LONG *x,LONG *y)
  {
  *x*=75;
  *y*=50;
  }

/* Convert pixel coordinates to cell coordinates */
void PixToCell(LONG *x,LONG *y)
  {
  *x/=75;
  *y/=50;
  }

/* Perform a right click action */
void action(HWND w,LONG x,LONG y)
  {
  PixToCell(&x,&y);
  if (board[y][x]==CELL_EMPTY)
    {
    setcell(w,x,y,CELL_BLACK,TRUE);    /* Set black cell */
    return;
    }
/* If cell is a king empty it, else make it a king */
  if (board[y][x]==CELL_REDKING||board[y][x]==CELL_BLACKKING)
    setcell(w,x,y,CELL_EMPTY,TRUE);
  else
    setcell(w,x,y,board[y][x]+2,TRUE);
  }

/* Get a file name with common dialog */
int get_file(HWND parent,char *fn,int sz,
  char *title,char *filter,BOOL flag)
  {
  OPENFILENAME of;
  char ft[_MAX_PATH],dir[_MAX_PATH],*p;
  strcpy(dir,fn);
  p=strrchr(dir,'\\');
  if (p) *p='\0'; else *dir='\0';
  memset(&of,0,sizeof(of));
  of.lStructSize=sizeof(of);
  of.hwndOwner=parent;
  of.hInstance=hInst;
  of.lpstrFilter=filter;
  of.nFilterIndex=1;
  of.lpstrFile=fn;
  of.lpstrFileTitle=ft;
  of.nMaxFile=sz;
  of.nMaxFileTitle=_MAX_PATH;
  of.lpstrTitle=title;
  of.lpstrInitialDir=dir;
  if (flag)
    {
    of.Flags=OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT;
    if (!GetSaveFileName(&of)) return 1;
    }
  else
    {
    of.Flags=OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
    if (!GetOpenFileName(&of)) return 1;
    }
  return 0;
  }

