Option Explicit

' Control Set Utility manipulation and
' string routines
'
' by Roy Terry. Version 1.0, 9 July 1995; 

' VB constants
Global Const CASEMATCH = 0
Global Const CASEIGNORE = 1

    ' Control Types returned by csetControlType()
Global Const CT_LIST = 1
Global Const CT_COMBO = 2
Global Const CT_TEXT = 3
Global Const CT_LABEL = 4
Global Const CT_CHECK = 5
Global Const CT_CMD = 6
Global Const CT_GRID = 7
Global Const CT_OPTION = 8
Global Const CT_MENU = 9
Global Const CT_FRAME = 10
Global Const CT_SHAPE = 11
Global Const CT_NONE = -1

Function csetControlType% (c As Control)
     ' Return the type of the passed control
     ' Covers common "built-in" controls.
     ' try to place test in descending frequency order
      csetControlType = CT_NONE
      If c Is Nothing Then Exit Function
      If TypeOf c Is TextBox Then
          csetControlType = CT_TEXT
      ElseIf TypeOf c Is ListBox Then
         csetControlType = CT_LIST
      ElseIf TypeOf c Is ComboBox Then
         csetControlType = CT_COMBO
      ElseIf TypeOf c Is Label Then
         csetControlType = CT_LABEL
      ElseIf TypeOf c Is CheckBox Then
         csetControlType = CT_CHECK
      ElseIf TypeOf c Is CommandButton Then
         csetControlType = CT_CMD
      ElseIf TypeOf c Is OptionButton Then
         csetControlType = CT_OPTION
      ElseIf TypeOf c Is Menu Then
         csetControlType = CT_MENU
      ' enable GRID if you use one in the project
      'ElseIf TypeOf c Is Grid Then
      '   csetControlType = CT_GRID
      ElseIf TypeOf c Is Frame Then
         csetControlType = CT_FRAME
      ElseIf TypeOf c Is Shape Then
         csetControlType = CT_SHAPE
      End If
End Function

Sub csetDisable (f As Form, propName$)
   Dim aValue$, findStat%
   findStat = csetFindFirst(f, propName, aValue)
   Do While findStat
      csetControl.Enabled = False
      findStat = csetFindNext(f, propName, aValue)
   Loop
End Sub

Sub csetEnable (f As Form, propName$)
   Dim aValue$, findStat%
   findStat = csetFindFirst(f, propName, aValue)
   Do While findStat
      csetControl.Enabled = True
      findStat = csetFindNext(f, propName, aValue)
   Loop
End Sub

Function csetEPropNamesExtract$ (ByVal proplst$, returnCount%)
      ' Return a comma-separated string of all property
      ' names contained in the passed string
      ' Set returnCount to equal number of properties found
      ' Useful for development-time reporting
   Dim namelst$
   Dim nameSep$: nameSep = ","

      ' eprops are delimited by ';' and
      ' may or may not have '=' embedded
   Dim iStart%, iEnd%, iEq%, iSemi%
   If Left$(proplst, 1) = ";" Then iStart = 2 Else iStart = 1

   returnCount = 0
   Do While iStart < Len(proplst)
     ' Find end of current prop, then find end of its name
      iSemi = InStr(iStart, proplst, ";", CASEIGNORE)
      If iSemi = 0 Then  'don't require trailing ";" at list end
         iSemi = Len(proplst) + 1
      End If
     ' We've delimited a prop. Now check for equal sign
      iEq = InStr(iStart, proplst, "=", CASEIGNORE)
      If iEq > 0 And iEq < iSemi Then
          iEnd = iEq - 1
      Else
          iEnd = iSemi - 1
      End If
         ' Now Record the property name
      If returnCount > 0 Then
          namelst = namelst & ","
      End If
      namelst = namelst & Mid$(proplst, iStart, iEnd - iStart + 1)
      returnCount = returnCount + 1
      iStart = iSemi + 1
   Loop
   csetEPropNamesExtract = namelst
End Function

Function csetGetStringField$ (ByVal src$, ByVal fnum%, fsep$)
      ' Return contents of string field by counting delimiters
      ' Empty fields (consecutive separators) are honored
   Dim beg%, en%
   beg = 1
      ' don't enter the loop if fnum is 0
   For fnum = (fnum - 1) To 0 Step -1
      beg = InStr(beg, src, fsep) + 1
      If beg = 1 Or beg > Len(src) Then
           csetGetStringField = ""
           Exit Function
      End If
   Next fnum
   en = InStr(beg, src, fsep)
   If en = 0 Then en = Len(src) + 1    ' fetching last field?
      ' copy out the field
   csetGetStringField = Mid$(src, beg, en - beg)
End Function

Sub csetHideInStr (f As Form, propName$, valString$)
      ' for each control, hide/ if val contains valString
   Dim aValue$, findStat%, vis%
   findStat = csetFindFirst(f, propName, aValue)
   Do While findStat
      If InStr(1, aValue, valString, CASEIGNORE) <> 0 Then
          csetControl.Visible = False
      End If
      findStat = csetFindNext(f, propName, aValue)
   Loop
End Sub

Sub csetSyncEnableInstr (f As Form, propName$, valString$)
      ' for each control, if val contains valString enable
   Dim aValue$, findStat%, vis%
   findStat = csetFindFirst(f, propName, aValue)
   Do While findStat
      vis = (InStr(1, aValue, valString, CASEIGNORE) <> 0)
      csetControl.Enabled = vis
      findStat = csetFindNext(f, propName, aValue)
   Loop
End Sub

Sub csetSyncVisibleInstr (f As Form, propName$, valString$)
      ' for set, set visibility by eProp string match
   Dim aValue$, findStat%, vis%
   findStat = csetFindFirst(f, propName, aValue)
   Do While findStat
      vis = (InStr(1, aValue, valString, CASEIGNORE) <> 0)
      csetControl.Visible = vis
      findStat = csetFindNext(f, propName, aValue)
   Loop
End Sub

Sub csetVisibleInstr (f As Form, propName$, valString$)
      ' for each control, show if val contains valString
   Dim aValue$, findStat%, vis%
   findStat = csetFindFirst(f, propName, aValue)
   Do While findStat
      If InStr(1, aValue, valString, CASEIGNORE) <> 0 Then
          csetControl.Visible = True
      End If
      findStat = csetFindNext(f, propName, aValue)
   Loop
End Sub

