Program HintDemo;

{$R HINTDEMO.RES}

Uses WinTypes, { Standard Windows types }
     WinProcs, { Standard Windows procedures }
     Strings,  { String handling routines }
     OValid,   { Validate PWindowsObject routines }
     OWindows, { Windows objects }
     OStdDlgs, { Standard Dialogs objects }
     ODialogs, { Dialog objects }
     Toolbar,  { Toolbar constants }
     OTbarHnt, { Hint Toolbar object }
     OStatLn,  { Status Line Object }
     Win31;    { Redraw window procedure }

Const
   am_FakeMouseMove = wm_User + 201;

   cm_About = 1001;
   cm_ShowToolbar = 2001;
   cm_HideToolbar = 2002;
   cm_ShowStatus = 2003;
   cm_HideStatus = 2004;
   cm_TileHorz = 24350; { cm_TileChildrenHorz }

Type
   TFileName = Array [0..79] Of Char;

   PAboutDlg = ^TAboutDlg;
   TAboutDlg = Object(TDialog)
      Destructor Done; Virtual;
      Procedure WmMenuSelect(Var Msg : TMessage); Virtual wm_First + wm_MenuSelect;
   End;

   PHintFileDlg = ^THintFileDlg;
   THintFileDlg = Object(TFileDialog)
      Destructor Done; Virtual;
      Procedure WmMenuSelect(Var Msg : TMessage); Virtual wm_First + wm_MenuSelect;
   End;

   PHintDisp = ^THintDisp;
   THintDisp =  Object(TWindow)
      Constructor Init(AParent : PWindowsObject; ATitle : PChar);
      Destructor Done; Virtual;
      Function GetClassName : PChar; Virtual;
      Procedure GetWindowClass(Var AWndClass : TWndClass); Virtual;
      Procedure WmMenuSelect(Var Msg : TMessage); Virtual wm_First + wm_MenuSelect;
   End;

   PMdiXtraWindow = ^TMdiXtraWindow;
   TMdiXtraWindow = Object(TMdiWindow)
      Procedure TileChildrenHorz; Virtual;
      Procedure CmTileHorz(Var Msg : TMessage); Virtual cm_First + cm_TileHorz;
   End;

   PHintMain = ^THintMain;
   THintMain = Object(TMdiXtraWindow)
      HintFile : TFileName;
      UseToolbar : Boolean;
      UseStatus : Boolean;
      HintBar : PHintToolBar;
      HintStat : PStatusLine;
      Constructor Init(ATitle : PChar; AMenu : HMenu);
      Procedure SetupWindow; Virtual;
      Function GetClassName : PChar; Virtual;
      Procedure GetWindowClass(Var AWndClass : TWndClass); Virtual;
      Procedure EnableCommand(Command : Word; EnableIt : Boolean);
      Procedure EnableMenu(Pos : Word; EnableIt : Boolean);
      Procedure RedoClientRect;
      Procedure WmSize(Var Msg : TMessage); Virtual wm_First + wm_Size;
      Procedure FileOpen(Var Msg : TMessage); Virtual cm_First + cm_MdiFileOpen;
      Procedure RedrawAllWindows;
      Procedure DoToolbar;
      Procedure DoStatusLine;
      Procedure cmShowToolbar(Var Msg : TMessage); Virtual cm_First + cm_ShowToolbar;
      Procedure cmHideToolbar(Var Msg : TMessage); Virtual cm_First + cm_HideToolbar;
      Procedure cmShowStatus(Var Msg : TMessage); Virtual cm_First + cm_ShowStatus;
      Procedure cmHideStatus(Var Msg : TMessage); Virtual cm_First + cm_HideStatus;
      Procedure CmAbout(Var Msg : TMessage); Virtual cm_First + cm_About;
      Procedure WmFakeMouseMove(Var Msg : TMessage); Virtual wm_First + am_FakeMouseMove;
      Procedure WmMenuSelect(Var Msg : TMessage); Virtual wm_First + wm_MenuSelect;
      Procedure WmShowHint(Var Msg : TMessage); Virtual wm_First + am_ShowHint;
   End;

   THintApp = Object(TApplication)
      Procedure InitMainWindow; Virtual;
   End;


Const
   DisplayCount : Integer = 0;

(*-------------------*)
(* Global procedures *)
(*-------------------*)

Procedure EnableDisplayMenuItems(NewState : Boolean);
(*-------------------------------------------------*)
Begin
   If ValidObj(Application^.MainWindow) Then Begin
      With PHintMain(Application^.MainWindow)^ Do Begin
         EnableCommand(cm_CloseChildren, NewState);
         EnableCommand(cm_ArrangeIcons, NewState);
         EnableMenu(2, NewState); { Window menu }
         EnableMenu(3, NewState); { List menu }
     End;
   End;
End;

Procedure EnableNextPrevItems(NewState : Boolean);
(*----------------------------------------------*)
Begin
   If ValidObj(Application^.MainWindow) Then Begin
      With PHintMain(Application^.MainWindow)^ Do Begin
         EnableCommand(cm_CascadeChildren, NewState);
         EnableCommand(cm_TileChildren, NewState);
         EnableCommand(cm_TileHorz, NewState);
      End;
   End;
End;

Procedure IncDisplays;
(*------------------*)
Begin
   If (DisplayCount = 0) Then EnableDisplayMenuItems(True);
   If (DisplayCount = 1) Then EnableNextPrevItems(True);
   Inc(DisplayCount);
End;

Procedure DecDisplays;
(*------------------*)
Begin
   Dec(DisplayCount);
   If (DisplayCount = 1) Then EnableNextPrevItems(False);
   If (DisplayCount = 0) Then EnableDisplayMenuItems(False);
End;

(*-----------*)
(* TAboutDlg *)
(*-----------*)

Destructor TAboutDlg.Done;
(*----------------------*)
Begin
   SendValidMsg(Parent, am_FakeMouseMove, 0, 0);
   Inherited Done;
End;

Procedure TAboutDlg.WmMenuSelect(Var Msg : TMessage);
(*-------------------------------------------------*)
Begin
   SendValidMsg(Parent, wm_MenuSelect, Msg.WParam, Msg.LParam);
End;

(*--------------*)
(* THintFileDlg *)
(*--------------*)

Destructor THintFileDlg.Done;
(*-------------------------*)
Begin
   SendValidMsg(Parent, am_FakeMouseMove, 0, 0);
   Inherited Done;
End;

Procedure THintFileDlg.WmMenuSelect(Var Msg : TMessage);
(*----------------------------------------------------*)
Begin
   SendValidMsg(Parent, wm_MenuSelect, Msg.WParam, Msg.LParam);
End;

(*----------------*)
(* TMdiXtraWindow *)
(*----------------*)

Procedure TMdiXtraWindow.TileChildrenHorz;
(*--------------------------------------*)
Begin
   SendValidMsg(ClientWnd, wm_MdiTile, $0001, 0);
End;

Procedure TMdiXtraWindow.CmTileHorz(Var Msg : TMessage);
(*----------------------------------------------------*)
Begin
   TileChildrenHorz;
End;

(*-----------*)
(* THintDisp *)
(*-----------*)

Constructor THintDisp.Init(AParent : PWindowsObject; ATitle : PChar);
(*-----------------------------------------------------------------*)
Begin
   Inherited Init(AParent, ATitle);
   IncDisplays;
End;

Destructor THintDisp.Done;
(*-----------------------*)
Begin
   Inherited Done;
   DecDisplays;
End;


Function THintDisp.GetClassName : PChar;
(*-------------------------------------*)
Begin
  GetClassName := 'OwlHintDisplay';
End;

Procedure THintDisp.GetWindowClass(Var AWndClass : TWndClass);
(*----------------------------------------------------------*)
Begin
   Inherited GetWindowClass(AWndClass);
   AWndClass.HIcon := LoadIcon(HInstance, 'HintDemoIcon');
End;

Procedure THintDisp.WmMenuSelect(Var Msg : TMessage);
(*-------------------------------------------------*)
Begin
   SendValidMsg(Parent, wm_MenuSelect, Msg.WParam, Msg.LParam);
End;

(*-----------*)
(* THintMain *)
(*-----------*)

Constructor THintMain.Init(ATitle : PChar; AMenu : HMenu);
(*------------------------------------------------------*)
Begin
   Inherited Init(ATitle, AMenu);
   HintBar := New(PHintToolbar, Init(@Self, 'HintDemoToolBar', tbHorizontal));
   HintStat := New(PStatusLine, Init(@Self));
   UseToolBar := True;
   UseStatus := True;
   ChildMenuPos := 3;
End;

Procedure THintMain.SetupWindow;
(*----------------------------*)
Begin
   Inherited SetupWindow;
   EnableDisplayMenuItems(False);
   EnableNextPrevItems(False);
   DoToolbar;
   DoStatusLine;
End;

Function THintMain.GetClassName : PChar;
(*-------------------------------------*)
Begin
  GetClassName := 'OwlHintMainWindow';
End;

Procedure THintMain.GetWindowClass(Var AWndClass : TWndClass);
(*----------------------------------------------------------*)
Begin
   Inherited GetWindowClass(AWndClass);
   AWndClass.HIcon := LoadIcon(HInstance, 'HintDemoIcon');
End;

Procedure THintMain.EnableCommand(Command : Word; EnableIt : Boolean);
(*------------------------------------------------------------------*)
Var
   StateFlags : Word;

Begin
   If (Attr.Menu <> 0) Then Begin
      If EnableIt Then StateFlags := mf_ByCommand Or mf_Enabled
      Else StateFlags := mf_ByCommand Or mf_Grayed;
      EnableMenuItem(Attr.Menu, Command, StateFlags);
      If ValidObj(HintBar) Then HintBar^.EnableTool(Command, EnableIt);
   End;
End;

Procedure THintMain.EnableMenu(Pos : Word; EnableIt : Boolean);
(*-----------------------------------------------------------*)
Var
   StateFlags : Word;

Begin
   If (Attr.Menu <> 0) Then Begin
      If EnableIt Then StateFlags := mf_ByPosition Or mf_Enabled
      Else StateFlags := mf_ByPosition Or mf_Grayed;
      EnableMenuItem(Attr.Menu, Pos, StateFlags);
      DrawMenuBar(HWindow);
   End;
End;

Procedure THintMain.RedoClientRect;
(*-------------------------------*)
Var
   R : TRect;

   Procedure NotifyChildren(P : PWindow); Far;
   (*---------------------------------------*)
   Begin
      SendValidMsg(P, am_CalcParentClientRect, AllowRepaint, Longint(@R));
   End;

Begin
   GetClientRect(HWindow, R);
   ForEach(@NotifyChildren);
   SetWindowPos(ClientWnd^.HWindow, 0, R.Left, R.Top,
                R.Right - R.Left, R.Bottom - R.Top, swp_NoZOrder);
End;

Procedure THintMain.WmSize(Var Msg : TMessage);
(*-------------------------------------------*)
Var
   R : TRect;

Begin
   If (Scroller <> Nil) And (Msg.WParam <> sizeIconic) Then Scroller^.SetPageSize;
   If (Msg.WParam = sizeNormal) Then Begin
      GetWindowRect(HWindow, R);
      Attr.H := R.Bottom - R.Top;
      Attr.W := R.Right - R.Left;
   End;
   RedoClientRect;
End;

Procedure THintMain.FileOpen(Var Msg : TMessage);
(*---------------------------------------------*)
Var
   Ret : Word;

Begin
   HintFile[0] := #0;
   StrCopy(HintFile, '*.*');
   Ret := Application^.ExecDialog(New(PHintFileDlg, Init(@Self, PChar(sd_FileOpen), HintFile)));
   If (Ret = id_Ok) Then Application^.MakeWindow(New(PHintDisp, Init(@Self, HintFile)));
End;

Procedure THintMain.RedrawAllWindows;
(*---------------------------------*)
Var
   R : TRect;

Begin
   RedoClientRect;
   GetClientRect(HWindow, R);
   RedrawWindow(HWindow, @R, 0, rdw_Invalidate Or rdw_AllChildren Or rdw_UpdateNow Or rdw_NoInternalPaint);
End;


Procedure THintMain.DoToolbar;
(*--------------------------*)
Begin
   If UseToolbar Then Begin
      ModifyMenu(Attr.Menu, cm_ShowToolbar, mf_ByCommand, cm_HideToolbar, 'Hide &Tool Bar');
      If ValidObj(HintBar) Then HintBar^.Show(sw_Show);
   End
   Else Begin
      ModifyMenu(Attr.Menu, cm_HideToolbar, mf_ByCommand, cm_ShowToolbar, 'Show &Tool Bar');
      If ValidObj(HintBar) Then HintBar^.Show(sw_Hide);
   End;
   RedrawAllWindows;
End;

Procedure THintMain.DoStatusLine;
(*-----------------------------*)
Begin
   If UseStatus Then Begin
      ModifyMenu(Attr.Menu, cm_ShowStatus, mf_ByCommand, cm_HideStatus, 'Hide &Status Line');
      If ValidObj(HintBar) Then HintStat^.Show(sw_Show);
   End
   Else Begin
      ModifyMenu(Attr.Menu, cm_HideStatus, mf_ByCommand, cm_ShowStatus, 'Show &Status Line');
      If ValidObj(HintBar) Then HintStat^.Show(sw_Hide);
   End;
   RedrawAllWindows;
End;

Procedure THintMain.cmShowToolbar(Var Msg : TMessage);
(*--------------------------------------------------*)
Begin
   UseToolbar := True;
   DoToolbar;
End;

Procedure THintMain.cmHideToolbar(Var Msg : TMessage);
(*--------------------------------------------------*)
Begin
   UseToolbar := False;
   DoToolbar;
End;

Procedure THintMain.cmShowStatus(Var Msg : TMessage);
(*-------------------------------------------------*)
Begin
   UseStatus := True;
   DoStatusLine;
End;

Procedure THintMain.cmHideStatus(Var Msg : TMessage);
(*-------------------------------------------------*)
Begin
   UseStatus := False;
   DoStatusLine;
End;

Procedure THintMain.CmAbout(Var Msg : TMessage);
(*--------------------------------------------*)
Begin
   Application^.ExecDialog(New(PAboutDlg, Init(@Self, 'HintDialog')));
End;


Procedure THintMain.WmFakeMouseMove(Var Msg : TMessage);
(*----------------------------------------------------*)
Var
   P : TPoint;

Begin
   GetCursorPos(P);
   SendValidMsg(HintBar, wm_MouseMove, 0, LongInt(P));
End;

Procedure THintMain.WmMenuSelect(Var Msg : TMessage);
(*-------------------------------------------------*)
Var
   Cmd : Word;

Begin
   Cmd := 0;
   With Msg Do Begin
      If (LParamLo <> $0ffff) And (LParamHi <> 0) Then Begin { menu not closing }
         If ((LParamLo And mf_Popup) = 0) Then Begin { not a popup! }
            If ((LParamLo And mf_Grayed) = 0) Then Cmd := WParam;
         End;
      End;
   End;
   SendValidMsg(@Self, am_ShowHint, Cmd, 0);
End;


Procedure THintMain.WmShowHint(Var Msg : TMessage);
(*-----------------------------------------------*)
Begin
   If ValidObj(HintStat) Then HintStat^.DisplayString(Msg.WParam);
End;


(*----------*)
(* THintApp *)
(*----------*)

Procedure THintApp.InitMainWindow;
(*------------------------------*)
Begin
   MainWindow := New(PHintMain, Init('Hint Demonstration',
                                     LoadMenu(HInstance, 'MainMenu')));
End;


(***************)
(* Mainprogram *)
(***************)

Var
   Prg : THintApp;

Begin
   Prg.Init('HintApp');
   Prg.Run;
   Prg.Done;
End.
