'***********************************************
'* * *   G L O B A L   C O N S T A N T S   * * *
'***********************************************
'===============================
'   API specific Constants
'===============================
'-------------------------------
'*** GetDeviceCaps() - Device Parameters
'-------------------------------
Global Const LOGPIXELSX = 88    '  Logical pixels/inch in X
Global Const LOGPIXELSY = 90    '  Logical pixels/inch in Y
'-------------------------------
'*** GetSystemMetrics()
'-------------------------------
Global Const SM_CXVSCROLL = 2      'Width of the arrow bmp on a vert scroll bar
Global Const SM_CYCAPTION = 4      'Height of a window caption
Global Const SM_CYMENU = 15        'Height of a single line menu bar
Global Const SM_CXFRAME = 32       'Width of a window frame which can be sized
Global Const SM_CYFRAME = 33       'Height of a window frame which can be sized
'-------------------------------
'*** Text Alignment Options
'-------------------------------
Global Const TA_LEFT = 0
Global Const TA_RIGHT = 2
Global Const TA_CENTER = 6
Global Const TA_TOP = 0
Global Const TA_BOTTOM = 8
Global Const TA_BASELINE = 24

'***********************************************************************
'* * *   G L O B A L   V A R I A B L E   D E C L A R A T I O N S   * * *
'***********************************************************************
'---Default distance units, based on font space...
Global gHStd As Integer
Global gVStd As Integer
'---Twips per pixel (horizontal & vertical)
Global gTwpsPerPxlX As Integer
Global gTwpsPerPxlY As Integer

'***********************************************************
'* * *   D A T A   T Y P E   D E C L A R A T I O N S   * * *
'***********************************************************

Type rtSysMetric
  hgtCapBar As Integer
  hgtFrame As Integer
  wthFrame As Integer
  hgtMenu As Integer
  wthArrow As Integer
End Type
Global gSysMet As rtSysMetric

'*****************************************************************
'* * *   D L L   F U N C T I O N   D E C L A R A T I O N S   * * *
'*****************************************************************
'===============================
'*** API Functions
'===============================
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Function SetTextAlign Lib "GDI" (ByVal hDC As Integer, ByVal wFlags As Integer) As Integer
Declare Function TextOut Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal lpString As String, ByVal nCount As Integer) As Integer

