
Function GetTwpsPerPxlX (f1 As Form) As Integer
  Dim xDPI As Integer
  '---Get display's horizontal dots per logical inch, set gTwpsPerPxlX
  xDPI = GetDeviceCaps(f1.hDC, LOGPIXELSX)
  GetTwpsPerPxlX = 1440 / xDPI
End Function

Function GetTwpsPerPxlY (f1 As Form) As Integer
  Dim xDPI As Integer
  '---Get display's vertical dots per logical inch, set gTwpsPerPxlY
  yDPI = GetDeviceCaps(f1.hDC, LOGPIXELSY)
  GetTwpsPerPxlY = 1440 / yDPI
End Function

Sub Init_Measures (TheForm As Form)
  TheForm.Scalemode = 3
  gTwpsPerPxlX = GetTwpsPerPxlX(TheForm)
  gTwpsPerPxlY = GetTwpsPerPxlY(TheForm)
  SetFont 2, TheForm
  gHStd = TheForm.TextWidth("1")
  gVStd = TheForm.TextHeight("1")
  '---System metrics...
  gSysmet.hgtCapBar = GetSystemMetrics(SM_CYCAPTION)
  gSysmet.hgtFrame = GetSystemMetrics(SM_CYFRAME)
  gSysmet.wthFrame = GetSystemMetrics(SM_CXFRAME)
  gSysmet.hgtMenu = GetSystemMetrics(SM_CYMENU)
  gSysmet.wthArrow = GetSystemMetrics(SM_CXVSCROLL)
End Sub

Sub SetFont (FontType As Integer, TheForm As Form)
  Select Case FontType
  Case 1  'Standard Caption bar type - System 10
    TheForm.FontName = "System"
    TheForm.FontSize = 10
  Case 2  'Standard cmd button type - Helv 8.25
    TheForm.FontName = TheForm.txt(0).FontName  'Helv
    TheForm.FontSize = TheForm.txt(0).FontSize  '8.25
  Case 3  'Small Labels - Helv 10
    TheForm.FontName = "Helv"
    TheForm.FontSize = 10
  Case 4  'Medium Labels - Helv 12
    TheForm.FontName = "Helv"
    TheForm.FontSize = 12
  Case 5  'Large Labels - Helv 14
    TheForm.FontName = "Helv"
    TheForm.FontSize = 14
  End Select
End Sub

