// maindlg.cpp : implementation file
//

#include "stdafx.h"
#include "vctest.h"
#include "maindlg.h"
#include "setprops.h"
#include "commdlg.h"
#include "barcode.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern "C" LPSTR GetLastErrorString(void);
extern "C" int GetLastErrorCode(void);
extern "C" int PrintBarCode(BARCODEPRINTDATA FAR *);

HINSTANCE hVBXInst;
CVBControl *BarCodeVBX;

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog

CMainDlg::CMainDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMainDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMainDlg)
   m_BarCode = NULL;
   m_Edit = "";
   //}}AFX_DATA_INIT
}

void CMainDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMainDlg)
   DDX_VBControl(pDX, IDC_BARCODE1, m_BarCode);
   DDX_Text(pDX, IDC_EDIT1, m_Edit);
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainDlg, CDialog)
   //{{AFX_MSG_MAP(CMainDlg)
   ON_WM_DESTROY()
   ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
   ON_VBXEVENT(VBN_DBLCLICK, IDC_BARCODE1, OnDblclickBarcode1)
   ON_VBXEVENT(VBN_CHANGED, IDC_BARCODE1, OnChangedBarcode1)
   ON_BN_CLICKED(IDB_PRINT, OnClickedPrint)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg message handlers


void CMainDlg::OnDblclickBarcode1(UINT, int, CWnd*, LPVOID)
{     
   BarCodeVBX = m_BarCode;
   
   CSetProps  dlg;
   dlg.DoModal();
}

extern "C" LPSTR GetLastErrorString()
{
   static char Str[81] = "";   
   LPSTR (FAR PASCAL *GetErrorStr) (LPSTR, int) = NULL;
   
   GetErrorStr = (char __far *(__far __pascal *)(LPSTR, int))GetProcAddress(hVBXInst,"BarCodeGetLastErrorStringC");
   
   if(GetLastErrorString != NULL)
      (*GetErrorStr)((LPSTR)Str, 80);
      
   return (LPSTR)Str;
}
      
extern "C" int GetLastErrorCode()
{          
   int retval = 0;
   int (FAR PASCAL *GetErrorCode) (void) = NULL;
   
   GetErrorCode = (int (__far __pascal *)(void))GetProcAddress(hVBXInst,"BarCodeGetLastErrorCode");
   
   if(GetErrorCode != NULL)
      retval = (*GetErrorCode)();
      
   return retval;
}

extern "C" int PrintBarCode(BARCODEPRINTDATA FAR *PrintData)
{          
   int retval = 0;
   int (FAR PASCAL *PrintBarCode) (BARCODEPRINTDATA FAR *) = NULL;
   
   PrintBarCode = (int (__far __pascal *)(BARCODEPRINTDATA FAR *))GetProcAddress(hVBXInst,"BarCodePrint");
   
   if(PrintBarCode != NULL)
      retval = (*PrintBarCode)(PrintData);
      
   return retval;
}

BOOL CMainDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
   
   CenterWindow();
   
   hVBXInst = LoadLibrary("BARCODE.VBX");
   
   m_Edit = "123456";
   m_BarCode->SetStrProperty("Text",m_Edit);
   
   UpdateData(FALSE);
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMainDlg::OnDestroy()
{
   FreeLibrary(hVBXInst);   
   
   CDialog::OnDestroy();   
}

void CMainDlg::OnChangeEdit1()
{
   UpdateData();
   
   m_BarCode->SetStrProperty("Text",m_Edit);

   if(GetLastErrorCode())
      AfxMessageBox(GetLastErrorString());
}

void CMainDlg::OnChangedBarcode1(UINT, int, CWnd*, LPVOID)
{
   UpdateData();
   
   m_Edit = m_BarCode->GetStrProperty("Text");   

   UpdateData(FALSE);
}

void CMainDlg::OnClickedPrint()
{              
   int PrintedOK;
   PRINTDLG pd;
   DOCINFO DocInfo;
   BARCODEPRINTDATA PrintData;
   
   memset(&pd,0,sizeof(pd));
          
   pd.lStructSize = sizeof(PRINTDLG);
   pd.Flags = PD_PRINTSETUP | PD_RETURNDC;
   
   if(PrintDlg(&pd) != 0) {
      
      if(pd.hDC != 0) {
         DocInfo.cbSize = 0;
         DocInfo.lpszDocName = 0;
         DocInfo.lpszOutput = 0;

         PrintData.BarCodeType = (int)m_BarCode->GetNumProperty("BarCodeType");
         PrintData.Checksum = (int)m_BarCode->GetNumProperty("Checksum");
         lstrcpy((LPSTR)PrintData.Text,(LPSTR)(const char *)m_Edit);
         PrintData.x = 0;
         PrintData.y = 0;
         PrintData.Height = 100;
         PrintData.Rotation = 0;
         PrintData.NarrowBarWidth = (int)m_BarCode->GetNumProperty("NarrowBarWidth") * 2;
         PrintData.Ratio = (int)m_BarCode->GetNumProperty("Ratio");
         PrintData.hDCPrinter = (int)pd.hDC;

         StartDoc(pd.hDC, &DocInfo);
         StartPage(pd.hDC);
         PrintedOK = PrintBarCode(&PrintData);
         if(!PrintedOK)
            AfxMessageBox(GetLastErrorString());
         EndPage(pd.hDC);
         EndDoc(pd.hDC);
         DeleteDC(pd.hDC);
         }
      }
}
