VERSION 2.00
Begin Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   5220
   ClientLeft      =   1245
   ClientTop       =   1815
   ClientWidth     =   8175
   FillStyle       =   0  'Solid
   Height          =   5880
   Left            =   1200
   LinkTopic       =   "Form1"
   ScaleHeight     =   5220
   ScaleWidth      =   8175
   Top             =   1200
   Width           =   8265
   Begin CommandButton Command1 
      Caption         =   "Capture Joystick"
      Height          =   315
      Left            =   2760
      TabIndex        =   4
      Top             =   2040
      Width           =   1785
   End
   Begin PictureBox Picture1 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   420
      Left            =   210
      Picture         =   JOYTEST.FRX:0000
      ScaleHeight     =   420
      ScaleWidth      =   420
      TabIndex        =   0
      Top             =   180
      Width           =   420
   End
   Begin Joystick Joystick1 
      Left            =   3900
      Top             =   180
   End
   Begin Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Judy Summers"
      Height          =   255
      Index           =   1
      Left            =   5280
      TabIndex        =   11
      Top             =   480
      Width           =   2655
   End
   Begin Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Zane Thomas"
      Height          =   255
      Index           =   0
      Left            =   5280
      TabIndex        =   10
      Top             =   120
      Width           =   2655
   End
   Begin Label Label6 
      Caption         =   "The property named Period is used to set the amount of time in milliseconds that the joystick driver uses for checking position and button status. The other properties should be more-or-less obvious. You can expirement by setting Capture to True in the Properties Window and changing/observing the other properties. Good Luck!"
      Height          =   765
      Left            =   210
      TabIndex        =   9
      Top             =   4140
      Width           =   7785
   End
   Begin Label Label5 
      Caption         =   "Joystick_ButtonUp( Button As Integer )"
      Height          =   285
      Left            =   360
      TabIndex        =   8
      Top             =   3720
      Width           =   6795
   End
   Begin Label Label4 
      Caption         =   "Joystick_ButtonDown( Button As Integer )"
      Height          =   285
      Left            =   360
      TabIndex        =   7
      Top             =   3300
      Width           =   6705
   End
   Begin Label Label2 
      Caption         =   "Joystick_Move( X As Integer, Y As Integer, Z As Integer)"
      Height          =   285
      Left            =   360
      TabIndex        =   6
      Top             =   2880
      Width           =   6675
   End
   Begin Label Label1 
      Caption         =   "Once the joystick has been captured there are three events that may be generated:"
      Height          =   285
      Index           =   2
      Left            =   240
      TabIndex        =   5
      Top             =   2460
      Width           =   7755
   End
   Begin Label Label1 
      Caption         =   "Before the control will generate events, or update the position properties you must enable it by setting Capture to True. Press the following button to set Capture to True/False. "
      Height          =   495
      Index           =   1
      Left            =   210
      TabIndex        =   3
      Top             =   1470
      Width           =   7815
   End
   Begin Label Label1 
      Caption         =   "Joystick.Vbx contains a fully functional joystick control. Using this control you can easily  respond to joystick movements and button presses."
      Height          =   495
      Index           =   0
      Left            =   210
      TabIndex        =   2
      Top             =   870
      Width           =   7785
   End
   Begin Label Label3 
      Caption         =   "Joystick Control"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   18
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Left            =   810
      TabIndex        =   1
      Top             =   150
      Width           =   2925
   End
   Begin Menu mnucalibrate 
      Caption         =   "&Calibrate"
   End
   Begin Menu mnujoy 
      Caption         =   "&Joystick"
      Begin Menu mnucapture 
         Caption         =   "&Capture"
      End
      Begin Menu mnurelease 
         Caption         =   "&Release"
      End
   End
   Begin Menu mnugame 
      Caption         =   "&Game"
   End
End
Dim lpoint As pointapi

Sub Command1_Click ()
    joystick1.Capture = Not joystick1.Capture
    If (joystick1.Capture) Then
        command1.Caption = "Release Joystick"
    Else
        command1.Caption = "Capture Joystick"
    End If
End Sub

Sub Form_Load ()
command1.Value = True
winxmax = form1.ScaleLeft + form1.ScaleWidth
winxmin = form1.ScaleLeft
winymin = form1.ScaleTop
winymax = form1.ScaleTop + form1.ScaleHeight
mnugame.Enabled = False
mousepointer = 2
xmax = getprivateprofileint("joytest", "xmax", -1, "joytest.ini")
If xmax = -1 Then
    xmax = 10000
    ymax = 10000
    need_calibrate = True
    Exit Sub
End If
xmin = getprivateprofileint("joytest", "xmin", -1, "joytest.ini")

ymax = getprivateprofileint("joytest", "ymax", -1, "joytest.ini")
ymin = getprivateprofileint("joytest", "ymin", -1, "joytest.ini")
deltax = form1.ScaleWidth / xmax
deltay = form1.ScaleHeight / ymax
mnugame.Enabled = True
End Sub

Sub Joystick1_ButtonDown (button As Integer)
    button_mark = True
    Label4.Caption = "Joystick_ButtonDown(" & Str(button) & " )"
    Label4.ForeColor = RGB(255, 0, 0)
    
    If need_calibrate Then Exit Sub
    
    Select Case button
        Case 1
            Circle (winpoint.x, winpoint.y), 80, RGB(0, 0, 0)
            fillcolor = RGB(255, 0, 0)
        Case 2
            Circle (winpoint.x, winpoint.y), 80, RGB(0, 0, 0)
            fillcolor = RGB(0, 255, 0)
    End Select
End Sub

Sub Joystick1_ButtonUp (button As Integer)
    Label5.Caption = "Joystick_ButtonUp(" & Str(button) & " )"
    Label4.ForeColor = 0
End Sub

Sub Joystick1_Move (x As Integer, y As Integer, z As Integer)
    calx = x
    caly = y
    If need_calibrate Then
        Call calibrate(form1)
        If need_calibrate <> True Then
            t = writeprivateprofilestring("joytest", "xmax", ByVal Format$(xmax), "joytest.ini")
            t = writeprivateprofilestring("joytest", "ymax", ByVal Format$(ymax), "joytest.ini")
            t = writeprivateprofilestring("joytest", "xmin", ByVal Format$(xmin), "joytest.ini")
            t = writeprivateprofilestring("joytest", "ymin", ByVal Format$(ymin), "joytest.ini")
        End If
        mnugame.Enabled = True
        Exit Sub
    End If
    label2.Caption = "Joystick1_Move(" & Str(x) & "," & Str(y) & "," & Str(z) & ")"
    
    convert x, y, form1

End Sub

Sub mnucalibrate_Click ()
    xmax = 10000
    ymax = 10000
    need_calibrate = True

End Sub

Sub mnucapture_Click ()
joystick1.Capture = True
End Sub

Sub mnugame_Click ()
joystick1.Capture = False
Unload form1
gameform.Show
End Sub

Sub mnurelease_Click ()
joystick1.Capture = False
End Sub

