VERSION 2.00
Begin Form MultiGrep 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Multi-Grep"
   ClientHeight    =   4935
   ClientLeft      =   1695
   ClientTop       =   2085
   ClientWidth     =   5820
   Height          =   5625
   Left            =   1635
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4935
   ScaleWidth      =   5820
   Top             =   1455
   Width           =   5940
   Begin CheckBox CaseSensitive 
      Caption         =   "Case sensitive?"
      Height          =   375
      Left            =   900
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   4380
      Width           =   1815
   End
   Begin CommandButton ClearAllBtn 
      Caption         =   "Clear All Search/Replace Strings"
      Height          =   315
      Left            =   180
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   3840
      Width           =   5475
   End
   Begin CommandButton ReplaceBtn 
      Caption         =   "&Replace list item"
      Height          =   375
      Left            =   3180
      TabIndex        =   12
      Top             =   960
      Width           =   2475
   End
   Begin CommandButton AddBtn 
      Caption         =   "&Add to list"
      Default         =   -1  'True
      Height          =   375
      Left            =   180
      TabIndex        =   2
      Top             =   960
      Width           =   2475
   End
   Begin TextBox Text1 
      Height          =   285
      Index           =   0
      Left            =   1440
      TabIndex        =   0
      Top             =   240
      Width           =   4275
   End
   Begin TextBox Text1 
      Height          =   285
      Index           =   1
      Left            =   1440
      TabIndex        =   1
      Top             =   600
      Width           =   4275
   End
   Begin Frame Frame1 
      Caption         =   "Search/Replace Strings:"
      Height          =   2835
      Left            =   120
      TabIndex        =   7
      Top             =   1440
      Width           =   5595
      Begin ListBox List2 
         Height          =   1590
         Left            =   3000
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   360
         Width           =   2535
      End
      Begin CommandButton DeleteBtn 
         Caption         =   "&Delete Search/Replace String"
         Height          =   315
         Left            =   60
         TabIndex        =   9
         TabStop         =   0   'False
         Top             =   2040
         Width           =   5475
      End
      Begin ListBox List1 
         Height          =   1590
         Left            =   60
         TabIndex        =   8
         TabStop         =   0   'False
         Top             =   360
         Width           =   2535
      End
      Begin Label Label2 
         Alignment       =   2  'Center
         Caption         =   "="
         Height          =   255
         Left            =   2640
         TabIndex        =   11
         Top             =   960
         Width           =   315
      End
   End
   Begin CommandButton CancelBtn 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   4620
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   4380
      Width           =   1095
   End
   Begin CommandButton GoButton 
      Caption         =   "&Go"
      Height          =   375
      Left            =   3360
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   4380
      Width           =   1095
   End
   Begin Label Label1 
      Caption         =   "Search For:"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   4
      Top             =   240
      Width           =   1215
   End
   Begin Label Label1 
      Caption         =   "Replace With:"
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   10
      Top             =   600
      Width           =   1335
   End
   Begin Menu ID_FILE 
      Caption         =   "File"
      Begin Menu ID_FILE_OPEN 
         Caption         =   "Open"
      End
      Begin Menu ID_FILE_SAVE 
         Caption         =   "Save"
      End
      Begin Menu ID_FILE_SAVEAS 
         Caption         =   "Save As"
      End
      Begin Menu sep1 
         Caption         =   "-"
      End
      Begin Menu ID_FILE_EXIT 
         Caption         =   "Exit"
      End
   End
End
Dim RetrievedFileName As String
Const DEFAULT_DATA_FILE = "c:\multigre.def"

Sub AddBtn_Click ()
    If Text1(0).Text = "" Then
        Text1(0).SetFocus
    Else
        If FoundAlready((Text1(0).Text)) >= 0 Then
            MsgBox "Search string already exists, can't add to list.", 0, APPNAME
        Else
            List1.AddItem (Text1(0).Text)
            List2.AddItem (Text1(1).Text)
            List1.ListIndex = List1.ListCount - 1
            List2.ListIndex = List2.ListCount - 1
            Text1(0).SetFocus
            Text1(0).Text = ""
            Text1(1).Text = ""
        End If
    End If
End Sub

Sub CancelBtn_Click ()
    Tag = "Cancel"
    Hide
End Sub

Sub ClearAllBtn_Click ()
    List1.Clear
    List2.Clear
    RefreshTextBoxes
End Sub

Sub DeleteBtn_Click ()
    DeleteFromListBoxes
    RefreshTextBoxes
End Sub

Sub DeleteFromListBoxes ()
    If List1.ListIndex = -1 Then
        Exit Sub
    End If
    If List1.ListIndex = List1.ListCount - 1 Then
        NewListIndex% = List1.ListCount - 2
    Else
        NewListIndex% = List1.ListIndex
    End If
    List1.RemoveItem List1.ListIndex
    List2.RemoveItem List2.ListIndex
    List1.ListIndex = NewListIndex%
    List2.ListIndex = NewListIndex%
End Sub

Sub Form_Activate ()
    RefreshTextBoxes
End Sub

Sub Form_Load ()
    On Error Resume Next
    If FileExists(DEFAULT_DATA_FILE) Then
        RestoreListBoxes (DEFAULT_DATA_FILE)
        List1.ListIndex = 0
        List2.ListIndex = 0
    End If
End Sub

Function FoundAlready (Target As String) As Integer
    For i% = 0 To (List1.ListCount - 1)
        If List1.List(i%) = Target Then
            FoundAlready = i%
            Exit Function
        End If
    Next i%
    FoundAlready = -1
End Function

Sub GoButton_Click ()
    SaveListBoxes (DEFAULT_DATA_FILE)
    If CaseSensitive.Value = 0 Then
        COMPAREMODE = COMPARE_CASEINSENSITIVE
    End If
    For i% = 0 To (List1.ListCount - 1)
        SearchStr(i%) = List1.List(i%)
        RepStr(i%) = List2.List(i%)
    Next i%
    NumStrings = List1.ListCount
    Tag = "Go"
    Hide
End Sub

Sub ID_FILE_EXIT_Click ()
    End
End Sub

Sub ID_FILE_OPEN_Click ()
    On Error GoTo Cancelled
    FileSave.CMDialog1.CancelError = True
    FileSave.CMDialog1.DefaultExt = ".mtg"
    FileSave.CMDialog1.Filter = "Data Files|*.mtg"
    FileSave.CMDialog1.Action = 1
    RetrievedFileName = FileSave.CMDialog1.Filename
    RestoreListBoxes (RetrievedFileName)
    List1.ListIndex = 0
    List2.ListIndex = 0
    RefreshTextBoxes
    Exit Sub

Cancelled:
    Exit Sub
End Sub

Sub ID_FILE_SAVE_Click ()
    If RetrievedFileName = "" Then
        On Error GoTo ByeBye
        FileSave.CMDialog1.CancelError = True
        FileSave.CMDialog1.Action = 2
        SaveListBoxes (FileSave.CMDialog1.Filename)
    Else
        SaveListBoxes RetrievedFileName
    End If
    Exit Sub

ByeBye:
    Exit Sub
End Sub

Sub ID_FILE_SAVEAS_Click ()
    On Error GoTo Quit
    FileSave.CMDialog1.CancelError = True
    FileSave.CMDialog1.DefaultExt = ".mtg"
    FileSave.CMDialog1.Filter = "Data Files|*.mtg"
    FileSave.CMDialog1.Action = 2
    SaveListBoxes (FileSave.CMDialog1.Filename)
    Exit Sub

Quit:
    Exit Sub
End Sub

Sub List1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    On Error Resume Next
    List2.ListIndex = List1.ListIndex
    RefreshTextBoxes
End Sub

Sub List1_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    On Error Resume Next
    List2.ListIndex = List1.ListIndex
End Sub

Sub List2_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    List1.ListIndex = List2.ListIndex
    RefreshTextBoxes
End Sub

Sub List2_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    List1.ListIndex = List2.ListIndex
End Sub

Sub RefreshTextBoxes ()
    RefreshTextBoxes2
    Text1(0).SetFocus
End Sub

Sub RefreshTextBoxes2 ()
    If List1.ListIndex = -1 Then
        Text1(0).Text = ""
        Text1(1).Text = ""
    End If
    Text1(0).Text = List1.List(List1.ListIndex)
    Text1(1).Text = List2.List(List2.ListIndex)
End Sub

Sub ReplaceBtn_Click ()
    If Text1(0).Text = "" Then
        Text1(0).SetFocus
    Else
        If List1.ListIndex = -1 Then
            MsgBox "No search/replace string selected, can't replace.", 0, APPNAME
            Exit Sub
        End If
        If List1.ListIndex = List1.ListCount - 1 Then
            'Special case, last one in list
            DeleteFromListBoxes
            List1.AddItem (Text1(0).Text)   'add at end
            List2.AddItem (Text1(1).Text)   'add at end
            List1.ListIndex = List1.ListCount - 1
            List2.ListIndex = List2.ListCount - 1
        Else
            DeleteFromListBoxes
            List1.AddItem (Text1(0).Text), List1.ListIndex
            List2.AddItem (Text1(1).Text), List2.ListIndex
        End If
        RefreshTextBoxes
    End If
End Sub

Sub RestoreListBoxes (TheFile As String)
    List1.Clear
    List2.Clear
    RefreshTextBoxes2
    On Error GoTo BadOpn
    FileNum% = FreeFile
    Open TheFile For Input As #FileNum%
    On Error GoTo Finished
    While 1
        Line Input #FileNum%, Temp$
        List1.List(i%) = Temp$
        Line Input #FileNum%, Temp$
        List2.List(i%) = Temp$
        i% = i% + 1
    Wend

BadOpn:
    MsgBox "Error: " & Error$ & " opening file " & TheFile, 0, APPNAME
    Exit Sub

Finished:
    Close #FileNum%
    If List1.ListCount <> List2.ListCount Then
        MsgBox "Invalid data file; number of search strings not same as number of replace strings.", 0, APPNAME
    End If
    Exit Sub
End Sub

Sub SaveListBoxes (TheFile As String)
    On Error GoTo BadOpen
    FileNum% = FreeFile
    Open TheFile For Output As #FileNum%
    On Error GoTo BadWrite
    For i% = 0 To (List1.ListCount - 1)
        Print #FileNum%, List1.List(i%)
        Print #FileNum%, List2.List(i%)
    Next i%
    Close #FileNum%
    Exit Sub

BadOpen:
    MsgBox "Error: " & Error$ & " opening file " & TheFile, 0, APPNAME
    Exit Sub

BadWrite:
    MsgBox "Error: " & Error$ & " accessing file " & TheFile, 0, APPNAME
    Exit Sub
End Sub

Sub Text1_LostFocus (Index As Integer)
    On Error Resume Next
    If Index = 0 Then
        WhereFound% = FoundAlready((Text1(0).Text))
        If WhereFound% >= 0 Then
            List1.ListIndex = WhereFound%
            List2.ListIndex = WhereFound%
            RefreshTextBoxes2
        End If
    End If
End Sub

