Option Explicit

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

' This file provide the APIs, constants, and functions to
' detect file drops on the registered form.

' Using this code requires the use of the MSGBLAST.VBX, or some other
' callback control. (MicroHelp: MHCB200.VBX, Desaware: SBCHOOK.VBX) If
' you use some other callback control, you will need to make some minor
' adjustments to the code, because the parameter names in the events, and
' how you identify the messages you want to watch are different.

Type POINTSTRUCT                        ' API Point structure
    PT_X               As Integer
    PT_Y               As Integer
End Type

Type MSGSTRUCT                          ' API Message structure
    hWnd                As Integer
    message             As Integer
    wParam              As Integer
    lParam              As Long
    time                As Long
    pt                  As POINTSTRUCT
End Type

Global Const WM_SYSCOMMAND = &H112
Global Const WM_DROPFILES = &H233

Declare Sub APIDragAcceptFiles Lib "Shell" Alias "DragAcceptFiles" (ByVal hWnd As Integer, ByVal fAccept As Integer)
Declare Function APIDragQueryFile Lib "Shell" Alias "DragQueryFile" (ByVal hDrop As Integer, ByVal iFile As Integer, ByVal lpszFile As String, ByVal cb As Integer) As Integer
Declare Sub APIDragFinish Lib "Shell" Alias "DragFinish" (ByVal hDrop As Integer)
Declare Function APIPeekMessage Lib "User" Alias "PeekMessage" (lpMsg As MSGSTRUCT, ByVal hWnd As Integer, ByVal wMsgFilterMin As Integer, ByVal wMsgFilterMax As Integer, ByVal wRemoveMsg As Integer) As Integer
Declare Function APIGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

Global Const MF_BYCOMMAND = &H0
Global Const MF_APPEND = &H100
Global Const MF_SEPARATOR = &H800
Global Const MF_ENABLED = &H0
Global Const MF_STRING = &H0

Global Const MB_ICONINFORMATION = 64

Global Const IDM_ABOUT = 108

Declare Function APIGetSystemMenu Lib "User" Alias "GetSystemMenu" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
Declare Function APIDeleteMenu Lib "User" Alias "DeleteMenu" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
Declare Function APIAppendMenu Lib "User" Alias "AppendMenu" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer

Sub APP_About ()

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.
    
    Dim tTempStr            As String
    Dim tCRLF               As String
	
    tCRLF = Chr$(13) & Chr$(10)
    tTempStr = "Copyright  1994 by Computer Technologies, Inc." & tCRLF & "All rights reserved."
    tTempStr = tTempStr & tCRLF & tCRLF & "Version 1.0 - Released October 11, 1994."
    tTempStr = tTempStr & tCRLF & tCRLF & "This demo program and all associated code is the property of Computer Technologies, Inc. It is provided as a service for the personal use of the members of the MS-BASIC forum on CompuServe, and other interested Visual Basic developers."
    tTempStr = tTempStr & tCRLF & tCRLF & "Author:" & Chr$(9) & "Eric Brierley"
    tTempStr = tTempStr & tCRLF & "CIS:" & Chr$(9) & "71163,2657"
    tTempStr = tTempStr & tCRLF & "Phone:" & Chr$(9) & "1-704-634-1766"
    MsgBox tTempStr, MB_ICONINFORMATION, "About Dust Bin"

End Sub

Sub APP_DeleteFiles (tFileNames As String)

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim nResult             As Integer
    Dim tOneFile            As String
    Dim nLoopCtr            As Integer

    tOneFile = UT_GetStringToken(tFileNames, 1, ",")
    
    nLoopCtr = 1
    Do While Len(tOneFile) > 0
	nResult = UT_FileDelete(tOneFile)
	nLoopCtr = nLoopCtr + 1
	tOneFile = UT_GetStringToken(tFileNames, nLoopCtr, ",")
    Loop

End Sub

Function UT_DropEnable (hHandle As Integer, ctlCallback As Control, nFirstMsg As Integer, bFlag As Integer) As Integer

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

' Calling Parameters:
'   hHandle         Window handle (hWnd) of the form or control that is to
'                   accept file drops
'   ctlCallback     The callback control
'   nFirstMsg       Pointer to first free message list entry
'   bFlag           * Reserved for future use to enable or disable drag/drop

' Returned:
'   Pointer to the last message list entry used.

    Dim nMsgCounter         As Integer

' Subclass the form if needed, then register the message we want to see.
' *** This code will need to be adjusted callback other than MSGBLAST.
    nMsgCounter = nFirstMsg
    If nMsgCounter = 0 Then ctlCallback.hWndTarget = hHandle
    ctlCallback.MsgList(nMsgCounter) = WM_DROPFILES

' Make the API call to tell the system that we will accept
' files dropped from other applications.
    APIDragAcceptFiles hHandle, True

' Set the return value to the last message pointer used
    UT_DropEnable = nMsgCounter
    
End Function

Function UT_DropFileNames (MsgVal As Integer, wParam As Integer, lParam As Long) As String

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

' Calling Parameters:
'   MsgVal          Windows message number associated with the file drop
'   wParam          First message paramter contains drop message handle

' Returned:
'   A comma delimited list of the dropped file names

    Dim nFileCount          As Integer
    Dim nLoopCtr            As Integer
    Dim nResult             As Integer
    Dim hDrop               As Integer
    Dim tFileName           As String
    Dim tTempStr            As String

    tFileName = ""
    hDrop = wParam                      ' Handle of internal file structure
    tTempStr = Space$(255)              ' Preallocate return storage

' Get the number of file names dropped
    nFileCount = APIDragQueryFile(hDrop, -1, tTempStr, 254)
    
' For each file get the file name and add it to our working string. The
' API call return value is the number of characters in the file name.
    For nLoopCtr = 0 To nFileCount - 1
	tTempStr = Space$(255)              ' Preallocate return storage
	nResult = APIDragQueryFile(hDrop, nLoopCtr, tTempStr, 254)
	' If this is not the first file name append a delimiter
	If tFileName <> "" Then tFileName = tFileName & ","
	tFileName = tFileName & Left$(tTempStr, nResult)
    Next nLoopCtr
    
    APIDragFinish hDrop                 ' Release memory used for filenames

    UT_DropFileNames = tFileName        ' Pass back the file list

End Function

Function UT_FileDelete (tFileName As String) As Integer

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim nError          As Integer

    On Error Resume Next
    Kill tFileName
    nError = Err
    On Error GoTo 0

    If nError <> 0 Then
    UT_FileDelete = nError
      Else
    UT_FileDelete = True
    End If

End Function

Function UT_GetStringToken (tInString As String, nPosition As Integer, tDelimStr As String) As String

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim nHits               As Integer
    Dim tTempStr            As String

    tTempStr = tInString

    nHits = 1
    If nPosition < nHits Then
    Exit Function
    End If
    Do While nHits <> nPosition And Len(tInString) > 1
    If Mid$(tTempStr, 1, 1) = tDelimStr Then
	nHits = nHits + 1
    End If
    tTempStr = Mid$(tTempStr, 2)
    If tTempStr = "" Then
	UT_GetStringToken = ""
	Exit Function
    End If
    Loop
    If InStr(1, tTempStr, tDelimStr) > 0 Then
    UT_GetStringToken = Mid$(tTempStr, 1, InStr(1, tTempStr, tDelimStr) - 1)
      Else
    UT_GetStringToken = tTempStr
    End If

End Function

