
#include "windows.h"
#include "commdlg.h"
#include "vbapi.h"

LONG FAR PASCAL _export LabelWndProc( HCTL, HWND, WORD, WORD, LONG );
void PaintButton( HCTL, HWND );
BOOL _export FAR PASCAL SetColor( HWND, WORD, WORD, LONG );
LONG _export FAR PASCAL PopupWndProc( HWND, WORD, WORD, LONG );

typedef struct {
   HSZ WaveFile;
   int WaveStyle;
   int Width, Height, WaveOn;
   int Raised, Align, WaveLoop;
   int Shadow, Border;
   int BWidth, VAlign;
   long ShadowColor;
   HFONT hFont;
   HSZ hszCaption;
} GPSTRUCT;

#define DEREF(hctl) ((GPSTRUCT far *)VBDerefControl(hctl))

char MMSystem[] = "MMSYSTEM.DLL";

char szAlignTypes[] = "0 - Left\0"\
                      "1 - Center\0"\
                      "2 - Right\0"
                      "\0";

char szVAlignTypes[] = "0 - Top\0"\
                     "1 - Center\0"\
                     "2 - Bottom\0"\
                     "\0";

char szWaveStyle[] = "0 - Synchronous\0"\
                     "1 - Asynchronous\0"\
                     "";

PROPINFO Prop_WaveFile =
{
   "WaveFile",
   DT_HSZ | PF_fSetData | PF_fGetData | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_WaveStyle =
{
   "WaveStyle",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, szWaveStyle, 2
};

PROPINFO Prop_Align =
{
   "AlignHor",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, szAlignTypes, 2
};

PROPINFO Prop_VAlign =
{
   "AlignVert",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, szVAlignTypes, 2
};

PROPINFO Prop_Width =
{
   "Width",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Height =
{
   "Height",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   2, 0, NULL, 0
};

PROPINFO Prop_Raised =
{
   "Raised",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   4, 0, NULL, 0
};

PROPINFO Prop_Shadow =
{
   "TextShadow",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   6, 0, NULL, 0
};

PROPINFO Prop_ShadowColor =
{
   "TextShadowCol",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   8, 0, NULL, 0
};

PROPINFO Prop_Border =
{
   "Border",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_BorderSize =
{
   "BorderWidth",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_WaveLoop =
{
   "WaveLoop",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_WaveEnabled =
{
   "WaveEnabled",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Version =
{
   "Version",
   DT_SHORT | PF_fGetMsg,
   0, 0, NULL, 0
};

PPROPINFO proplistGP[] =
{
   PPROPINFO_STD_CAPTION,
   PPROPINFO_STD_CTLNAME,
   PPROPINFO_STD_BACKCOLOR,
   PPROPINFO_STD_FORECOLOR,
   PPROPINFO_STD_LEFT,
   PPROPINFO_STD_TOP,
   PPROPINFO_STD_FONTNAME,
   PPROPINFO_STD_FONTBOLD,
   PPROPINFO_STD_FONTITALIC,
   PPROPINFO_STD_FONTSTRIKE,
   PPROPINFO_STD_FONTUNDER,
   PPROPINFO_STD_FONTSIZE,
   &Prop_Height,
   &Prop_Width,
   &Prop_Raised,
   &Prop_Shadow,
   &Prop_ShadowColor,
   &Prop_Align,
   &Prop_Border,
   &Prop_BorderSize,
   &Prop_VAlign,
   &Prop_WaveFile,
   &Prop_WaveStyle,
   &Prop_WaveLoop,
   &Prop_WaveEnabled,
   &Prop_Version,
   NULL
};

#define PROP_HEIGHT        12
#define PROP_WIDTH         13
#define PROP_RAISED        14
#define PROP_SHADOW        15
#define PROP_SHADOWCOLOR   16
#define PROP_ALIGN         17
#define PROP_BORDER        18
#define PROP_BORDERSIZE    19
#define PROP_VALIGN        20
#define PROP_WAVEFILE      21
#define PROP_WAVESTYLE     22
#define PROP_WAVELOOP      23
#define PROP_WAVEENABLED   24
#define PROP_VERSION       25

EVENTINFO Event_Clicked =
{
   "Clicked", 0, 0,
   NULL, NULL
};

PEVENTINFO eventlistGP[] =
{
   &Event_Clicked,
   NULL
};


MODEL modelGP =
{
   VB_VERSION,
   MODEL_fChildrenOk | MODEL_fMnemonic,
   (PCTLPROC)LabelWndProc,
   NULL,
   WS_CHILD | WS_CLIPCHILDREN | BS_OWNERDRAW,
   sizeof(GPSTRUCT),
   8000,
   "Label3D",
   "Label3D",
   "button",
   proplistGP,
   eventlistGP
};

char *CLASSPOPUP = "CPopup";

HANDLE hmodDLL;
HCTL ColorHctl;
HWND ColorHwnd;
WORD ColorID;


BOOL FAR PASCAL LibMain( HANDLE hmod, HANDLE segDS, USHORT cbHeapSize )
{
   hmodDLL = hmod;

   UnlockData( 0 );
   return( TRUE );
}


BOOL FAR PASCAL _export VBINITCC( USHORT usVersion, BOOL fRunTime )
{
   if( ! fRunTime )
   {
      WNDCLASS wc;

      wc.style = 0;
      wc.lpfnWndProc = (WNDPROC)PopupWndProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = hmodDLL;
      wc.hIcon = NULL;
      wc.hCursor = NULL;
      wc.hbrBackground = NULL;
      wc.lpszMenuName = NULL;
      wc.lpszClassName = CLASSPOPUP;

      if( ! RegisterClass( &wc ) )
         return( FALSE );
   }
   return( VBRegisterModel( hmodDLL, &modelGP ) );
}


LONG FAR PASCAL _export LabelWndProc( HCTL hCtl, HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_CREATE:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         Gp->Width = 50;
         Gp->Height = 30;
         Gp->Raised = 1;
         Gp->Shadow = 0;
         Gp->ShadowColor = 0L;
         Gp->hszCaption = NULL;
         Gp->Border = -1;
         Gp->BWidth = 2;
         Gp->Align = Gp->VAlign = 0;
         break;
      }

      case WM_SETFONT:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         Gp->hFont = wParam;
         PaintButton( hCtl, hWnd );
         break;
      }

      case WM_GETFONT:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         return( Gp->hFont );
      }

      case WM_SETTEXT:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );
         HSZ hsz;

         if( Gp->hszCaption )
            VBDestroyHsz( Gp->hszCaption );

         hsz = VBCreateHsz( (_segment)hCtl, (LPSTR)lParam );
         Gp = DEREF( hCtl );

         Gp->hszCaption = hsz;
         PaintButton( hCtl, hWnd );
         return( NULL );
      }

      case WM_GETTEXT:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );
         LPSTR lpStr;
         WORD cch;

         if( Gp->hszCaption == NULL )
         {
            *(LPSTR)lParam = 0L;
            wParam = 1;
         }
         else
         {
            lpStr = VBDerefHsz( Gp->hszCaption );
            cch = lstrlen( lpStr ) + 1;
            if( wParam > cch )
               wParam = cch;

            lstrcpy( (LPSTR)lParam, lpStr );
         }
         return( (LONG)( wParam - 1 ) );
      }

      case WM_GETTEXTLENGTH:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         if( Gp->hszCaption == NULL )
            return( 0L );

         return( lstrlen( VBDerefHsz( Gp->hszCaption ) ) );
      }

      case WM_SIZE:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         Gp->Width = LOWORD( lParam );
         Gp->Height = HIWORD( lParam );
         PaintButton( hCtl, hWnd );
         break;
      }

      case WM_PAINT:
      {
         PAINTSTRUCT Ps;

         BeginPaint( hWnd, &Ps );
         PaintButton( hCtl, hWnd );
         EndPaint( hWnd, &Ps );
         break;
      }

      case WM_LBUTTONDOWN:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );
         WORD WinVer;
         LPSTR lpStr;
         HANDLE hMM;
         FARPROC lpfnSndPlaySound;

         if( Gp->WaveOn )
         {
            WinVer = GetVersion();
            if( HIBYTE( WinVer ) >= 10 && LOBYTE( WinVer ) >= 3 )
            {
               lpStr = VBDerefHsz( Gp->WaveFile );
               if( lstrlen( lpStr ) )
               {
                  hMM = LoadLibrary( MMSystem );
                  if( hMM )
                  {
                     lpfnSndPlaySound = GetProcAddress( hMM, (LPSTR)(DWORD)2 );
                     if( lpfnSndPlaySound )
                     {
                        if( Gp->WaveStyle == 2 )
                           ( *lpfnSndPlaySound )( (LPSTR)lpStr, (int)8 );
                        else
                           ( *lpfnSndPlaySound )( (LPSTR)lpStr, (int)Gp->WaveStyle );
                     }
                  }
               }
            }
         }

         VBFireEvent( hCtl, 0, NULL );
         break;
      }

      case VBM_GETPROPERTY:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         switch( wParam )
         {
            case PROP_HEIGHT:
               *(WORD far *)lParam = Gp->Height;
               return( FALSE );

            case PROP_WIDTH:
               *(WORD far *)lParam = Gp->Width;
               return( FALSE );

            case PROP_RAISED:
               *(WORD far *)lParam = Gp->Raised;
               return( FALSE );

            case PROP_SHADOW:
               *(WORD far *)lParam = Gp->Shadow;
               return( FALSE );

            case PROP_SHADOWCOLOR:
               *(LONG FAR *)lParam = Gp->ShadowColor;
               return( FALSE );

            case PROP_ALIGN:
               *(BOOL far *)lParam = Gp->Align;
               return( FALSE );

            case PROP_BORDER:
               *(BOOL far *)lParam = Gp->Border;
               return( FALSE );

            case PROP_BORDERSIZE:
               *(WORD far *)lParam = Gp->BWidth;
               return( FALSE );

            case PROP_VALIGN:
               *(WORD far *)lParam = Gp->VAlign;
               return( FALSE );

            case PROP_WAVESTYLE:
               *(WORD far *)lParam = Gp->WaveStyle;
               return( FALSE );

            case PROP_WAVELOOP:
               *(WORD far *)lParam = Gp->WaveLoop;
               return( FALSE );

            case PROP_WAVEENABLED:
               *(WORD far *)lParam = Gp->WaveOn;
               return( FALSE );

            case PROP_VERSION:
               *(WORD far *)lParam = 100;
               return( FALSE );
         }
         break;
      }

      case VBM_SETPROPERTY:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         switch( wParam )
         {
            case PROP_HEIGHT:
               Gp->Height = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_WIDTH:
               Gp->Width = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_RAISED:
               Gp->Raised = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_SHADOW:
               Gp->Shadow = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_SHADOWCOLOR:
               Gp->ShadowColor = lParam;
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_ALIGN:
               Gp->Align = lParam;
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_BORDER:
               Gp->Border = (BOOL)lParam;
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_BORDERSIZE:
               Gp->BWidth = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_VALIGN:
               Gp->VAlign = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case PROP_WAVESTYLE:
               Gp->WaveStyle = LOWORD( lParam );
               return( FALSE );

            case PROP_WAVELOOP:
               Gp->WaveLoop = LOWORD( lParam );
               return( FALSE );

            case PROP_WAVEENABLED:
               Gp->WaveOn = LOWORD( lParam );
               return( FALSE );
         }
         break;
      }

      case VBM_INITPROPPOPUP:
      {
         GPSTRUCT far *Gp = DEREF( hCtl );

         switch( wParam )
         {
            case 2:
            case 3:
            case PROP_SHADOWCOLOR:
            case PROP_WAVEFILE:
            {
               FARPROC DlgProc;

               if( VBGetMode() == MODE_DESIGN )
               {
                  ColorHctl = hCtl;
                  ColorID = wParam;
                  ColorHwnd = hWnd;

                  return( CreateWindow( CLASSPOPUP, NULL, WS_POPUP, 0, 0, 0, 0,
                                        NULL, NULL, hmodDLL, NULL ) );
               }
               return( NULL );
            }
         }
         break;
      }
   }
   return( VBDefControlProc( hCtl, hWnd, msg, wParam, lParam ) );
}

LONG _export FAR PASCAL PopupWndProc( HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_SHOWWINDOW:
         if( wParam )
         {
            PostMessage( hWnd, WM_USER, 0, 0L );
            return( 0L );
         }
         break;

      case WM_USER:
         if( ColorID == PROP_WAVEFILE )
         {
            GPSTRUCT far *Gp = DEREF( ColorHctl );
            OPENFILENAME Of;
            HSZ hsz;
            char str[ 128 ];

            lstrcpy( str, "*.WAV" );
            Of.lStructSize = sizeof(OPENFILENAME);
            Of.hwndOwner = hWnd;
            Of.hInstance = (HANDLE)NULL;
            Of.lpstrFilter = "Wave Files  (*.WAV)\0*.WAV\0All Files   (*.*)\0*.*\0\0";
            Of.lpstrCustomFilter = (LPSTR)NULL;
            Of.nMaxCustFilter = (DWORD)0;
            Of.nFilterIndex = (DWORD)0;
            Of.lpstrFile = str;
            Of.nMaxFile = (DWORD)128;
            Of.lpstrFileTitle = (LPSTR)NULL;
            Of.nMaxFileTitle = (DWORD)NULL;
            Of.lpstrInitialDir = (LPSTR)NULL;
            Of.lpstrTitle = "Attach Wave File...";
            Of.Flags = (DWORD)NULL;
            Of.nFileOffset = 0;
            Of.nFileExtension = 0;
            Of.lpstrDefExt = (LPSTR)NULL;
            Of.lCustData = NULL;
            Of.lpfnHook = NULL;
            Of.lpTemplateName = (LPSTR)NULL;

            if( GetOpenFileName( &Of ) )
               VBSetControlProperty( ColorHctl, PROP_WAVEFILE, (LONG)(LPSTR)str );
            return( 0L );
         }
         VBDialogBoxParam( hmodDLL, "SETCOLOR", MakeProcInstance( SetColor, hmodDLL ), 0L );
         return( 0L );
   }
   return( DefWindowProc( hWnd, msg, wParam, lParam ) );
}



BOOL _export FAR PASCAL SetColor( HWND hDlg, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         GPSTRUCT far *Gp = DEREF( ColorHctl );
         WORD Red, Green, Blue;
         DWORD dwColor;
         char str[ 6 ];

         VBGetControlProperty( ColorHctl, ColorID, &dwColor );
         if( dwColor & 0x80000000L )
            dwColor = GetSysColor( LOWORD( dwColor ) + 1 );

         Red = GetRValue( dwColor );
         Green = GetGValue( dwColor );
         Blue = GetBValue( dwColor );

         SetProp( hDlg, MAKEINTRESOURCE( 1 ), CreateSolidBrush( RGB ( Red, Green, Blue ) ) );

         SetScrollRange( GetDlgItem( hDlg, 100 ), SB_CTL, 0, 255, TRUE );
         SetScrollRange( GetDlgItem( hDlg, 102 ), SB_CTL, 0, 255, TRUE );
         SetScrollRange( GetDlgItem( hDlg, 104 ), SB_CTL, 0, 255, TRUE );

         SetScrollPos( GetDlgItem( hDlg, 100 ), SB_CTL, Red, TRUE );
         SetScrollPos( GetDlgItem( hDlg, 102 ), SB_CTL, Green, TRUE );
         SetScrollPos( GetDlgItem( hDlg, 104 ), SB_CTL, Blue, TRUE );

         wsprintf( str, "%d", Red );
         SetDlgItemText( hDlg, 101, str );
         wsprintf( str, "%d", Green );
         SetDlgItemText( hDlg, 103, str );
         wsprintf( str, "%d", Blue );
         SetDlgItemText( hDlg, 105, str );
         return( TRUE );
      }

      case WM_DRAWITEM:
      {
         LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;

         if( lpDs->CtlID == 106 )
         {
            RECT Rect;
            HDC hDC;

            hDC = GetDC( GetDlgItem( hDlg, lpDs->CtlID ) );
            SelectObject( hDC, GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
            GetWindowRect( GetDlgItem( hDlg, lpDs->CtlID ), &Rect );
            Rectangle( hDC, 0, 0, Rect.right - Rect.left, Rect.bottom - Rect.top );
            SelectObject( lpDs->hDC, GetStockObject( NULL_BRUSH ) );
         }
         break;
      }

      case WM_HSCROLL:
      {
         DWORD dwColor;
         int Pos;
         char str[ 10 ];
         int junk;

         Pos = GetScrollPos( HIWORD( lParam ), SB_CTL );

         switch( wParam )
         {
            case SB_BOTTOM:
               SetScrollPos( HIWORD( lParam ), SB_CTL, 0, TRUE );
               break;

            case SB_TOP:
               SetScrollPos( HIWORD( lParam ), SB_CTL, 255, TRUE );
               break;

            case SB_THUMBPOSITION:
            case SB_THUMBTRACK:
               SetScrollPos( HIWORD( lParam ), SB_CTL, LOWORD( lParam ), TRUE );
               break;

            case SB_PAGEDOWN:
               if( Pos > 240 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, 255, TRUE );
               else
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos + 16, TRUE );
               break;

            case SB_PAGEUP:
               if( Pos < 16 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, 0, TRUE );
               else
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos - 16, TRUE );
               break;

            case SB_LINEDOWN:
               if( Pos < 255 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos + 1, TRUE );
               break;

            case SB_LINEUP:
               if( Pos > 0 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos - 1, TRUE );
               break;
         }

         wsprintf( str, "%d", GetScrollPos( GetDlgItem( hDlg, 100 ), SB_CTL ) );
         SetDlgItemText( hDlg, 101, str );

         wsprintf( str, "%d", GetScrollPos( GetDlgItem( hDlg, 102 ), SB_CTL ) );
         SetDlgItemText( hDlg, 103, str );

         wsprintf( str, "%d", GetScrollPos( GetDlgItem( hDlg, 104 ), SB_CTL ) );
         SetDlgItemText( hDlg, 105, str );

         dwColor = RGB( GetDlgItemInt( hDlg, 101, &junk, TRUE ),
                        GetDlgItemInt( hDlg, 103, &junk, TRUE ),
                        GetDlgItemInt( hDlg, 105, &junk, TRUE ) );

         DeleteObject( GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
         SetProp( hDlg, MAKEINTRESOURCE( 1 ), CreateSolidBrush( dwColor ) );

         InvalidateRect( GetDlgItem( hDlg, 106 ), NULL, FALSE );
         break;
      }

      case WM_COMMAND:
         if( HIWORD( lParam ) == EN_KILLFOCUS )
         {
            DWORD dwColor;
            int junk;

            dwColor = RGB( GetDlgItemInt( hDlg, 101, &junk, TRUE ),
                           GetDlgItemInt( hDlg, 103, &junk, TRUE ),
                           GetDlgItemInt( hDlg, 105, &junk, TRUE ) );

            DeleteObject( GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
            SetProp( hDlg, MAKEINTRESOURCE( 1 ), CreateSolidBrush( dwColor ) );

            InvalidateRect( GetDlgItem( hDlg, 106 ), NULL, FALSE );
            break;
         }

         if( wParam == IDOK || wParam == IDCANCEL )
         {
            if( wParam == IDOK )
            {
               int junk;
               DWORD dwColor;
               GPSTRUCT far *Gp = DEREF( ColorHctl );

               dwColor = RGB( GetDlgItemInt( hDlg, 101, &junk, TRUE ),
                              GetDlgItemInt( hDlg, 103, &junk, TRUE ),
                              GetDlgItemInt( hDlg, 105, &junk, TRUE ) );

               VBSetControlProperty( ColorHctl, ColorID, dwColor );

            }

            DeleteObject( GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
            RemoveProp( hDlg, MAKEINTRESOURCE( 1 ) );

            if( wParam == IDOK )
               InvalidateRect( ColorHwnd, NULL, TRUE );

            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}

void PaintButton( HCTL hCtl, HWND hWnd )
{
   GPSTRUCT far *Gp = DEREF( hCtl );
   HDC hDC;
   HBRUSH hBk;
   int Offset;
   WORD len;
   TEXTMETRIC tm;
   long OldColor;
   LPSTR lpStr;
   RECT Rect;

   hDC = GetDC( hWnd );

   hBk = (HBRUSH)SendMessage( GetParent( hWnd ), WM_CTLCOLOR, hDC, MAKELONG( hWnd, 0 ) );

   if( Gp->Border )
      SelectObject( hDC, GetStockObject( BLACK_PEN ) );
   else
      SelectObject( hDC, CreatePen( PS_SOLID, 1, GetBkColor( hDC  ) ) );

   SelectObject( hDC, hBk );
   Rectangle( hDC, 0, 0, Gp->Width, Gp->Height );
   if( ! Gp->Border )
      DeleteObject( SelectObject( hDC, GetStockObject( NULL_PEN ) ) );

   if( Gp->BWidth )
   {
      Offset = 1;

      if( Gp->Raised )
         SelectObject( hDC, GetStockObject( WHITE_PEN ) );
      else
         SelectObject( hDC, CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ) );

      while( Offset <= Gp->BWidth )
      {
         MoveTo( hDC, Gp->Width - Offset - 1, Offset );
         LineTo( hDC, Offset, Offset );
         LineTo( hDC, Offset, Gp->Height - Offset );
         ++Offset;
      }

      if( Gp->Raised )
         SelectObject( hDC, CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ) );
      else
         DeleteObject( SelectObject( hDC, GetStockObject( WHITE_PEN ) ) );

      Offset = 1;

      while( Offset <= Gp->BWidth )
      {
         MoveTo( hDC, Offset + 1, Gp->Height - Offset - 1 );
         LineTo( hDC, Gp->Width - Offset - 1, Gp->Height - Offset - 1 );
         LineTo( hDC, Gp->Width - Offset - 1, Offset );
         ++Offset;
      }

      if( Gp->Raised )
         DeleteObject( SelectObject( hDC, GetStockObject( NULL_PEN ) ) );
   }

   if( Gp->hszCaption )
   {
      lpStr = VBDerefHsz( Gp->hszCaption );

      if( Gp->hFont )
         SelectObject( hDC, Gp->hFont );

      len = (WORD)GetTextExtent( hDC, lpStr, lstrlen( lpStr ) );
      GetTextMetrics( hDC, &tm );

      switch( Gp->Align )
      {
         case 0:
            Rect.left = Gp->BWidth + 2;
            Rect.right = Rect.left + len;
            break;

         case 1:
            Rect.left = ( Gp->Width - len ) / 2;
            Rect.right = Rect.left + len;
            break;

         case 2:
            Rect.right = Gp->Width - Gp->BWidth - 2;
            Rect.left = Rect.right - len;
            break;
      }

      switch( Gp->VAlign )
      {
         case 0:
            Rect.top = Gp->BWidth + 3;
            Rect.bottom = Rect.top + tm.tmHeight;
            break;

         case 1:
            Rect.top = ( Gp->Height - tm.tmHeight ) / 2 + 1;
            Rect.bottom = Rect.top + tm.tmHeight;
            break;

         case 2:
            Rect.bottom = Gp->Height - Gp->BWidth - 3;
            Rect.top = Rect.bottom - tm.tmHeight;
            break;
      }

      if( lstrlen( lpStr ) );
      {
         if( Gp->Shadow )
         {
            OldColor = GetTextColor( hDC );

            SetBkMode( hDC, OPAQUE );
            SetTextColor( hDC, Gp->ShadowColor );

            Offset = -1;

            Rect.top += Offset;
            Rect.bottom += Offset;
            Rect.left += Offset;
            Rect.right += Offset;

            DrawText( hDC, lpStr, lstrlen( lpStr ), &Rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE );

            Rect.top -= Offset;
            Rect.bottom -= Offset;
            Rect.left -= Offset;
            Rect.right -= Offset;

            SetTextColor( hDC, OldColor );
            SetBkMode( hDC, TRANSPARENT );
         }
         DrawText( hDC, lpStr, lstrlen( lpStr ), &Rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE );
      }
   }
   ReleaseDC( hWnd, hDC );
}

