		COMMENT +

		machine language module for the graphical user interface

		+

_AOFF           EQU     6       ;STACK OFFSET TO FIRST ARG

CGA             EQU     1       ;THESE EQUATES ARE EQUIVALENT TO
MCGA            EQU     2       ;THE VALUES RETURNED BY THE
EGA             EQU     3       ;TURBO C DetectGraph FUNCTION
HERCMONO        EQU     7

_AOFF           EQU     6       ;FAR STACK OFFSET

FONTDEPTH       EQU     8
MENULINEDEPTH   EQU     12

;SET ALL FOUR PLANES ON AN EGA OR VGA DISPLAY
FOURPLANES      MACRO
		LOCAL   FPEXIT
		CMP     DS:[_SCREENSEG],0A000H
		JNE     FPEXIT
		MOV     AL,2
		MOV     DX,03C4H
		OUT     DX,AL
		INC     DX
		MOV     AL,0FH
		OUT     DX,AL
FPEXIT:
		ENDM

;THIS MACRO FETCHES THE DATA SEGMENT
DATASEG         MACRO
		PUSH    AX
		MOV     AX,_DATA
		MOV     DS,AX
		POP     AX
		ENDM

;DISPLAY THE MOUSE CURSOR
MOUSEON         MACRO
		MOV     AX,0001H
		INT     33H
		ENDM

;HIDE THE MOUSE CURSOR
MOUSEOFF        MACRO
		MOV     AX,0002H
		INT     33H
		ENDM

;TRANSLATE PIXELS TO BYTES IN AX
PIXELS2BYTES    MACRO
		ADD     AX,0007H
		SHR     AX,1
		SHR     AX,1
		SHR     AX,1
		ENDM

;TRANSLATE PIXELS TO WORDS IN AX
PIXELS2WORDS    MACRO
		ADD     AX,000FH
		SHR     AX,1
		SHR     AX,1
		SHR     AX,1
		SHR     AX,1
		ENDM

APASM_TEXT      SEGMENT BYTE PUBLIC 'CODE'
		ASSUME  CS:APASM_TEXT,DS:_DATA

;DRAW A WHITE RULE ACROSS THE SCREEN
;               ARG1 = DEPTH
;               ARG2 = TOPLINE
		PUBLIC  _WhiteRule
_WhiteRule      PROC    FAR
		PUSH    BP
		MOV     BP,SP

		DATASEG
		FOURPLANES
		MOUSEOFF
		MOV     AX,DS:[_SCREENSEG]
		MOV     ES,AX

		MOV     CX,[BP + _AOFF + 0]
		MOV     BX,[BP + _AOFF + 2]
		SHL     BX,1
		MOV     DX,DS:[_SCREENBYTES]
WR1:            PUSH    CX
		MOV     DI,DS:[_SCREENTBL+BX]
		ADD     BX,2
		MOV     CX,DX
		CLD
		MOV     AL,0FFH
	REPNE   STOSB
		POP     CX
		LOOP    WR1
		MOUSEON
		POP     BP
		RET
_WhiteRule      ENDP

;DRAW A BLACK RULE ACROSS THE SCREEN
;               ARG1 = DEPTH
;               ARG2 = TOPLINE
		PUBLIC  _BlackRule
_BlackRule      PROC    FAR
		PUSH    BP
		MOV     BP,SP

		DATASEG
		FOURPLANES
		MOUSEOFF
		MOV     AX,DS:[_SCREENSEG]
		MOV     ES,AX
		MOV     CX,[BP + _AOFF + 0]
		MOV     BX,[BP + _AOFF + 2]
		SHL     BX,1
		MOV     DX,DS:[_SCREENBYTES]
BR1:            PUSH    CX
		MOV     DI,DS:[_SCREENTBL+BX]
		ADD     BX,2
		MOV     CX,DX
		CLD
		MOV     AL,00H
	REPNE   STOSB
		POP     CX
		LOOP    BR1
		MOUSEON
		POP     BP
		RET
_BlackRule      ENDP

;DRAW A TEXT STRING
;               ARG1 = X
;               ARG2 = Y
;               ARG3 = STRING
;               ARG4 = MASK
		PUBLIC _DrawString
_DrawString     PROC    FAR
		PUSH    BP
		MOV     BP,SP

		DATASEG
		FOURPLANES
		MOUSEOFF
		MOV     AX,DS:[_SCREENSEG]
		MOV     ES,AX

		MOV     CL,3
		SHR     WORD PTR [BP + _AOFF + 0],CL
		MOV     CX,FONTDEPTH
DS1:            PUSH    CX
		DEC     CX

		MOV     AX,[BP + _AOFF + 8]
		XCHG    AH,AL
		MOV     [BP + _AOFF + 8],AX

		MOV     BX,[BP + _AOFF + 2]
		ADD     BX,CX
		SHL     BX,1

		DATASEG
		MOV     DI,DS:[_SCREENTBL+BX]
		ADD     DI,[BP + _AOFF + 0]

		MOV     SI,[BP + _AOFF + 4]
		MOV     DS,[BP + _AOFF + 6]

DS2:            MOV     BH,00H
		MOV     BL,DS:[SI]
		CMP     BL,0
		JE      DS3

		PUSH    DS
		SHL     BX,1
		SHL     BX,1
		SHL     BX,1

		ADD     BX,CX

		DATASEG
		MOV     AL,DS:[_THEFONT+BX]
		AND     AX,[BP + _AOFF + 8]
		NOT     AL
		STOSB

		POP     DS
		INC     SI
		JMP     DS2

DS3:            POP     CX
		LOOP    DS1

DSX:            DATASEG
		MOUSEON
		POP     BP
		RET
_DrawString     ENDP

;CLEAR THE SCREEN TO GREY
		PUBLIC  _ClearScreen
_ClearScreen    PROC    FAR

		MOV     AX,_DATA
		MOV     DS,AX

		MOV     AX,_SCREENSEG
		MOV     ES,AX

		FOURPLANES
		MOUSEOFF

		MOV     CX,_SCREENDEEP
		SUB     CX,MENULINEDEPTH
		MOV     BX,(MENULINEDEPTH*2)

CLS1:           PUSH    CX
		TEST    CX,1
		MOV     AL,0AAH
		JZ      CLS2
		MOV     AL,055H
CLS2:           MOV     DI,[_SCREENTBL+BX]
		MOV     CX,_SCREENBYTES
		CLD
	REPNE   STOSB
		POP     CX
		ADD     BX,2
		LOOP    CLS1

		MOUSEON
		RET
_ClearScreen    ENDP

;SET UP THE SCREEN TABLE
;               ARG1 = CARD TYPE
		PUBLIC  _DoTable
_DoTable        PROC    FAR
		PUSH    BP
		MOV     BP,SP

		DATASEG

		CMP     WORD PTR [BP + _AOFF + 0],CGA
		JNE     NOT_CGA                 ;CHECK CARD TYPE

		;IT'S A CGA CARD
		MOV     _SCREENSEG,0B800H
		MOV     _SCREENBYTES,80
		MOV     _SCREENWIDE,640
		MOV     _SCREENDEEP,200

		MOV     CX,_SCREENDEEP
		SUB     DX,DX
		MOV     SI,OFFSET _SCREENTBL
CTB0:           PUSH    CX
		PUSH    DX
		MOV     AX,_SCREENBYTES ;AX = WIDTH OF TUBE
		MOV     BX,DX           ;BX =
		MOV     CL,1            ;
		SHR     BX,CL           ; ... LINE NUMBER DIV 4
		PUSH    DX
		MUL     BX              ;MUL WIDTH OF SCREEN
		MOV     DI,AX           ;DI IS NOW THE PARTIAL OFFSET
		POP     DX

		SUB     DH,DH           ;
		MOV     AX,2000H        ;MULTIPLY DX MOD 4 BY 2000H
		AND     DX,1
		MUL     DX
		ADD     DI,AX           ;ADD TO THE OFFSET
		POP     DX
		POP     CX

		MOV     BX,DX           ;AND PUT IT ON THE TABLE
		SHL     BX,1
		MOV     [SI+BX],DI
		INC     DX
		LOOP    CTB0
		SUB     AX,AX           ;EVERYTHING'S FINE
		JMP     TABLE_OK

NOT_CGA:        CMP     WORD PTR [BP + _AOFF + 0],EGA
		JNE     NOT_EGA

		;IT'S AN EGA CARD
		MOV     _SCREENSEG,0A000H
		MOV     _SCREENBYTES,80
		MOV     _SCREENWIDE,640
		MOV     _SCREENDEEP,350

		MOV     CX,_SCREENDEEP
		SUB     DX,DX
		MOV     SI,OFFSET _SCREENTBL

ETB0:           PUSH    DX
		MOV     AX,_SCREENBYTES
		MUL     DX
		MOV     [SI],AX
		ADD     SI,2
		POP     DX
		INC     DX
		LOOP    ETBO
		SUB     AX,AX           ;EVERYTHING'S FINE
		JMP     TABLE_OK

NOT_EGA:        CMP     WORD PTR [BP + _AOFF + 0],MCGA
		JNE     NOT_MCGA

		;IT'S AN MCGA CARD
		MOV     _SCREENSEG,0A000H
		MOV     _SCREENBYTES,80
		MOV     _SCRENWIDE,640
		MOV     _SCREENDEEP,480

		MOV     CX,_SCREENDEEP
		SUB     DX,DX
		MOV     SI,OFFSET _SCREENTBL

MTB0:           PUSH    DX
		MOV     AX,_SCREENBYTES
		MUL     DX
		MOV     [SI],AX
		ADD     SI,2
		POP     DX
		INC     DX
		LOOP    MTB0
		SUB     AX,AX           ;EVERYTHING'S FINE
		JMP     TABLE_OK

NOT_MCGA:       CMP     WORD PTR [BP + _AOFF + 0],HERCMONO
		JNE     NOT_HERCMONO

		;IT'S A HERCULES CARD
		MOV     _SCREENSEG,0B000H
		MOV     _SCREENBYTES,90
		MOV     _SCREENWIDE,720
		MOV     _SCREENDEEP,348
		
		MOV     CX,_SCREENDEEP
		SUB     DX,DX
		MOV     SI,OFFSET _SCREENTBL

HTB0:           PUSH    CX
		PUSH    DX
		MOV     AX,_SCREENBYTES ;AX = WIDTH OF TUBE
		MOV     BX,DX           ;BX =
		MOV     CL,2            ;
		SHR     BX,CL           ; ... LINE NUMBER DIV 4
		PUSH    DX
		MUL     BX              ;MUL WIDTH OF SCREEN
		MOV     DI,AX           ;DI IS NOW THE PARTIAL OFFSET
		POP     DX

		SUB     DH,DH           ;
		MOV     AX,2000H        ;MULTIPLY DX MOD 4 BY 2000H
		AND     DX,3
		MUL     DX
		ADD     DI,AX           ;ADD TO THE OFFSET
		POP     DX
		POP     CX

		MOV     SI,OFFSET _SCREENTBL
		MOV     BX,DX
		SHL     BX,1
		MOV     [SI+BX],DI
		INC     DX
		LOOP    HTB0
		SUB     AX,AX           ;EVERYTHING'S FINE
		JMP     TABLE_OK

NOT_HERCMONO:   MOV     AX,-1

TABLE_OK:       POP     BP
		RET
_DoTable        ENDP

;SWITCH TO GRAPHICS MODE
;               ARG1 = CARD TYPE
		PUBLIC  _GraphicsMode
_GraphicsMode   PROC    FAR
		PUSH    BP
		MOV     BP,SP

		DATASEG

		MOV     AX,[BP + _AOFF + 0]
		MOV     GMODE,AX

		CMP     GMODE,CGA
		JNE     NOT_CGA

		MOV     AX,0006H
		INT     10H
		JMP     GRAF_OK

NOT_GCGA:       CMP     GMODE,EGA
		JNE     NOT_GEGA

		MOV     AX,0010H
		INT     10H
		JMP     GRAF_OK

NOT_GEGA:       CMP     GMODE,MCGA
		JNE     NOT_GMCGA
		MOV     AX,0011H
		INT     10H
		JMP     GRAF_OK

NOT_GMCGA:      MOV     DX,03BFH
		MOV     AL,1
		OUT     DX,AL

		MOV     AL,2
		MOV     SI,OFFSET GTABLE
		MOV     BX,0
		MOV     CX,4000H
		CALL    HERC_MODE

GRAF_OK:        POP     BP
		RET
_GraphicsMode   ENDP

;SWITCH TO TEXT MODE
		PUBLIC  _TextMode
_TextMode       PROC    FAR
		PUSH    BP
		MOV     BP,SP

		DATASEG

		CMP     GMODE,HERCMONO
		JE      TEXT_HERC

		MOV     AX,0003H
		INT     10H
		JMP     TEXT_OK

TEXT_HERC:      MOV     DX,03BFH
		XOR     AL,AL
		OUT     DX,AL

		MOV     AX,20H
		MOV     SI,OFFSET TTABLE
		MOV     BX,720H
		MOV     CX,2000H
		CALL    HERC_MODE

TEXT_OK:        POP     BP
		RET
_TextMode       ENDP

;GRAPHICS CARD INITIALIZATION DATA
TTABLE          DB      61H,50H,52H,0FH,19H,06H,19H,19H,02H,0DH,0BH,0CH
GTABLE          DB      35H,2DH,2EH,07H,5BH,02H,57H,57H,02H,03H,00H,00H
GMODE           DW      ?
_DATA           ENDS

_BSS            SEGMENT WORD PUBLIC 'BSS'

_BSS            ENDS

		END



